/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.nio.charset;

import java.util.Arrays;
import org.teavm.classlib.java.nio.TByteBuffer;
import org.teavm.classlib.java.nio.TCharBuffer;
import org.teavm.classlib.java.nio.charset.TCharacterCodingException;
import org.teavm.classlib.java.nio.charset.TCharset;
import org.teavm.classlib.java.nio.charset.TCoderMalfunctionError;
import org.teavm.classlib.java.nio.charset.TCoderResult;
import org.teavm.classlib.java.nio.charset.TCodingErrorAction;

public abstract class TCharsetEncoder {
    private static final int READY = 4;
    private static final int ONGOING = 1;
    private static final int END = 2;
    private static final int FLUSH = 3;
    private static final int INIT = 0;
    private TCharset charset;
    private byte[] replacement;
    private float averageBytesPerChar;
    private float maxBytesPerChar;
    private TCodingErrorAction malformedAction = TCodingErrorAction.REPORT;
    private TCodingErrorAction unmappableAction = TCodingErrorAction.REPORT;
    private int status;

    protected TCharsetEncoder(TCharset cs, float averageBytesPerChar, float maxBytesPerChar, byte[] replacement) {
        this.checkReplacement(replacement);
        this.charset = cs;
        this.replacement = (byte[])replacement.clone();
        this.averageBytesPerChar = averageBytesPerChar;
        this.maxBytesPerChar = maxBytesPerChar;
    }

    protected TCharsetEncoder(TCharset cs, float averageBytesPerChar, float maxBytesPerChar) {
        this(cs, averageBytesPerChar, maxBytesPerChar, new byte[]{63});
    }

    public final TCharset charset() {
        return this.charset;
    }

    public final byte[] replacement() {
        return (byte[])this.replacement.clone();
    }

    public final TCharsetEncoder replaceWith(byte[] newReplacement) {
        this.checkReplacement(newReplacement);
        this.replacement = (byte[])newReplacement.clone();
        this.implReplaceWith(newReplacement);
        return this;
    }

    private void checkReplacement(byte[] replacement) {
        if (replacement == null || replacement.length == 0 || (float)replacement.length < this.maxBytesPerChar) {
            throw new IllegalArgumentException("Replacement preconditions do not hold");
        }
    }

    protected void implReplaceWith(byte[] newReplacement) {
    }

    public TCodingErrorAction malformedInputAction() {
        return this.malformedAction;
    }

    public final TCharsetEncoder onMalformedInput(TCodingErrorAction newAction) {
        if (newAction == null) {
            throw new IllegalArgumentException("Action must be non-null");
        }
        this.malformedAction = newAction;
        this.implOnMalformedInput(newAction);
        return this;
    }

    protected void implOnMalformedInput(TCodingErrorAction newAction) {
    }

    public TCodingErrorAction unmappableCharacterAction() {
        return this.unmappableAction;
    }

    public final TCharsetEncoder onUnmappableCharacter(TCodingErrorAction newAction) {
        if (newAction == null) {
            throw new IllegalArgumentException("Action must be non-null");
        }
        this.unmappableAction = newAction;
        this.implOnUnmappableCharacter(newAction);
        return this;
    }

    protected void implOnUnmappableCharacter(TCodingErrorAction newAction) {
    }

    public final float averageBytesPerChar() {
        return this.averageBytesPerChar;
    }

    public final float maxBytesPerChar() {
        return this.maxBytesPerChar;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final TCoderResult encode(TCharBuffer in, TByteBuffer out, boolean endOfInput) {
        if (this.status == 3 || !endOfInput && this.status == 2) {
            throw new IllegalStateException();
        }
        this.status = endOfInput ? 2 : 1;
        while (true) {
            TCodingErrorAction action;
            TCoderResult result;
            try {
                result = this.encodeLoop(in, out);
            }
            catch (RuntimeException e) {
                throw new TCoderMalfunctionError(e);
            }
            if (result.isUnderflow()) {
                if (!endOfInput) return result;
                int remaining = in.remaining();
                if (remaining <= 0) return result;
                result = TCoderResult.malformedForLength(remaining);
            } else if (result.isOverflow()) {
                return result;
            }
            TCodingErrorAction tCodingErrorAction = action = result.isUnmappable() ? this.unmappableAction : this.malformedAction;
            if (action == TCodingErrorAction.REPLACE) {
                if (out.remaining() < this.replacement.length) {
                    return TCoderResult.OVERFLOW;
                }
                out.put(this.replacement);
            } else if (action != TCodingErrorAction.IGNORE) {
                return result;
            }
            in.position(in.position() + result.length());
        }
    }

    public final TByteBuffer encode(TCharBuffer in) throws TCharacterCodingException {
        TCoderResult result;
        if (in.remaining() == 0) {
            return TByteBuffer.allocate(0);
        }
        this.reset();
        TByteBuffer output = TByteBuffer.allocate((int)((float)in.remaining() * this.averageBytesPerChar));
        while ((result = this.encode(in, output, false)) != TCoderResult.UNDERFLOW) {
            if (result == TCoderResult.OVERFLOW) {
                output = this.allocateMore(output);
                continue;
            }
            if (!result.isError()) continue;
            result.throwException();
        }
        result = this.encode(in, output, true);
        if (result.isError()) {
            result.throwException();
        }
        while (!(result = this.flush(output)).isUnderflow()) {
            if (!result.isOverflow()) continue;
            output = this.allocateMore(output);
        }
        output.flip();
        return output;
    }

    protected abstract TCoderResult encodeLoop(TCharBuffer var1, TByteBuffer var2);

    public boolean canEncode(char c) {
        return this.implCanEncode(TCharBuffer.wrap(new char[]{c}));
    }

    private boolean implCanEncode(TCharBuffer cb) {
        if (this.status == 3 || this.status == 0) {
            this.status = 4;
        }
        if (this.status != 4) {
            throw new IllegalStateException();
        }
        TCodingErrorAction malformBak = this.malformedAction;
        TCodingErrorAction unmapBak = this.unmappableAction;
        this.onMalformedInput(TCodingErrorAction.REPORT);
        this.onUnmappableCharacter(TCodingErrorAction.REPORT);
        boolean result = true;
        try {
            this.encode(cb);
        }
        catch (TCharacterCodingException e) {
            result = false;
        }
        this.onMalformedInput(malformBak);
        this.onUnmappableCharacter(unmapBak);
        this.reset();
        return result;
    }

    public boolean canEncode(CharSequence sequence) {
        TCharBuffer cb = sequence instanceof TCharBuffer ? ((TCharBuffer)sequence).duplicate() : TCharBuffer.wrap(sequence);
        return this.implCanEncode(cb);
    }

    private TByteBuffer allocateMore(TByteBuffer buffer) {
        byte[] array = buffer.array();
        array = Arrays.copyOf(array, array.length * 2);
        TByteBuffer result = TByteBuffer.wrap(array);
        result.position(buffer.position());
        return result;
    }

    public final TCoderResult flush(TByteBuffer out) {
        if (this.status != 2 && this.status != 4) {
            throw new IllegalStateException();
        }
        TCoderResult result = this.implFlush(out);
        if (result == TCoderResult.UNDERFLOW) {
            this.status = 3;
        }
        return result;
    }

    protected TCoderResult implFlush(TByteBuffer out) {
        return TCoderResult.UNDERFLOW;
    }

    public final TCharsetEncoder reset() {
        this.status = 0;
        this.implReset();
        return this;
    }

    protected void implReset() {
    }
}

