/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.nio;

import org.teavm.classlib.java.nio.TBufferOverflowException;
import org.teavm.classlib.java.nio.TBufferUnderflowException;
import org.teavm.classlib.java.nio.TFloatBuffer;
import org.teavm.classlib.java.nio.TReadOnlyBufferException;

abstract class TFloatBufferImpl
extends TFloatBuffer {
    public TFloatBufferImpl(int capacity, int position, int limit) {
        super(capacity, position, limit);
    }

    @Override
    public TFloatBuffer slice() {
        return this.duplicate(this.position, this.limit - this.position, 0, this.limit - this.position, this.isReadOnly());
    }

    @Override
    public TFloatBuffer duplicate() {
        return this.duplicate(0, this.capacity, this.position, this.limit, this.isReadOnly());
    }

    @Override
    public TFloatBuffer asReadOnlyBuffer() {
        return this.duplicate(0, this.capacity, this.position, this.limit, true);
    }

    abstract TFloatBuffer duplicate(int var1, int var2, int var3, int var4, boolean var5);

    @Override
    public float get() {
        if (this.position >= this.limit) {
            throw new TBufferUnderflowException();
        }
        return this.getElement(this.position++);
    }

    @Override
    public TFloatBuffer put(float b) {
        if (this.isReadOnly()) {
            throw new TReadOnlyBufferException();
        }
        if (this.position >= this.limit) {
            throw new TBufferOverflowException();
        }
        this.putElement(this.position++, b);
        return this;
    }

    @Override
    public float get(int index) {
        if (index < 0 || index >= this.limit) {
            throw new IndexOutOfBoundsException("Index " + index + " is outside of range [0;" + this.limit + ")");
        }
        return this.getElement(index);
    }

    @Override
    public TFloatBuffer put(int index, float b) {
        if (this.isReadOnly()) {
            throw new TReadOnlyBufferException();
        }
        if (index < 0 || index >= this.limit) {
            throw new IndexOutOfBoundsException("Index " + index + " is outside of range [0;" + this.limit + ")");
        }
        this.putElement(index, b);
        return this;
    }

    @Override
    public TFloatBuffer compact() {
        if (this.isReadOnly()) {
            throw new TReadOnlyBufferException();
        }
        int sz = this.remaining();
        if (this.position > 0) {
            int src = this.position;
            for (int i = 0; i < sz; ++i) {
                this.putElement(i, this.getElement(src++));
            }
        }
        this.position = sz;
        this.limit = this.capacity;
        this.mark = -1;
        return this;
    }

    @Override
    public boolean isDirect() {
        return false;
    }

    @Override
    public boolean isReadOnly() {
        return this.readOnly();
    }

    abstract boolean readOnly();
}

