/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.lang.reflect;

import org.teavm.classlib.impl.reflection.Converter;
import org.teavm.classlib.impl.reflection.Flags;
import org.teavm.classlib.impl.reflection.JSCallable;
import org.teavm.classlib.java.lang.TClass;
import org.teavm.classlib.java.lang.TIllegalAccessException;
import org.teavm.classlib.java.lang.TIllegalArgumentException;
import org.teavm.classlib.java.lang.TInstantiationException;
import org.teavm.classlib.java.lang.TObject;
import org.teavm.classlib.java.lang.reflect.TAccessibleObject;
import org.teavm.classlib.java.lang.reflect.TInvocationTargetException;
import org.teavm.classlib.java.lang.reflect.TMember;
import org.teavm.classlib.java.lang.reflect.TModifier;
import org.teavm.platform.PlatformObject;
import org.teavm.platform.PlatformSequence;

public class TConstructor<T>
extends TAccessibleObject
implements TMember {
    private TClass<T> declaringClass;
    private String name;
    private int modifiers;
    private int accessLevel;
    private TClass<?>[] parameterTypes;
    private JSCallable callable;

    public TConstructor(TClass<T> declaringClass, String name, int modifiers, int accessLevel, TClass<?>[] parameterTypes, JSCallable callable) {
        this.declaringClass = declaringClass;
        this.name = name;
        this.modifiers = modifiers;
        this.accessLevel = accessLevel;
        this.parameterTypes = parameterTypes;
        this.callable = callable;
    }

    public TClass<T> getDeclaringClass() {
        return this.declaringClass;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int getModifiers() {
        return Flags.getModifiers(this.modifiers, this.accessLevel);
    }

    @Override
    public boolean isSynthetic() {
        return (this.modifiers & 0x20) != 0;
    }

    public TClass<?>[] getParameterTypes() {
        return (TClass[])this.parameterTypes.clone();
    }

    public int getParameterCount() {
        return this.parameterTypes.length;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(TModifier.toString(this.getModifiers()));
        if (sb.length() > 0) {
            sb.append(' ');
        }
        sb.append(this.declaringClass.getName().toString()).append('(');
        TClass<?>[] parameterTypes = this.getParameterTypes();
        for (int i = 0; i < parameterTypes.length; ++i) {
            if (i > 0) {
                sb.append(',');
            }
            sb.append(parameterTypes[i].getName());
        }
        return sb.append(')').toString();
    }

    public T newInstance(Object ... initargs) throws TInstantiationException, TIllegalAccessException, TIllegalArgumentException, TInvocationTargetException {
        if ((this.modifiers & 1) != 0) {
            throw new TInstantiationException();
        }
        if (this.callable == null) {
            throw new TIllegalAccessException();
        }
        if (initargs.length != this.parameterTypes.length) {
            throw new TIllegalArgumentException();
        }
        for (int i = 0; i < initargs.length; ++i) {
            if (!this.parameterTypes[i].isPrimitive() && initargs[i] != null && !this.parameterTypes[i].isInstance((TObject)initargs[i])) {
                throw new TIllegalArgumentException();
            }
            if (!this.parameterTypes[i].isPrimitive() || initargs[i] != null) continue;
            throw new TIllegalArgumentException();
        }
        PlatformSequence<PlatformObject> jsArgs = Converter.arrayFromJava(initargs);
        PlatformObject instance = this.declaringClass.newEmptyInstance();
        this.callable.call(instance, jsArgs);
        return (T)Converter.toJava(instance);
    }

    public boolean isVarArgs() {
        return (this.modifiers & 0x2000) != 0;
    }
}

