/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.impl.currency;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import org.teavm.model.MethodReference;
import org.teavm.platform.metadata.MetadataGenerator;
import org.teavm.platform.metadata.MetadataGeneratorContext;
import org.teavm.platform.metadata.Resource;
import org.teavm.platform.metadata.ResourceMap;
import org.teavm.platform.metadata.StringResource;

public class CountriesGenerator
implements MetadataGenerator {
    /*
     * Enabled aggressive exception aggregation
     */
    public Resource generateMetadata(MetadataGeneratorContext context, MethodReference method) {
        try (BufferedInputStream input = new BufferedInputStream(context.getClassLoader().getResourceAsStream("org/teavm/classlib/impl/currency/iso3166.csv"));){
            ResourceMap<StringResource> resourceMap;
            try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)input, StandardCharsets.UTF_8));){
                resourceMap = this.readIso3166(context, reader);
            }
            return resourceMap;
        }
        catch (IOException e) {
            throw new RuntimeException("Error reading ISO 3166 table", e);
        }
    }

    private ResourceMap<StringResource> readIso3166(MetadataGeneratorContext context, BufferedReader reader) throws IOException {
        String line;
        ResourceMap result = context.createResourceMap();
        int index = 0;
        while ((line = reader.readLine()) != null) {
            if (index++ == 0 || line.trim().isEmpty()) continue;
            String[] cells = this.readCsvRow(index - 1, line);
            StringResource currency = (StringResource)context.createResource(StringResource.class);
            currency.setValue(cells[7]);
            result.put(cells[10], (Resource)currency);
        }
        return result;
    }

    private String[] readCsvRow(int rowIndex, String row) {
        ArrayList<String> values = new ArrayList<String>();
        int index = 0;
        while (index < row.length()) {
            char c = row.charAt(index);
            int next = index++;
            if (c == '\"') {
                StringBuilder sb = new StringBuilder();
                while (index < row.length()) {
                    next = row.indexOf(34, index);
                    if (next == -1) {
                        throw new IllegalStateException("Syntax error at row " + rowIndex + ": closing quote not found");
                    }
                    if (next + 1 == row.length() || row.charAt(next + 1) != '\"') {
                        sb.append(row, index, next);
                        index = next + 1;
                        break;
                    }
                    index = next + 2;
                }
                if (index < row.length() && row.charAt(index) != ',') {
                    throw new IllegalStateException("Syntax error at row " + rowIndex + ": closing quote must be followed by either line separator or comma");
                }
                values.add(sb.toString());
                continue;
            }
            next = row.indexOf(44, index);
            if (next == -1) {
                values.add(row.substring(index));
                index = row.length();
                continue;
            }
            values.add(row.substring(index, next));
            index = ++next;
        }
        return values.toArray(new String[0]);
    }
}

