/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.util.concurrent.atomic;

import org.teavm.classlib.java.lang.TObject;
import org.teavm.classlib.java.lang.reflect.TField;
import org.teavm.classlib.java.util.concurrent.atomic.TAtomicLongFieldUpdater;

class TReflectionBasedAtomicLongFieldUpdater<T>
extends TAtomicLongFieldUpdater<T> {
    private TField field;

    TReflectionBasedAtomicLongFieldUpdater(TField field) {
        this.field = field;
    }

    @Override
    public boolean compareAndSet(T obj, long expect, long update) {
        this.checkInstance(obj);
        if ((Long)this.field.getWithoutCheck(obj) != expect) {
            return false;
        }
        this.field.setWithoutCheck(obj, update);
        return true;
    }

    @Override
    public boolean weakCompareAndSet(T obj, long expect, long update) {
        return this.compareAndSet(obj, expect, update);
    }

    @Override
    public void set(T obj, long newValue) {
        this.checkInstance(obj);
        this.field.setWithoutCheck(obj, newValue);
    }

    @Override
    public void lazySet(T obj, long newValue) {
        this.set(obj, newValue);
    }

    @Override
    public long get(T obj) {
        this.checkInstance(obj);
        return (Long)this.field.getWithoutCheck(obj);
    }

    private void checkInstance(T obj) {
        if (!this.field.getDeclaringClass().isInstance((TObject)obj)) {
            throw new ClassCastException();
        }
    }
}

