/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.util;

import org.teavm.classlib.java.lang.TIndexOutOfBoundsException;
import org.teavm.classlib.java.util.TAbstractList;
import org.teavm.classlib.java.util.TCollection;
import org.teavm.classlib.java.util.TIterator;
import org.teavm.classlib.java.util.TListIterator;

public abstract class TAbstractSequentialList<E>
extends TAbstractList<E> {
    @Override
    public E get(int index) {
        if (index < 0) {
            throw new TIndexOutOfBoundsException();
        }
        TListIterator<E> iter = this.listIterator(index);
        return iter.next();
    }

    @Override
    public E set(int index, E element) {
        if (index < 0) {
            throw new TIndexOutOfBoundsException();
        }
        TListIterator<E> iter = this.listIterator(index);
        Object old = iter.next();
        iter.set(element);
        return old;
    }

    @Override
    public void add(int index, E element) {
        if (index < 0) {
            throw new TIndexOutOfBoundsException();
        }
        TListIterator<E> iter = this.listIterator(index);
        iter.add(element);
    }

    @Override
    public E remove(int index) {
        if (index < 0) {
            throw new TIndexOutOfBoundsException();
        }
        TListIterator<E> iter = this.listIterator(index);
        Object elem = iter.next();
        iter.remove();
        return elem;
    }

    @Override
    public boolean addAll(int index, TCollection<? extends E> c) {
        if (index < 0) {
            throw new TIndexOutOfBoundsException();
        }
        TListIterator iter = this.listIterator(index);
        boolean added = false;
        TIterator srcIter = c.iterator();
        while (srcIter.hasNext()) {
            iter.add(srcIter.next());
            added = true;
        }
        return added;
    }

    @Override
    public TIterator<E> iterator() {
        return this.listIterator();
    }

    @Override
    public abstract TListIterator<E> listIterator(int var1);
}

