/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.util.stream.doubleimpl;

import java.util.NoSuchElementException;
import java.util.PrimitiveIterator;
import org.teavm.classlib.java.util.stream.doubleimpl.TSimpleDoubleStreamImpl;

public class TSimpleDoubleStreamIterator
implements PrimitiveIterator.OfDouble {
    private static final byte NEEDS_MORE = 0;
    private static final byte HAS_DATA = 1;
    private static final byte LAST_ELEMENT = 2;
    private static final byte DONE = 3;
    private TSimpleDoubleStreamImpl stream;
    private double lastElement;
    private byte state;

    public TSimpleDoubleStreamIterator(TSimpleDoubleStreamImpl stream) {
        this.stream = stream;
    }

    @Override
    public boolean hasNext() {
        this.fetchIfNeeded();
        return this.state != 3;
    }

    @Override
    public double nextDouble() {
        this.fetchIfNeeded();
        if (this.state == 3) {
            throw new NoSuchElementException();
        }
        double result = this.lastElement;
        this.state = (byte)(this.state == 2 ? 3 : 0);
        return result;
    }

    private void fetchIfNeeded() {
        if (this.state != 0) {
            return;
        }
        boolean hasMore = this.stream.next(e -> {
            this.lastElement = e;
            return false;
        });
        this.state = (byte)(hasMore ? 1 : 2);
        if (this.state == 2) {
            this.stream = null;
        }
    }
}

