/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.util.regex;

import org.teavm.classlib.java.util.regex.TAbstractSet;
import org.teavm.classlib.java.util.regex.TCharSet;
import org.teavm.classlib.java.util.regex.TLeafSet;
import org.teavm.classlib.java.util.regex.TMatchResultImpl;
import org.teavm.classlib.java.util.regex.TRangeSet;
import org.teavm.classlib.java.util.regex.TSupplCharSet;
import org.teavm.classlib.java.util.regex.TSupplRangeSet;

class TSequenceSet
extends TLeafSet {
    private String string;
    private IntHash leftToRight;
    private IntHash rightToLeft;

    TSequenceSet(StringBuffer substring) {
        this.string = substring.toString();
        this.charCount = substring.length();
        this.leftToRight = new IntHash(this.charCount);
        this.rightToLeft = new IntHash(this.charCount);
        for (int j = 0; j < this.charCount - 1; ++j) {
            this.leftToRight.put(this.string.charAt(j), this.charCount - j - 1);
            this.rightToLeft.put(this.string.charAt(this.charCount - j - 1), this.charCount - j - 1);
        }
    }

    @Override
    public int accepts(int strIndex, CharSequence testString) {
        return this.startsWith(testString, strIndex) ? this.charCount : -1;
    }

    @Override
    public int find(int strIndex, CharSequence testString, TMatchResultImpl matchResult) {
        int strLength = matchResult.getRightBound();
        while (strIndex <= strLength) {
            if ((strIndex = this.indexOf(testString, strIndex, strLength)) < 0) {
                return -1;
            }
            if (this.next.matches(strIndex + this.charCount, testString, matchResult) >= 0) {
                return strIndex;
            }
            ++strIndex;
        }
        return -1;
    }

    @Override
    public int findBack(int strIndex, int lastIndex, CharSequence testString, TMatchResultImpl matchResult) {
        while (lastIndex >= strIndex) {
            if ((lastIndex = this.lastIndexOf(testString, strIndex, lastIndex)) < 0) {
                return -1;
            }
            if (this.next.matches(lastIndex + this.charCount, testString, matchResult) >= 0) {
                return lastIndex;
            }
            --lastIndex;
        }
        return -1;
    }

    @Override
    public String getName() {
        return "sequence: " + this.string;
    }

    @Override
    public boolean first(TAbstractSet set) {
        if (set instanceof TCharSet) {
            return ((TCharSet)set).getChar() == this.string.charAt(0);
        }
        if (set instanceof TRangeSet) {
            return ((TRangeSet)set).accepts(0, this.string.substring(0, 1)) > 0;
        }
        if (set instanceof TSupplRangeSet) {
            return ((TSupplRangeSet)set).contains(this.string.charAt(0)) || this.string.length() > 1 && ((TSupplRangeSet)set).contains(Character.toCodePoint(this.string.charAt(0), this.string.charAt(1)));
        }
        if (set instanceof TSupplCharSet) {
            return this.string.length() > 1 && ((TSupplCharSet)set).getCodePoint() == Character.toCodePoint(this.string.charAt(0), this.string.charAt(1));
        }
        return true;
    }

    protected int indexOf(CharSequence str, int from, int to) {
        char ch;
        char last = this.string.charAt(this.charCount - 1);
        for (int i = from; i <= to - this.charCount; i += this.leftToRight.get(ch)) {
            ch = str.charAt(i + this.charCount - 1);
            if (ch != last || !this.startsWith(str, i)) continue;
            return i;
        }
        return -1;
    }

    protected int lastIndexOf(CharSequence str, int to, int from) {
        int i;
        char first = this.string.charAt(0);
        int size = str.length();
        int delta = size - from - this.charCount;
        int n = i = delta > 0 ? from : from + delta;
        while (i >= to) {
            char ch = str.charAt(i);
            if (ch == first && this.startsWith(str, i)) {
                return i;
            }
            i -= this.rightToLeft.get(ch);
        }
        return -1;
    }

    protected boolean startsWith(CharSequence str, int from) {
        for (int i = 0; i < this.charCount; ++i) {
            if (str.charAt(i + from) == this.string.charAt(i)) continue;
            return false;
        }
        return true;
    }

    static class IntHash {
        int[] table;
        int[] values;
        int mask;
        int size;

        public IntHash(int size) {
            while (size >= this.mask) {
                this.mask = this.mask << 1 | 1;
            }
            this.mask = this.mask << 1 | 1;
            this.table = new int[this.mask + 1];
            this.values = new int[this.mask + 1];
            this.size = size;
        }

        public void put(int key, int value) {
            int i = 0;
            int hashCode = key & this.mask;
            while (true) {
                if (this.table[hashCode] == 0 || this.table[hashCode] == key) {
                    this.table[hashCode] = key;
                    this.values[hashCode] = value;
                    return;
                }
                ++i;
                hashCode += (i &= this.mask);
                hashCode &= this.mask;
            }
        }

        public int get(int key) {
            int hashCode = key & this.mask;
            int i = 0;
            int storedKey;
            while ((storedKey = this.table[hashCode]) != 0) {
                if (storedKey == key) {
                    return this.values[hashCode];
                }
                ++i;
                hashCode += (i &= this.mask);
                hashCode &= this.mask;
            }
            return this.size;
        }
    }
}

