/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.util.concurrent.atomic;

import java.io.Serializable;
import java.util.function.IntBinaryOperator;
import java.util.function.IntUnaryOperator;

public class TAtomicInteger
extends Number
implements Serializable {
    private int value;
    private int version;

    public TAtomicInteger() {
    }

    public TAtomicInteger(int value) {
        this.value = value;
    }

    public final int get() {
        return this.value;
    }

    public final void set(int newValue) {
        this.value = newValue;
        ++this.version;
    }

    public final void lazySet(int newValue) {
        this.value = newValue;
        ++this.version;
    }

    public final int getAndSet(int newValue) {
        int result = this.value;
        this.value = newValue;
        ++this.version;
        return result;
    }

    public final boolean compareAndSet(int expect, int update) {
        if (this.value != expect) {
            return false;
        }
        this.value = update;
        ++this.version;
        return true;
    }

    public final boolean weakCompareAndSet(int expect, int update) {
        if (this.value != expect) {
            return false;
        }
        this.value = update;
        ++this.version;
        return true;
    }

    public final int getAndIncrement() {
        ++this.version;
        return this.value++;
    }

    public final int getAndDecrement() {
        ++this.version;
        return this.value--;
    }

    public final int getAndAdd(int delta) {
        ++this.version;
        int result = this.value;
        this.value += delta;
        return result;
    }

    public final int incrementAndGet() {
        ++this.version;
        return ++this.value;
    }

    public final int decrementAndGet() {
        ++this.version;
        return --this.value;
    }

    public final int addAndGet(int delta) {
        ++this.version;
        this.value += delta;
        return this.value;
    }

    public final int getAndUpdate(IntUnaryOperator updateFunction) {
        int newValue;
        int result;
        int expectedVersion;
        do {
            expectedVersion = this.version;
            result = this.value;
            newValue = updateFunction.applyAsInt(this.value);
        } while (expectedVersion != this.version);
        ++this.version;
        this.value = newValue;
        return result;
    }

    public final int updateAndGet(IntUnaryOperator updateFunction) {
        int newValue;
        int expectedVersion;
        do {
            expectedVersion = this.version;
            newValue = updateFunction.applyAsInt(this.value);
        } while (expectedVersion != this.version);
        ++this.version;
        this.value = newValue;
        return newValue;
    }

    public final int getAndAccumulate(int x, IntBinaryOperator accumulatorFunction) {
        int newValue;
        int result;
        int expectedVersion;
        do {
            expectedVersion = this.version;
            result = this.value;
            newValue = accumulatorFunction.applyAsInt(this.value, x);
        } while (expectedVersion != this.version);
        ++this.version;
        this.value = newValue;
        return result;
    }

    public final int accumulateAndGet(int x, IntBinaryOperator accumulatorFunction) {
        int newValue;
        int expectedVersion;
        do {
            expectedVersion = this.version;
            newValue = accumulatorFunction.applyAsInt(this.value, x);
        } while (expectedVersion != this.version);
        ++this.version;
        this.value = newValue;
        return newValue;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    @Override
    public int intValue() {
        return this.value;
    }

    @Override
    public long longValue() {
        return this.value;
    }

    @Override
    public float floatValue() {
        return this.value;
    }

    @Override
    public double doubleValue() {
        return this.value;
    }
}

