/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.net;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.teavm.classlib.java.net.TMalformedURLException;
import org.teavm.classlib.java.net.TURI;
import org.teavm.classlib.java.net.TURISyntaxException;
import org.teavm.classlib.java.net.TURLConnection;
import org.teavm.classlib.java.net.TURLStreamHandler;
import org.teavm.classlib.java.net.TURLStreamHandlerFactory;
import org.teavm.classlib.java.net.impl.TDummyStreamHandler;
import org.teavm.classlib.java.net.impl.TXHRStreamHandler;

public final class TURL
implements Serializable {
    private int hashCode;
    private String file;
    private String protocol;
    private String host;
    private int port = -1;
    private String authority;
    private transient String userInfo;
    private transient String path;
    private transient String query;
    private String ref;
    private static Map<String, TURLStreamHandler> streamHandlers = new HashMap<String, TURLStreamHandler>();
    transient TURLStreamHandler strmHandler;
    private static TURLStreamHandlerFactory streamHandlerFactory;

    public static void setURLStreamHandlerFactory(TURLStreamHandlerFactory streamFactory) {
        Objects.requireNonNull(streamFactory);
        streamHandlers.clear();
        streamHandlerFactory = streamFactory;
    }

    public TURL(String spec) throws TMalformedURLException {
        this(null, spec, (TURLStreamHandler)null);
    }

    public TURL(TURL context, String spec) throws TMalformedURLException {
        this(context, spec, null);
    }

    public TURL(TURL context, String spec, TURLStreamHandler handler) throws TMalformedURLException {
        int index;
        this.strmHandler = handler;
        if (spec == null) {
            throw new TMalformedURLException();
        }
        spec = spec.trim();
        try {
            index = spec.indexOf(58);
        }
        catch (NullPointerException e) {
            throw new TMalformedURLException(e.toString());
        }
        int startIPv6Addr = spec.indexOf(91);
        if (index >= 0 && (startIPv6Addr == -1 || index < startIPv6Addr)) {
            this.protocol = spec.substring(0, index);
            char c = this.protocol.charAt(0);
            boolean valid = 'a' <= c && c <= 'z' || 'A' <= c && c <= 'Z';
            for (int i = 1; valid && i < this.protocol.length(); ++i) {
                c = this.protocol.charAt(i);
                valid = 'a' <= c && c <= 'z' || 'A' <= c && c <= 'Z' || '0' <= c && c <= '9' || c == '+' || c == '-' || c == '.';
            }
            if (!valid) {
                this.protocol = null;
                index = -1;
            } else {
                this.protocol = this.protocol.toLowerCase();
            }
        }
        if (this.protocol != null) {
            if (context != null && this.protocol.equals(context.getProtocol())) {
                String cPath = context.getPath();
                if (cPath != null && cPath.startsWith("/")) {
                    this.set(this.protocol, context.getHost(), context.getPort(), context.getAuthority(), context.getUserInfo(), cPath, context.getQuery(), null);
                }
                if (this.strmHandler == null) {
                    this.strmHandler = context.strmHandler;
                }
            }
        } else {
            if (context == null) {
                throw new TMalformedURLException();
            }
            this.set(context.getProtocol(), context.getHost(), context.getPort(), context.getAuthority(), context.getUserInfo(), context.getPath(), context.getQuery(), null);
            if (this.strmHandler == null) {
                this.strmHandler = context.strmHandler;
            }
        }
        if (this.strmHandler == null) {
            this.setupStreamHandler();
            if (this.strmHandler == null) {
                throw new TMalformedURLException();
            }
        }
        try {
            this.strmHandler.parseURL(this, spec, ++index, spec.length());
        }
        catch (Exception e) {
            throw new TMalformedURLException(e.toString());
        }
        if (this.port < -1) {
            throw new TMalformedURLException();
        }
    }

    public TURL(String protocol, String host, String file) throws TMalformedURLException {
        this(protocol, host, -1, file, null);
    }

    public TURL(String protocol, String host, int port, String file) throws TMalformedURLException {
        this(protocol, host, port, file, null);
    }

    public TURL(String protocol, String host, int port, String file, TURLStreamHandler handler) throws TMalformedURLException {
        if (port < -1) {
            throw new TMalformedURLException();
        }
        if (host != null && host.contains(":") && host.charAt(0) != '[') {
            host = "[" + host + "]";
        }
        Objects.requireNonNull(protocol);
        this.protocol = protocol;
        this.host = host;
        this.port = port;
        int index = file.indexOf("#", file.lastIndexOf("/"));
        if (index >= 0) {
            this.file = file.substring(0, index);
            this.ref = file.substring(index + 1);
        } else {
            this.file = file;
        }
        this.fixURL(false);
        if (handler == null) {
            this.setupStreamHandler();
            if (this.strmHandler == null) {
                throw new TMalformedURLException();
            }
        } else {
            this.strmHandler = handler;
        }
    }

    void fixURL(boolean fixHost) {
        int index;
        if (this.host != null && this.host.length() > 0) {
            this.authority = this.host;
            if (this.port != -1) {
                this.authority = this.authority + ":" + this.port;
            }
        }
        if (fixHost) {
            index = -1;
            if (this.host != null) {
                index = this.host.lastIndexOf(64);
            }
            if (index >= 0) {
                this.userInfo = this.host.substring(0, index);
                this.host = this.host.substring(index + 1);
            } else {
                this.userInfo = null;
            }
        }
        index = -1;
        if (this.file != null) {
            index = this.file.indexOf(63);
        }
        if (index >= 0) {
            this.query = this.file.substring(index + 1);
            this.path = this.file.substring(0, index);
        } else {
            this.query = null;
            this.path = this.file;
        }
    }

    protected void set(String protocol, String host, int port, String file, String ref) {
        if (this.protocol == null) {
            this.protocol = protocol;
        }
        this.host = host;
        this.file = file;
        this.port = port;
        this.ref = ref;
        this.hashCode = 0;
        this.fixURL(true);
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (this.getClass() != o.getClass()) {
            return false;
        }
        return this.strmHandler.equals(this, (TURL)o);
    }

    public boolean sameFile(TURL otherURL) {
        return this.strmHandler.sameFile(this, otherURL);
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = this.strmHandler.hashCode(this);
        }
        return this.hashCode;
    }

    void setupStreamHandler() {
        this.strmHandler = streamHandlers.get(this.protocol);
        if (this.strmHandler != null) {
            return;
        }
        if (streamHandlerFactory != null) {
            this.strmHandler = streamHandlerFactory.createURLStreamHandler(this.protocol);
            if (this.strmHandler != null) {
                streamHandlers.put(this.protocol, this.strmHandler);
                return;
            }
        }
        switch (this.protocol) {
            case "http": 
            case "https": {
                this.strmHandler = new TXHRStreamHandler();
                break;
            }
            case "ftp": {
                this.strmHandler = new TDummyStreamHandler(21);
                break;
            }
            default: {
                this.strmHandler = new TDummyStreamHandler(-1);
            }
        }
    }

    public InputStream openStream() throws IOException {
        return this.openConnection().getInputStream();
    }

    public TURLConnection openConnection() throws IOException {
        return this.strmHandler.openConnection(this);
    }

    public TURI toURI() throws TURISyntaxException {
        return new TURI(this.toExternalForm());
    }

    public String toString() {
        return this.toExternalForm();
    }

    public String toExternalForm() {
        if (this.strmHandler == null) {
            return "unknown protocol(" + this.protocol + ")://" + this.host + this.file;
        }
        return this.strmHandler.toExternalForm(this);
    }

    public String getFile() {
        return this.file;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getRef() {
        return this.ref;
    }

    public String getQuery() {
        return this.query;
    }

    public String getPath() {
        return this.path;
    }

    public String getUserInfo() {
        return this.userInfo;
    }

    public String getAuthority() {
        return this.authority;
    }

    protected void set(String protocol, String host, int port, String authority, String userInfo, String path, String query, String ref) {
        String filePart = path;
        if (query != null && !query.isEmpty()) {
            filePart = filePart != null ? filePart + "?" + query : "?" + query;
        }
        this.set(protocol, host, port, filePart, ref);
        this.authority = authority;
        this.userInfo = userInfo;
        this.path = path;
        this.query = query;
    }

    public int getDefaultPort() {
        return this.strmHandler.getDefaultPort();
    }
}

