/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import org.teavm.classlib.java.io.TPipedOutputStream;

public class TPipedInputStream
extends InputStream {
    private Thread lastReader;
    private Thread lastWriter;
    private boolean isClosed;
    protected byte[] buffer;
    protected int in = -1;
    protected int out;
    protected static final int PIPE_SIZE = 1024;
    boolean isConnected;

    public TPipedInputStream() {
    }

    public TPipedInputStream(TPipedOutputStream out) throws IOException {
        this.connect(out);
    }

    @Override
    public int available() throws IOException {
        if (this.buffer == null || this.in == -1) {
            return 0;
        }
        return this.in <= this.out ? this.buffer.length - this.out + this.in : this.in - this.out;
    }

    @Override
    public void close() throws IOException {
        if (this.buffer != null) {
            this.buffer = null;
        }
    }

    public void connect(TPipedOutputStream src) throws IOException {
        src.connect(this);
    }

    @Override
    public synchronized int read() throws IOException {
        if (!this.isConnected) {
            throw new IOException("Not connected");
        }
        if (this.buffer == null) {
            throw new IOException("InputStream is closed");
        }
        if (this.isClosed && this.in == -1) {
            return -1;
        }
        if (this.lastWriter != null && !this.lastWriter.isAlive() && this.in < 0) {
            throw new IOException("Write end dead");
        }
        this.lastReader = Thread.currentThread();
        try {
            int attempts = 3;
            while (this.in == -1) {
                if (this.isClosed) {
                    return -1;
                }
                if (attempts-- <= 0 && this.lastWriter != null && !this.lastWriter.isAlive()) {
                    throw new IOException("Pipe broken");
                }
                this.notifyAll();
                this.wait(1000L);
            }
        }
        catch (InterruptedException e) {
            throw new InterruptedIOException();
        }
        byte result = this.buffer[this.out++];
        if (this.out == this.buffer.length) {
            this.out = 0;
        }
        if (this.out == this.in) {
            this.in = -1;
            this.out = 0;
        }
        return result & 0xFF;
    }

    @Override
    public synchronized int read(byte[] bytes, int offset, int count) throws IOException {
        if (bytes == null) {
            throw new NullPointerException();
        }
        if (offset < 0 || offset > bytes.length || count < 0 || count > bytes.length - offset) {
            throw new IndexOutOfBoundsException();
        }
        if (count == 0) {
            return 0;
        }
        if (this.isClosed && this.in == -1) {
            return -1;
        }
        if (!this.isConnected) {
            throw new IOException("Not connected");
        }
        if (this.buffer == null) {
            throw new IOException("InputStream is closed");
        }
        if (this.lastWriter != null && !this.lastWriter.isAlive() && this.in < 0) {
            throw new IOException("Write end dead");
        }
        this.lastReader = Thread.currentThread();
        try {
            int attempts = 3;
            while (this.in == -1) {
                if (this.isClosed) {
                    return -1;
                }
                if (attempts-- <= 0 && this.lastWriter != null && !this.lastWriter.isAlive()) {
                    throw new IOException("Pipe broken");
                }
                this.notifyAll();
                this.wait(1000L);
            }
        }
        catch (InterruptedException e) {
            throw new InterruptedIOException();
        }
        int copyLength = 0;
        if (this.out >= this.in) {
            copyLength = count > this.buffer.length - this.out ? this.buffer.length - this.out : count;
            System.arraycopy(this.buffer, this.out, bytes, offset, copyLength);
            this.out += copyLength;
            if (this.out == this.buffer.length) {
                this.out = 0;
            }
            if (this.out == this.in) {
                this.in = -1;
                this.out = 0;
            }
        }
        if (copyLength == count || this.in == -1) {
            return copyLength;
        }
        int bytesCopied = copyLength;
        copyLength = this.in - this.out > count - bytesCopied ? count - bytesCopied : this.in - this.out;
        System.arraycopy(this.buffer, this.out, bytes, offset + bytesCopied, copyLength);
        this.out += copyLength;
        if (this.out == this.in) {
            this.in = -1;
            this.out = 0;
        }
        return bytesCopied + copyLength;
    }

    protected synchronized void receive(int oneByte) throws IOException {
        if (this.buffer == null || this.isClosed) {
            throw new IOException();
        }
        if (this.lastReader != null && !this.lastReader.isAlive()) {
            throw new IOException();
        }
        this.lastWriter = Thread.currentThread();
        try {
            while (this.buffer != null && this.out == this.in) {
                this.notifyAll();
                this.wait(1000L);
                if (this.lastReader == null || this.lastReader.isAlive()) continue;
                throw new IOException();
            }
        }
        catch (InterruptedException e) {
            throw new InterruptedIOException();
        }
        if (this.buffer != null) {
            if (this.in == -1) {
                this.in = 0;
            }
            this.buffer[this.in++] = (byte)oneByte;
            if (this.in == this.buffer.length) {
                this.in = 0;
            }
        }
    }

    synchronized void done() {
        this.isClosed = true;
        this.notifyAll();
    }
}

