/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.util.zip;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.util.GregorianCalendar;
import org.teavm.classlib.java.util.zip.TZipConstants;
import org.teavm.classlib.java.util.zip.TZipException;

public class TZipEntry
implements TZipConstants,
Cloneable {
    String name;
    String comment;
    long compressedSize = -1L;
    long crc = -1L;
    long size = -1L;
    int compressionMethod = -1;
    int time = -1;
    int modDate = -1;
    byte[] extra;
    int nameLen = -1;
    long mLocalHeaderRelOffset = -1L;
    public static final int DEFLATED = 8;
    public static final int STORED = 0;

    public TZipEntry(String name) {
        if (name == null) {
            throw new NullPointerException();
        }
        if (name.length() > 65535) {
            throw new IllegalArgumentException();
        }
        this.name = name;
    }

    public String getComment() {
        return this.comment;
    }

    public long getCompressedSize() {
        return this.compressedSize;
    }

    public long getCrc() {
        return this.crc;
    }

    public byte[] getExtra() {
        return this.extra;
    }

    public int getMethod() {
        return this.compressionMethod;
    }

    public String getName() {
        return this.name;
    }

    public long getSize() {
        return this.size;
    }

    public long getTime() {
        if (this.time != -1) {
            GregorianCalendar cal = new GregorianCalendar();
            cal.set(14, 0);
            cal.set(1980 + (this.modDate >> 9 & 0x7F), (this.modDate >> 5 & 0xF) - 1, this.modDate & 0x1F, this.time >> 11 & 0x1F, this.time >> 5 & 0x3F, (this.time & 0x1F) << 1);
            return cal.getTime().getTime();
        }
        return -1L;
    }

    public boolean isDirectory() {
        return this.name.charAt(this.name.length() - 1) == '/';
    }

    public void setComment(String string) {
        if (string != null && string.length() > 65535) {
            throw new IllegalArgumentException();
        }
        this.comment = string;
    }

    public void setCompressedSize(long value) {
        this.compressedSize = value;
    }

    public void setCrc(long value) {
        if (value < 0L || value > 0xFFFFFFFFL) {
            throw new IllegalArgumentException();
        }
        this.crc = value;
    }

    public void setExtra(byte[] data) {
        if (data != null && data.length > 65535) {
            throw new IllegalArgumentException();
        }
        this.extra = data;
    }

    public void setMethod(int value) {
        if (value != 0 && value != 8) {
            throw new IllegalArgumentException();
        }
        this.compressionMethod = value;
    }

    public void setSize(long value) {
        if (value < 0L || value > 0xFFFFFFFFL) {
            throw new IllegalArgumentException();
        }
        this.size = value;
    }

    public void setTime(long value) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(new Date(value));
        int year = cal.get(1);
        if (year < 1980) {
            this.modDate = 33;
            this.time = 0;
        } else {
            this.modDate = cal.get(5);
            this.modDate = cal.get(2) + 1 << 5 | this.modDate;
            this.modDate = cal.get(1) - 1980 << 9 | this.modDate;
            this.time = cal.get(13) >> 1;
            this.time = cal.get(12) << 5 | this.time;
            this.time = cal.get(11) << 11 | this.time;
        }
    }

    public String toString() {
        return this.name;
    }

    public TZipEntry(TZipEntry ze) {
        this.name = ze.name;
        this.comment = ze.comment;
        this.time = ze.time;
        this.size = ze.size;
        this.compressedSize = ze.compressedSize;
        this.crc = ze.crc;
        this.compressionMethod = ze.compressionMethod;
        this.modDate = ze.modDate;
        this.extra = ze.extra;
        this.nameLen = ze.nameLen;
        this.mLocalHeaderRelOffset = ze.mLocalHeaderRelOffset;
    }

    public Object clone() {
        return new TZipEntry(this);
    }

    TZipEntry(LittleEndianReader ler, InputStream in) throws IOException {
        byte[] hdrBuf = ler.hdrBuf;
        this.myReadFully(in, hdrBuf);
        long sig = (long)(hdrBuf[0] & 0xFF | (hdrBuf[1] & 0xFF) << 8 | (hdrBuf[2] & 0xFF) << 16) | (long)(hdrBuf[3] << 24) & 0xFFFFFFFFL;
        if (sig != 33639248L) {
            throw new TZipException();
        }
        this.compressionMethod = hdrBuf[10] & 0xFF | (hdrBuf[11] & 0xFF) << 8;
        this.time = hdrBuf[12] & 0xFF | (hdrBuf[13] & 0xFF) << 8;
        this.modDate = hdrBuf[14] & 0xFF | (hdrBuf[15] & 0xFF) << 8;
        this.crc = (long)(hdrBuf[16] & 0xFF | (hdrBuf[17] & 0xFF) << 8 | (hdrBuf[18] & 0xFF) << 16) | (long)(hdrBuf[19] << 24) & 0xFFFFFFFFL;
        this.compressedSize = (long)(hdrBuf[20] & 0xFF | (hdrBuf[21] & 0xFF) << 8 | (hdrBuf[22] & 0xFF) << 16) | (long)(hdrBuf[23] << 24) & 0xFFFFFFFFL;
        this.size = (long)(hdrBuf[24] & 0xFF | (hdrBuf[25] & 0xFF) << 8 | (hdrBuf[26] & 0xFF) << 16) | (long)(hdrBuf[27] << 24) & 0xFFFFFFFFL;
        this.nameLen = hdrBuf[28] & 0xFF | (hdrBuf[29] & 0xFF) << 8;
        int extraLen = hdrBuf[30] & 0xFF | (hdrBuf[31] & 0xFF) << 8;
        int commentLen = hdrBuf[32] & 0xFF | (hdrBuf[33] & 0xFF) << 8;
        this.mLocalHeaderRelOffset = (long)(hdrBuf[42] & 0xFF | (hdrBuf[43] & 0xFF) << 8 | (hdrBuf[44] & 0xFF) << 16) | (long)(hdrBuf[45] << 24) & 0xFFFFFFFFL;
        byte[] nameBytes = new byte[this.nameLen];
        this.myReadFully(in, nameBytes);
        byte[] commentBytes = null;
        if (commentLen > 0) {
            commentBytes = new byte[commentLen];
            this.myReadFully(in, commentBytes);
        }
        if (extraLen > 0) {
            this.extra = new byte[extraLen];
            this.myReadFully(in, this.extra);
        }
        try {
            this.name = new String(nameBytes, "ISO-8859-1");
            this.comment = commentBytes != null ? new String(commentBytes, "ISO-8859-1") : null;
        }
        catch (UnsupportedEncodingException uee) {
            throw new InternalError(uee.getMessage());
        }
    }

    private void myReadFully(InputStream in, byte[] b) throws IOException {
        int count;
        int off = 0;
        for (int len = b.length; len > 0; len -= count) {
            count = in.read(b, off, len);
            if (count <= 0) {
                throw new EOFException();
            }
            off += count;
        }
    }

    static long readIntLE(RandomAccessFile raf) throws IOException {
        int b0 = raf.read();
        int b1 = raf.read();
        int b2 = raf.read();
        int b3 = raf.read();
        if (b3 < 0) {
            throw new EOFException();
        }
        return b0 | b1 << 8 | b2 << 16 | b3 << 24;
    }

    static class LittleEndianReader {
        private byte[] b = new byte[4];
        byte[] hdrBuf = new byte[46];

        LittleEndianReader() {
        }

        int readShortLE(InputStream in) throws IOException {
            if (in.read(this.b, 0, 2) == 2) {
                return this.b[0] & 0xFF | (this.b[1] & 0xFF) << 8;
            }
            throw new EOFException();
        }

        long readIntLE(InputStream in) throws IOException {
            if (in.read(this.b, 0, 4) == 4) {
                return (long)(this.b[0] & 0xFF | (this.b[1] & 0xFF) << 8 | (this.b[2] & 0xFF) << 16 | (this.b[3] & 0xFF) << 24) & 0xFFFFFFFFL;
            }
            throw new EOFException();
        }
    }
}

