/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.util.stream.impl;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.Consumer;
import org.teavm.classlib.java.util.stream.impl.TSimpleStreamImpl;

public class TSimpleStreamIterator<T>
implements Iterator<T> {
    private static final byte NEEDS_MORE = 0;
    private static final byte HAS_DATA = 1;
    private static final byte LAST_ELEMENT = 2;
    private static final byte DONE = 3;
    private TSimpleStreamImpl<T> stream;
    private T lastElement;
    private byte state;

    public TSimpleStreamIterator(TSimpleStreamImpl<T> stream) {
        this.stream = stream;
    }

    @Override
    public void forEachRemaining(Consumer<? super T> action) {
        this.stream.next(x -> {
            action.accept(x);
            return true;
        });
    }

    @Override
    public boolean hasNext() {
        this.fetchIfNeeded();
        return this.state != 3;
    }

    @Override
    public T next() {
        this.fetchIfNeeded();
        if (this.state == 3) {
            throw new NoSuchElementException();
        }
        T result = this.lastElement;
        this.lastElement = null;
        this.state = (byte)(this.state == 2 ? 3 : 0);
        return result;
    }

    private void fetchIfNeeded() {
        if (this.state != 0) {
            return;
        }
        boolean hasMore = this.stream.next(e -> {
            this.lastElement = e;
            return false;
        });
        this.state = (byte)(hasMore ? 1 : 2);
        if (this.state == 2) {
            this.stream = null;
        }
    }
}

