/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.io;

import java.io.Closeable;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.EOFException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UTFDataFormatException;
import java.util.Objects;
import org.teavm.classlib.fs.VirtualFile;
import org.teavm.classlib.fs.VirtualFileAccessor;
import org.teavm.classlib.java.io.TEOFException;
import org.teavm.classlib.java.io.TFile;
import org.teavm.classlib.java.lang.TIndexOutOfBoundsException;
import org.teavm.classlib.java.lang.TNullPointerException;

public class TRandomAccessFile
implements DataInput,
DataOutput,
Closeable {
    private static final byte[] ONE_BYTE_BUFFER = new byte[1];
    private boolean readOnly;
    private boolean autoFlush;
    private VirtualFileAccessor accessor;
    private byte[] buff;

    public TRandomAccessFile(String name, String mode) throws FileNotFoundException {
        this(new TFile(name), mode);
    }

    public TRandomAccessFile(TFile file, String mode) throws FileNotFoundException {
        switch (mode) {
            case "r": {
                this.readOnly = true;
                break;
            }
            case "rw": {
                break;
            }
            case "rwd": 
            case "rws": {
                this.autoFlush = true;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid mode: " + mode);
            }
        }
        VirtualFile virtualFile = file.findVirtualFile();
        if (virtualFile == null || virtualFile.isDirectory()) {
            throw new FileNotFoundException();
        }
        this.accessor = virtualFile.createAccessor(true, !this.readOnly, false);
        if (this.accessor == null) {
            throw new FileNotFoundException();
        }
        this.buff = new byte[16];
    }

    @Override
    public void close() throws IOException {
        this.accessor = null;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        Objects.requireNonNull(b);
        if (off < 0 || len < 0 || off + len > b.length) {
            throw new IndexOutOfBoundsException();
        }
        this.ensureOpened();
        int result = this.accessor.read(b, off, len);
        return result > 0 ? result : -1;
    }

    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    public int read() throws IOException {
        this.ensureOpened();
        byte[] buffer = new byte[1];
        int read = this.accessor.read(buffer, 0, 1);
        return read > 0 ? buffer[0] : -1;
    }

    @Override
    public void readFully(byte[] b) throws IOException {
        this.readFully(b, 0, b.length);
    }

    @Override
    public void readFully(byte[] b, int off, int len) throws IOException {
        if (len < 0) {
            throw new TIndexOutOfBoundsException();
        }
        if (len == 0) {
            return;
        }
        if (b == null) {
            throw new TNullPointerException();
        }
        if (off < 0 || off > b.length - len) {
            throw new TIndexOutOfBoundsException();
        }
        this.ensureOpened();
        while (len > 0) {
            int result = this.read(b, off, len);
            if (result < 0) {
                throw new EOFException();
            }
            off += result;
            len -= result;
        }
    }

    @Override
    public int skipBytes(int n) throws IOException {
        this.ensureOpened();
        int last = this.accessor.tell();
        this.accessor.skip(n - 1);
        if (this.accessor.read(ONE_BYTE_BUFFER, 0, 1) < 1) {
            int position = this.accessor.size();
            this.accessor.seek(position);
            return position - last;
        }
        return n;
    }

    public long getFilePointer() throws IOException {
        this.ensureOpened();
        return this.accessor.tell();
    }

    public void seek(long pos) throws IOException {
        this.ensureOpened();
        this.accessor.seek((int)pos);
    }

    public long length() throws IOException {
        this.ensureOpened();
        return this.accessor.size();
    }

    public void setLength(long newLength) throws IOException {
        this.ensureOpened();
        this.accessor.resize((int)newLength);
    }

    @Override
    public boolean readBoolean() throws IOException {
        int temp = this.read();
        if (temp < 0) {
            throw new EOFException();
        }
        return temp != 0;
    }

    @Override
    public byte readByte() throws IOException {
        int temp = this.read();
        if (temp < 0) {
            throw new EOFException();
        }
        return (byte)temp;
    }

    @Override
    public int readUnsignedByte() throws IOException {
        int temp = this.read();
        if (temp < 0) {
            throw new EOFException();
        }
        return temp & 0xFF;
    }

    @Override
    public short readShort() throws IOException {
        if (this.readToBuff(2) < 0) {
            throw new EOFException();
        }
        return (short)((this.buff[0] & 0xFF) << 24 >> 16 | this.buff[1] & 0xFF);
    }

    @Override
    public int readUnsignedShort() throws IOException {
        if (this.readToBuff(2) < 0) {
            throw new EOFException();
        }
        return (char)((this.buff[0] & 0xFF) << 8 | this.buff[1] & 0xFF);
    }

    @Override
    public char readChar() throws IOException {
        if (this.readToBuff(2) < 0) {
            throw new EOFException();
        }
        return (char)((this.buff[0] & 0xFF) << 8 | this.buff[1] & 0xFF);
    }

    @Override
    public int readInt() throws IOException {
        if (this.readToBuff(4) < 0) {
            throw new TEOFException();
        }
        return (this.buff[0] & 0xFF) << 24 | (this.buff[1] & 0xFF) << 16 | (this.buff[2] & 0xFF) << 8 | this.buff[3] & 0xFF;
    }

    @Override
    public long readLong() throws IOException {
        if (this.readToBuff(8) < 0) {
            throw new TEOFException();
        }
        int i1 = (this.buff[0] & 0xFF) << 24 | (this.buff[1] & 0xFF) << 16 | (this.buff[2] & 0xFF) << 8 | this.buff[3] & 0xFF;
        int i2 = (this.buff[4] & 0xFF) << 24 | (this.buff[5] & 0xFF) << 16 | (this.buff[6] & 0xFF) << 8 | this.buff[7] & 0xFF;
        return ((long)i1 & 0xFFFFFFFFL) << 32 | (long)i2 & 0xFFFFFFFFL;
    }

    @Override
    public float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    @Override
    public double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    @Override
    public String readLine() throws IOException {
        StringBuilder line = new StringBuilder(80);
        boolean foundTerminator = false;
        block5: while (true) {
            int nextByte = this.read();
            switch (nextByte) {
                case -1: {
                    if (line.length() == 0 && !foundTerminator) {
                        return null;
                    }
                    return line.toString();
                }
                case 13: {
                    if (foundTerminator) {
                        this.seek(this.getFilePointer() - 1L);
                        return line.toString();
                    }
                    foundTerminator = true;
                    continue block5;
                }
                case 10: {
                    return line.toString();
                }
            }
            if (foundTerminator) {
                this.seek(this.getFilePointer() - 1L);
                return line.toString();
            }
            line.append((char)nextByte);
        }
    }

    @Override
    public String readUTF() throws IOException {
        return this.decodeUTF(this.readUnsignedShort());
    }

    String decodeUTF(int utfSize) throws IOException {
        byte[] buf = new byte[utfSize];
        char[] out = new char[utfSize];
        this.readFully(buf, 0, utfSize);
        return TRandomAccessFile.convertUTF8WithBuf(buf, out, 0, utfSize);
    }

    @Override
    public void write(int b) throws IOException {
        this.ensureOpened();
        byte[] buffer = new byte[]{(byte)b};
        this.accessor.write(buffer, 0, 1);
        if (this.autoFlush) {
            this.accessor.flush();
        }
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        Objects.requireNonNull(b);
        if (off < 0 || len < 0 || off + len > b.length) {
            throw new IndexOutOfBoundsException();
        }
        this.ensureOpened();
        this.accessor.write(b, off, len);
        if (this.autoFlush) {
            this.accessor.flush();
        }
    }

    @Override
    public void writeBoolean(boolean v) throws IOException {
        this.write(v ? 1 : 0);
    }

    @Override
    public void writeByte(int v) throws IOException {
        this.write(v);
    }

    @Override
    public void writeShort(int v) throws IOException {
        this.buff[0] = (byte)(v >> 8);
        this.buff[1] = (byte)v;
        this.write(this.buff, 0, 2);
    }

    @Override
    public void writeChar(int v) throws IOException {
        this.buff[0] = (byte)(v >> 8);
        this.buff[1] = (byte)v;
        this.write(this.buff, 0, 2);
    }

    @Override
    public void writeInt(int v) throws IOException {
        this.buff[0] = (byte)(v >> 24);
        this.buff[1] = (byte)(v >> 16);
        this.buff[2] = (byte)(v >> 8);
        this.buff[3] = (byte)v;
        this.write(this.buff, 0, 4);
    }

    @Override
    public void writeLong(long v) throws IOException {
        this.buff[0] = (byte)(v >> 56);
        this.buff[1] = (byte)(v >> 48);
        this.buff[2] = (byte)(v >> 40);
        this.buff[3] = (byte)(v >> 32);
        this.buff[4] = (byte)(v >> 24);
        this.buff[5] = (byte)(v >> 16);
        this.buff[6] = (byte)(v >> 8);
        this.buff[7] = (byte)v;
        this.write(this.buff, 0, 8);
    }

    @Override
    public void writeFloat(float v) throws IOException {
        this.writeInt(Float.floatToIntBits(v));
    }

    @Override
    public void writeDouble(double v) throws IOException {
        this.writeLong(Double.doubleToLongBits(v));
    }

    @Override
    public void writeBytes(String s) throws IOException {
        if (s.length() == 0) {
            return;
        }
        byte[] bytes = new byte[s.length()];
        for (int index = 0; index < s.length(); ++index) {
            bytes[index] = (byte)s.charAt(index);
        }
        this.write(bytes);
    }

    @Override
    public void writeChars(String s) throws IOException {
        byte[] newBytes = new byte[s.length() * 2];
        for (int index = 0; index < s.length(); ++index) {
            int newIndex = index == 0 ? index : index * 2;
            newBytes[newIndex] = (byte)(s.charAt(index) >> 8);
            newBytes[newIndex + 1] = (byte)s.charAt(index);
        }
        this.write(newBytes);
    }

    @Override
    public void writeUTF(String s) throws IOException {
        long utfCount = TRandomAccessFile.countUTFBytes(s);
        if (utfCount > 65535L) {
            throw new IOException("UTF Error");
        }
        byte[] buffer = new byte[(int)utfCount + 2];
        int offset = 0;
        offset = TRandomAccessFile.writeShortToBuffer((int)utfCount, buffer, offset);
        offset = TRandomAccessFile.writeUTFBytesToBuffer(s, buffer, offset);
        this.write(buffer, 0, offset);
    }

    private void ensureOpened() throws IOException {
        if (this.accessor == null) {
            throw new IOException("This stream is already closed");
        }
    }

    private int readToBuff(int count) throws IOException {
        int offset;
        int bytesRead;
        for (offset = 0; offset < count; offset += bytesRead) {
            bytesRead = this.read(this.buff, offset, count - offset);
            if (bytesRead != -1) continue;
            return bytesRead;
        }
        return offset;
    }

    private static String convertUTF8WithBuf(byte[] buf, char[] out, int offset, int utfSize) throws UTFDataFormatException {
        int count = 0;
        int s = 0;
        while (count < utfSize) {
            byte b;
            char ch;
            out[s] = ch = (char)buf[offset + count++];
            char a = out[s];
            if (ch < '\u0080') {
                ++s;
                continue;
            }
            if ((a & 0xE0) == 192) {
                if (count >= utfSize) {
                    throw new UTFDataFormatException("End of stream reached");
                }
                if (((b = buf[offset + count++]) & 0xC0) != 128) {
                    throw new UTFDataFormatException("Malformed UTF-8 sequence");
                }
                out[s++] = (char)((a & 0x1F) << 6 | b & 0x3F);
                continue;
            }
            if ((a & 0xF0) == 224) {
                if (count + 1 >= utfSize) {
                    throw new UTFDataFormatException("Malformed UTF-8 sequence");
                }
                b = buf[offset + count++];
                byte c = buf[offset + count++];
                if ((b & 0xC0) != 128 || (c & 0xC0) != 128) {
                    throw new UTFDataFormatException("Malformed UTF-8 sequence");
                }
                out[s++] = (char)((a & 0xF) << 12 | (b & 0x3F) << 6 | c & 0x3F);
                continue;
            }
            throw new UTFDataFormatException("Malformed UTF-8 sequence");
        }
        return new String(out, 0, s);
    }

    static int writeShortToBuffer(int val, byte[] buffer, int offset) {
        buffer[offset++] = (byte)(val >> 8);
        buffer[offset++] = (byte)val;
        return offset;
    }

    static long countUTFBytes(String str) {
        int utfCount = 0;
        int length = str.length();
        for (int i = 0; i < length; ++i) {
            char charValue = str.charAt(i);
            if (charValue > '\u0000' && charValue <= '\u007f') {
                ++utfCount;
                continue;
            }
            if (charValue <= '\u07ff') {
                utfCount += 2;
                continue;
            }
            utfCount += 3;
        }
        return utfCount;
    }

    static int writeUTFBytesToBuffer(String str, byte[] buffer, int offset) {
        int length = str.length();
        for (int i = 0; i < length; ++i) {
            char charValue = str.charAt(i);
            if (charValue > '\u0000' && charValue <= '\u007f') {
                buffer[offset++] = (byte)charValue;
                continue;
            }
            if (charValue <= '\u07ff') {
                buffer[offset++] = (byte)(0xC0 | 0x1F & charValue >> 6);
                buffer[offset++] = (byte)(0x80 | 0x3F & charValue);
                continue;
            }
            buffer[offset++] = (byte)(0xE0 | 0xF & charValue >> 12);
            buffer[offset++] = (byte)(0x80 | 0x3F & charValue >> 6);
            buffer[offset++] = (byte)(0x80 | 0x3F & charValue);
        }
        return offset;
    }
}

