/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.io;

import java.io.IOException;
import org.teavm.classlib.java.io.TOutputStream;
import org.teavm.classlib.java.io.TUnsupportedEncodingException;
import org.teavm.classlib.java.io.TWriter;
import org.teavm.classlib.java.nio.TByteBuffer;
import org.teavm.classlib.java.nio.TCharBuffer;
import org.teavm.classlib.java.nio.charset.TCharset;
import org.teavm.classlib.java.nio.charset.TCharsetEncoder;
import org.teavm.classlib.java.nio.charset.TCodingErrorAction;
import org.teavm.classlib.java.nio.charset.TIllegalCharsetNameException;
import org.teavm.classlib.java.nio.charset.TUnsupportedCharsetException;
import org.teavm.classlib.java.nio.charset.impl.TUTF8Charset;

public class TOutputStreamWriter
extends TWriter {
    private TOutputStream out;
    private TCharsetEncoder encoder;
    private byte[] bufferData = new byte[512];
    private TByteBuffer buffer = TByteBuffer.wrap(this.bufferData);
    private boolean closed;

    public TOutputStreamWriter(TOutputStream out) {
        this(TOutputStreamWriter.nullCheck(out), new TUTF8Charset());
    }

    public TOutputStreamWriter(TOutputStream out, String enc) throws TUnsupportedEncodingException {
        this(TOutputStreamWriter.nullCheck(out), TOutputStreamWriter.getCharset(enc));
    }

    public TOutputStreamWriter(TOutputStream out, TCharset charset) {
        this(TOutputStreamWriter.nullCheck(out), charset.newEncoder().onMalformedInput(TCodingErrorAction.REPLACE).onUnmappableCharacter(TCodingErrorAction.REPLACE));
    }

    public TOutputStreamWriter(TOutputStream out, TCharsetEncoder encoder) {
        this.out = TOutputStreamWriter.nullCheck(out);
        this.encoder = encoder;
    }

    private static TOutputStream nullCheck(TOutputStream stream) {
        if (stream == null) {
            throw new NullPointerException();
        }
        return stream;
    }

    private static TCharset getCharset(String charsetName) throws TUnsupportedEncodingException {
        if (charsetName == null) {
            throw new NullPointerException();
        }
        try {
            return TCharset.forName(charsetName);
        }
        catch (TIllegalCharsetNameException | TUnsupportedCharsetException e) {
            throw new TUnsupportedEncodingException(charsetName);
        }
    }

    @Override
    public void close() throws IOException {
        if (!this.closed) {
            this.flush();
            this.closed = true;
            this.out.flush();
            this.out.close();
        }
    }

    @Override
    public void flush() throws IOException {
        this.checkStatus();
        if (this.buffer.position() > 0) {
            this.out.write(this.bufferData, 0, this.buffer.position());
            this.buffer.clear();
        }
        this.out.flush();
    }

    private void checkStatus() throws IOException {
        if (this.closed) {
            throw new IOException("Writer already closed");
        }
    }

    public String getEncoding() {
        return this.encoder.charset().name();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(char[] buf, int offset, int count) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.checkStatus();
            if (buf == null) {
                throw new NullPointerException();
            }
            if (offset < 0 || offset > buf.length - count || count < 0) {
                throw new IndexOutOfBoundsException();
            }
            TCharBuffer input = TCharBuffer.wrap(buf, offset, count);
            while (input.hasRemaining()) {
                if (!this.encoder.encode(input, this.buffer, false).isOverflow()) continue;
                this.out.write(this.bufferData, 0, this.buffer.position());
                this.buffer.clear();
            }
        }
    }

    @Override
    public void write(int oneChar) throws IOException {
        char[] array = new char[]{(char)oneChar};
        this.write(array, 0, array.length);
    }

    @Override
    public void write(String str, int offset, int count) throws IOException {
        if (str == null) {
            throw new NullPointerException();
        }
        if (count < 0) {
            throw new IndexOutOfBoundsException("Negative count: " + count);
        }
        char[] chars = new char[count];
        str.getChars(offset, offset + count, chars, 0);
        this.write(chars);
    }
}

