/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.io;

import java.io.IOException;
import org.teavm.classlib.java.io.TFilterOutputStream;
import org.teavm.classlib.java.io.TOutputStream;

public class TBufferedOutputStream
extends TFilterOutputStream {
    protected byte[] buf;
    protected int count;

    public TBufferedOutputStream(TOutputStream out) {
        super(out);
        this.buf = new byte[8192];
    }

    public TBufferedOutputStream(TOutputStream out, int size) {
        super(out);
        if (size <= 0) {
            throw new IllegalArgumentException("size must be > 0");
        }
        this.buf = new byte[size];
    }

    @Override
    public void flush() throws IOException {
        this.flushInternal();
        this.out.flush();
    }

    @Override
    public void write(byte[] buffer, int offset, int length) throws IOException {
        byte[] internalBuffer = this.buf;
        if (internalBuffer != null && length >= internalBuffer.length) {
            this.flushInternal();
            this.out.write(buffer, offset, length);
            return;
        }
        if (buffer == null) {
            throw new NullPointerException("buffer is null");
        }
        if (offset < 0 || offset > buffer.length - length) {
            throw new ArrayIndexOutOfBoundsException("Offset out of bounds: " + offset);
        }
        if (length < 0) {
            throw new ArrayIndexOutOfBoundsException("Length out of bounds: " + length);
        }
        if (internalBuffer == null) {
            throw new IOException();
        }
        if (length >= internalBuffer.length - this.count) {
            this.flushInternal();
        }
        System.arraycopy(buffer, offset, internalBuffer, this.count, length);
        this.count += length;
    }

    @Override
    public void close() throws IOException {
        if (this.buf == null) {
            return;
        }
        try {
            super.close();
        }
        finally {
            this.buf = null;
        }
    }

    @Override
    public void write(int oneByte) throws IOException {
        byte[] internalBuffer = this.buf;
        if (internalBuffer == null) {
            throw new IOException();
        }
        if (this.count == internalBuffer.length) {
            this.out.write(internalBuffer, 0, this.count);
            this.count = 0;
        }
        internalBuffer[this.count++] = (byte)oneByte;
    }

    private void flushInternal() throws IOException {
        if (this.count > 0) {
            this.out.write(this.buf, 0, this.count);
            this.count = 0;
        }
    }
}

