/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.impl.text;

import java.util.Arrays;

public final class FloatAnalyzer {
    public static final int PRECISION = 9;
    public static final int MAX_POS = 100000000;
    private static final int MAX_ABS_DEC_EXP = 50;
    private static final int[] mantissa10Table;
    private static final int[] exp10Table;

    private FloatAnalyzer() {
    }

    public static void analyze(float d, Result result) {
        int upperPos;
        int lowerPos;
        int binExponentCorrection;
        int mantissaShift;
        int decMantissa;
        int decExponent;
        int bits = Float.floatToIntBits(d);
        result.sign = (bits & Integer.MIN_VALUE) != 0;
        int mantissa = bits & 0x7FFFFF;
        int exponent = bits >> 23 & 0xFF;
        if (mantissa == 0 && exponent == 0) {
            result.mantissa = 0;
            result.exponent = 0;
            return;
        }
        int errorShift = 0;
        if (exponent == 0) {
            mantissa <<= 1;
            while (((long)mantissa & 0x800000L) == 0L) {
                mantissa <<= 1;
                --exponent;
                ++errorShift;
            }
        } else {
            mantissa |= 0x800000;
        }
        if ((decExponent = Arrays.binarySearch(exp10Table, exponent)) < 0) {
            decExponent = -decExponent - 2;
        }
        if ((decMantissa = (int)((long)mantissa * (long)mantissa10Table[decExponent] >>> 32 - (mantissaShift = 9 + (binExponentCorrection = exponent - exp10Table[decExponent])))) >= 1000000000) {
            binExponentCorrection = exponent - exp10Table[++decExponent];
            mantissaShift = 9 + binExponentCorrection;
            decMantissa = (int)((long)mantissa * (long)mantissa10Table[decExponent] >>> 32 - mantissaShift);
        }
        int error = (errorShift = 31 - mantissaShift - errorShift) >= 0 ? mantissa10Table[decExponent] >>> errorShift : mantissa10Table[decExponent] << -errorShift;
        int upError = error + 1 >> 1;
        int downError = error >> 1;
        if (mantissa == 0x400000) {
            downError >>= 2;
        }
        if ((decMantissa = (lowerPos = FloatAnalyzer.findLowerDistanceToZero(decMantissa, downError)) > (upperPos = FloatAnalyzer.findUpperDistanceToZero(decMantissa, upError)) ? decMantissa / lowerPos * lowerPos : (lowerPos < upperPos ? decMantissa / upperPos * upperPos + upperPos : (decMantissa + upperPos / 2) / upperPos * upperPos)) >= 1000000000) {
            ++decExponent;
            decMantissa /= 10;
        } else if (decMantissa < 100000000) {
            --decExponent;
            decMantissa *= 10;
        }
        result.mantissa = decMantissa;
        result.exponent = decExponent - 50;
    }

    private static int findLowerDistanceToZero(int mantissa, int error) {
        int pos;
        for (pos = 10; pos <= error; pos *= 10) {
        }
        int mantissaRight = mantissa % pos;
        if (mantissaRight >= error / 2) {
            pos /= 10;
        }
        return pos;
    }

    private static int findUpperDistanceToZero(int mantissa, int error) {
        int pos;
        for (pos = 10; pos <= error; pos *= 10) {
        }
        int mantissaRight = mantissa % pos;
        if (pos - mantissaRight > error / 2) {
            pos /= 10;
        }
        return pos;
    }

    static {
        int decMantissaOne;
        mantissa10Table = new int[100];
        exp10Table = new int[100];
        int mantissa = decMantissaOne = 2000000000;
        int exponent = 127;
        for (int i = 0; i < 50; ++i) {
            FloatAnalyzer.mantissa10Table[i + 50] = Integer.divideUnsigned(mantissa, 20);
            FloatAnalyzer.exp10Table[i + 50] = exponent;
            mantissa = Integer.divideUnsigned(mantissa, 10);
            int remainder = Integer.remainderUnsigned(mantissa, 10);
            while (mantissa <= decMantissaOne && (mantissa & Integer.MIN_VALUE) == 0) {
                mantissa <<= 1;
                ++exponent;
                remainder <<= 1;
            }
            mantissa += remainder / 10;
        }
        int maxMantissa = 0xCCCCCCC;
        mantissa = decMantissaOne;
        exponent = 127;
        for (int i = 0; i < 50; ++i) {
            int nextMantissa = mantissa;
            int shift = 0;
            while (nextMantissa > maxMantissa) {
                nextMantissa >>= 1;
                ++shift;
                --exponent;
            }
            nextMantissa *= 10;
            if (shift > 0) {
                long shiftedOffPart = mantissa & (1 << shift) - 1;
                nextMantissa = (int)((long)nextMantissa + (shiftedOffPart * 10L >> shift));
            }
            mantissa = nextMantissa;
            FloatAnalyzer.mantissa10Table[50 - i - 1] = Integer.divideUnsigned(mantissa, 20);
            FloatAnalyzer.exp10Table[50 - i - 1] = exponent;
        }
    }

    public static class Result {
        public int mantissa;
        public int exponent;
        public boolean sign;
    }
}

