/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.impl;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import org.teavm.backend.javascript.codegen.SourceWriter;
import org.teavm.backend.javascript.spi.Generator;
import org.teavm.backend.javascript.spi.GeneratorContext;
import org.teavm.classlib.ServiceLoaderFilter;
import org.teavm.dependency.AbstractDependencyListener;
import org.teavm.dependency.DependencyAgent;
import org.teavm.dependency.DependencyNode;
import org.teavm.dependency.MethodDependency;
import org.teavm.model.CallLocation;
import org.teavm.model.MethodDescriptor;
import org.teavm.model.MethodReference;

public class ServiceLoaderSupport
extends AbstractDependencyListener
implements Generator {
    private static final MethodReference LOAD_METHOD = new MethodReference(ServiceLoader.class, "load", new Class[]{Class.class, ServiceLoader.class});
    private static final MethodDescriptor INIT_METHOD = new MethodDescriptor("<init>", new Class[]{Void.TYPE});
    private Map<String, List<String>> serviceMap = new HashMap<String, List<String>>();
    private ClassLoader classLoader;

    public ServiceLoaderSupport(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public void generate(GeneratorContext context, SourceWriter writer, MethodReference methodRef) throws IOException {
        writer.append("if (!").appendClass("java.util.ServiceLoader").append(".$$services$$) {").indent().softNewLine();
        writer.appendClass("java.util.ServiceLoader").append(".$$services$$ = true;").softNewLine();
        for (Map.Entry<String, List<String>> entry : this.serviceMap.entrySet()) {
            writer.appendClass(entry.getKey()).append(".$$serviceList$$ = [");
            List<String> implementations = entry.getValue();
            for (int i = 0; i < implementations.size(); ++i) {
                if (i > 0) {
                    writer.append(", ");
                }
                String implName = implementations.get(i);
                if (!context.getClassSource().getClassNames().contains(implName)) continue;
                writer.append("[").appendClass(implName).append(", ").appendMethodBody(new MethodReference(implName, INIT_METHOD)).append("]");
            }
            writer.append("];").softNewLine();
        }
        writer.outdent().append("}").softNewLine();
        String param = context.getParameterName(1);
        writer.append("var cls = " + param + ";").softNewLine();
        writer.append("if (!cls.$$serviceList$$) {").indent().softNewLine();
        writer.append("return $rt_createArray($rt_objcls(), 0);").softNewLine();
        writer.outdent().append("}").softNewLine();
        writer.append("var result = $rt_createArray($rt_objcls(), cls.$$serviceList$$.length);").softNewLine();
        writer.append("for (var i = 0; i < result.data.length; ++i) {").indent().softNewLine();
        writer.append("var serviceDesc = cls.$$serviceList$$[i];").softNewLine();
        writer.append("result.data[i] = new serviceDesc[0]();").softNewLine();
        writer.append("serviceDesc[1](result.data[i]);").softNewLine();
        writer.outdent().append("}").softNewLine();
        writer.append("return result;").softNewLine();
    }

    public void methodReached(DependencyAgent agent, MethodDependency method) {
        MethodReference ref = method.getReference();
        if (ref.getClassName().equals("java.util.ServiceLoader") && ref.getName().equals("loadServices")) {
            List<ServiceLoaderFilter> filters = this.getFilters(agent);
            method.getResult().propagate(agent.getType("[Ljava/lang/Object;"));
            DependencyNode sourceNode = agent.linkMethod(LOAD_METHOD).getVariable(1).getClassValueNode();
            sourceNode.connect(method.getResult().getArrayItem());
            sourceNode.addConsumer(type -> {
                CallLocation location = new CallLocation(LOAD_METHOD);
                for (String implementationType : this.getImplementations(type.getName())) {
                    if (filters.stream().anyMatch(filter -> !filter.apply(type.getName(), implementationType))) continue;
                    this.serviceMap.computeIfAbsent(type.getName(), k -> new ArrayList()).add(implementationType);
                    MethodReference ctor = new MethodReference(implementationType, INIT_METHOD);
                    agent.linkMethod(ctor).addLocation(location).use();
                    method.getResult().getArrayItem().propagate(agent.getType(implementationType));
                }
            });
        }
    }

    private Set<String> getImplementations(String type) {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        try {
            Enumeration<URL> resources = this.classLoader.getResources("META-INF/services/" + type);
            while (resources.hasMoreElements()) {
                URL resource = resources.nextElement();
                InputStream stream = resource.openStream();
                Throwable throwable = null;
                try {
                    this.parseServiceFile(stream, result);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (stream == null) continue;
                    if (throwable != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    stream.close();
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return result;
    }

    private void parseServiceFile(InputStream input, Set<String> consumer) throws IOException {
        String line;
        BufferedReader reader = new BufferedReader(new InputStreamReader(input, StandardCharsets.UTF_8));
        while ((line = reader.readLine()) != null) {
            if ((line = line.trim()).startsWith("#") || line.isEmpty()) continue;
            consumer.add(line);
        }
    }

    private List<ServiceLoaderFilter> getFilters(DependencyAgent agent) {
        ArrayList<ServiceLoaderFilter> filters = new ArrayList<ServiceLoaderFilter>();
        for (String filterTypeName : this.getImplementations(ServiceLoaderFilter.class.getName())) {
            Class<?> filterType;
            try {
                filterType = Class.forName(filterTypeName, true, this.classLoader);
            }
            catch (ClassNotFoundException e) {
                agent.getDiagnostics().error(null, "Could not load ServiceLoader filter class '{{c0}}'", new Object[]{filterTypeName});
                continue;
            }
            if (!ServiceLoaderFilter.class.isAssignableFrom(filterType)) {
                agent.getDiagnostics().error(null, "Class '{{c0}}' does not implement ServiceLoaderFilter interface", new Object[]{filterTypeName});
                continue;
            }
            try {
                filters.add((ServiceLoaderFilter)filterType.getConstructor(new Class[0]).newInstance(new Object[0]));
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                agent.getDiagnostics().error(null, "Could not instantiate ServiceLoader filter '{{c0}}'", new Object[]{filterTypeName});
            }
        }
        return filters;
    }
}

