/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.text;

import java.util.Objects;
import org.teavm.classlib.impl.unicode.CLDRHelper;
import org.teavm.classlib.java.math.TRoundingMode;
import org.teavm.classlib.java.text.TDecimalFormat;
import org.teavm.classlib.java.text.TDecimalFormatSymbols;
import org.teavm.classlib.java.text.TFieldPosition;
import org.teavm.classlib.java.text.TFormat;
import org.teavm.classlib.java.text.TParseException;
import org.teavm.classlib.java.text.TParsePosition;
import org.teavm.classlib.java.util.TCurrency;
import org.teavm.classlib.java.util.TLocale;

public abstract class TNumberFormat
extends TFormat {
    public static final int INTEGER_FIELD = 0;
    public static final int FRACTION_FIELD = 1;
    private boolean groupingUsed = true;
    private boolean parseIntegerOnly;
    private int maximumIntegerDigits = 40;
    private int minimumIntegerDigits = 1;
    private int maximumFractionDigits = 3;
    private int minimumFractionDigits = 0;
    private TRoundingMode roundingMode = TRoundingMode.HALF_EVEN;
    TCurrency currency = TCurrency.getInstance(TLocale.getDefault());

    @Override
    public Object clone() {
        return super.clone();
    }

    public TCurrency getCurrency() {
        return this.currency;
    }

    public void setCurrency(TCurrency currency) {
        this.currency = currency;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof TNumberFormat)) {
            return false;
        }
        TNumberFormat obj = (TNumberFormat)object;
        return this.groupingUsed == obj.groupingUsed && this.parseIntegerOnly == obj.parseIntegerOnly && this.maximumFractionDigits == obj.maximumFractionDigits && this.maximumIntegerDigits == obj.maximumIntegerDigits && this.minimumFractionDigits == obj.minimumFractionDigits && this.minimumIntegerDigits == obj.minimumIntegerDigits && this.roundingMode == obj.roundingMode && this.currency == obj.currency;
    }

    public final String format(double value) {
        return this.format(value, new StringBuffer(), new TFieldPosition(0)).toString();
    }

    public abstract StringBuffer format(double var1, StringBuffer var3, TFieldPosition var4);

    public final String format(long value) {
        return this.format(value, new StringBuffer(), new TFieldPosition(0)).toString();
    }

    public abstract StringBuffer format(long var1, StringBuffer var3, TFieldPosition var4);

    @Override
    public StringBuffer format(Object object, StringBuffer buffer, TFieldPosition field) {
        if (object instanceof Number) {
            long lv;
            double dv = ((Number)object).doubleValue();
            if (dv == (double)(lv = ((Number)object).longValue())) {
                return this.format(lv, buffer, field);
            }
            return this.format(dv, buffer, field);
        }
        throw new IllegalArgumentException();
    }

    public static TLocale[] getAvailableLocales() {
        return TLocale.getAvailableLocales();
    }

    public static final TNumberFormat getIntegerInstance() {
        return TNumberFormat.getIntegerInstance(TLocale.getDefault());
    }

    public static TNumberFormat getIntegerInstance(TLocale locale) {
        String pattern = CLDRHelper.resolveNumberFormat(locale.getLanguage(), locale.getCountry());
        TDecimalFormat format = new TDecimalFormat(pattern, new TDecimalFormatSymbols(locale));
        format.setParseIntegerOnly(true);
        format.setMinimumFractionDigits(0);
        format.setMaximumFractionDigits(0);
        format.setDecimalSeparatorAlwaysShown(false);
        return format;
    }

    public static final TNumberFormat getInstance() {
        return TNumberFormat.getNumberInstance();
    }

    public static TNumberFormat getInstance(TLocale locale) {
        return TNumberFormat.getNumberInstance(locale);
    }

    public int getMaximumFractionDigits() {
        return this.maximumFractionDigits;
    }

    public int getMaximumIntegerDigits() {
        return this.maximumIntegerDigits;
    }

    public int getMinimumFractionDigits() {
        return this.minimumFractionDigits;
    }

    public int getMinimumIntegerDigits() {
        return this.minimumIntegerDigits;
    }

    public static final TNumberFormat getNumberInstance() {
        return TNumberFormat.getNumberInstance(TLocale.getDefault());
    }

    public static TNumberFormat getNumberInstance(TLocale locale) {
        String pattern = CLDRHelper.resolveNumberFormat(locale.getLanguage(), locale.getCountry());
        return new TDecimalFormat(pattern, new TDecimalFormatSymbols(locale));
    }

    public static final TNumberFormat getPercentInstance() {
        return TNumberFormat.getPercentInstance(TLocale.getDefault());
    }

    public static TNumberFormat getPercentInstance(TLocale locale) {
        String pattern = CLDRHelper.resolvePercentFormat(locale.getLanguage(), locale.getCountry());
        return new TDecimalFormat(pattern, new TDecimalFormatSymbols(locale));
    }

    public static final TNumberFormat getCurrencyInstance() {
        return TNumberFormat.getCurrencyInstance(TLocale.getDefault());
    }

    public static final TNumberFormat getCurrencyInstance(TLocale locale) {
        String pattern = CLDRHelper.resolveCurrencyFormat(locale.getLanguage(), locale.getCountry());
        return new TDecimalFormat(pattern, new TDecimalFormatSymbols(locale));
    }

    public int hashCode() {
        return (this.groupingUsed ? 1231 : 1237) + (this.parseIntegerOnly ? 1231 : 1237) + this.maximumFractionDigits + this.maximumIntegerDigits + this.minimumFractionDigits + this.minimumIntegerDigits + this.roundingMode.hashCode() + Objects.hashCode(this.currency);
    }

    public boolean isGroupingUsed() {
        return this.groupingUsed;
    }

    public boolean isParseIntegerOnly() {
        return this.parseIntegerOnly;
    }

    public Number parse(String string) throws TParseException {
        TParsePosition pos = new TParsePosition(0);
        Number number = this.parse(string, pos);
        if (pos.getIndex() == 0) {
            throw new TParseException("Unparseable number: " + string, pos.getErrorIndex());
        }
        return number;
    }

    public abstract Number parse(String var1, TParsePosition var2);

    @Override
    public final Object parseObject(String string, TParsePosition position) {
        if (position == null) {
            throw new NullPointerException("position is null");
        }
        try {
            return this.parse(string, position);
        }
        catch (Exception e) {
            return null;
        }
    }

    public void setGroupingUsed(boolean value) {
        this.groupingUsed = value;
    }

    public void setMaximumFractionDigits(int value) {
        int n = this.maximumFractionDigits = value < 0 ? 0 : value;
        if (this.maximumFractionDigits < this.minimumFractionDigits) {
            this.minimumFractionDigits = this.maximumFractionDigits;
        }
    }

    public void setMaximumIntegerDigits(int value) {
        int n = this.maximumIntegerDigits = value < 0 ? 0 : value;
        if (this.maximumIntegerDigits < this.minimumIntegerDigits) {
            this.minimumIntegerDigits = this.maximumIntegerDigits;
        }
    }

    public void setMinimumFractionDigits(int value) {
        int n = this.minimumFractionDigits = value < 0 ? 0 : value;
        if (this.maximumFractionDigits < this.minimumFractionDigits) {
            this.maximumFractionDigits = this.minimumFractionDigits;
        }
    }

    public void setMinimumIntegerDigits(int value) {
        int n = this.minimumIntegerDigits = value < 0 ? 0 : value;
        if (this.maximumIntegerDigits < this.minimumIntegerDigits) {
            this.maximumIntegerDigits = this.minimumIntegerDigits;
        }
    }

    public void setParseIntegerOnly(boolean value) {
        this.parseIntegerOnly = value;
    }

    public TRoundingMode getRoundingMode() {
        return this.roundingMode;
    }

    public void setRoundingMode(TRoundingMode roundingMode) {
        this.roundingMode = roundingMode;
    }

    public static class Field
    extends TFormat.Field {
        public static final Field SIGN = new Field("sign");
        public static final Field INTEGER = new Field("integer");
        public static final Field FRACTION = new Field("fraction");
        public static final Field EXPONENT = new Field("exponent");
        public static final Field EXPONENT_SIGN = new Field("exponent sign");
        public static final Field EXPONENT_SYMBOL = new Field("exponent symbol");
        public static final Field DECIMAL_SEPARATOR = new Field("decimal separator");
        public static final Field GROUPING_SEPARATOR = new Field("grouping separator");
        public static final Field PERCENT = new Field("percent");
        public static final Field PERMILLE = new Field("per mille");
        public static final Field CURRENCY = new Field("currency");

        protected Field(String fieldName) {
            super(fieldName);
        }
    }
}

