/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.lang;

import org.teavm.classlib.java.lang.TClass;
import org.teavm.classlib.java.lang.TCloneNotSupportedException;
import org.teavm.classlib.java.lang.TCloneable;
import org.teavm.classlib.java.lang.TIllegalMonitorStateException;
import org.teavm.classlib.java.lang.TInteger;
import org.teavm.classlib.java.lang.TInterruptedException;
import org.teavm.classlib.java.lang.TThread;
import org.teavm.classlib.java.lang.TThreadInterruptHandler;
import org.teavm.classlib.java.lang.TThrowable;
import org.teavm.dom.browser.TimerHandler;
import org.teavm.javascript.spi.Async;
import org.teavm.javascript.spi.Rename;
import org.teavm.javascript.spi.Superclass;
import org.teavm.javascript.spi.Sync;
import org.teavm.platform.Platform;
import org.teavm.platform.PlatformQueue;
import org.teavm.platform.PlatformRunnable;
import org.teavm.platform.async.AsyncCallback;

@Superclass(value="")
public class TObject {
    Monitor monitor;

    static void monitorEnterSync(TObject o) {
        if (o.monitor == null) {
            o.monitor = new Monitor();
        }
        if (o.monitor.owner == null) {
            o.monitor.owner = TThread.currentThread();
        }
        ++o.monitor.count;
    }

    static void monitorExitSync(TObject o) {
        if (o.isEmptyMonitor() || o.monitor.owner != TThread.currentThread()) {
            throw new TIllegalMonitorStateException();
        }
        --o.monitor.count;
        o.isEmptyMonitor();
    }

    static void monitorEnter(TObject o) {
        TObject.monitorEnter(o, 1);
    }

    static void monitorEnter(TObject o, int count) {
        if (o.monitor == null) {
            o.monitor = new Monitor();
        }
        if (o.monitor.owner == null) {
            o.monitor.owner = TThread.currentThread();
        }
        if (o.monitor.owner != TThread.currentThread()) {
            TObject.monitorEnterWait(o, count);
        } else {
            o.monitor.count += count;
        }
    }

    @Async
    static native void monitorEnterWait(TObject var0, int var1);

    static void monitorEnterWait(final TObject o, final int count, final AsyncCallback<Void> callback) {
        final TThread thread = TThread.currentThread();
        if (o.monitor == null) {
            o.monitor = new Monitor();
            TThread.setCurrentThread(thread);
            o.monitor.count += count;
            callback.complete(null);
            return;
        }
        if (o.monitor.owner == null) {
            o.monitor.owner = thread;
            TThread.setCurrentThread(thread);
            o.monitor.count += count;
            callback.complete(null);
            return;
        }
        o.monitor.enteringThreads.add((Object)new PlatformRunnable(){

            public void run() {
                TThread.setCurrentThread(thread);
                o.monitor.owner = thread;
                o.monitor.count += count;
                callback.complete(null);
            }
        });
    }

    @Sync
    static void monitorExit(TObject o) {
        TObject.monitorExit(o, 1);
    }

    @Sync
    static void monitorExit(final TObject o, int count) {
        if (o.isEmptyMonitor() || o.monitor.owner != TThread.currentThread()) {
            throw new TIllegalMonitorStateException();
        }
        o.monitor.count -= count;
        if (o.monitor.count > 0) {
            return;
        }
        o.monitor.owner = null;
        if (!o.monitor.enteringThreads.isEmpty()) {
            Platform.postpone((PlatformRunnable)new PlatformRunnable(){

                public void run() {
                    if (o.isEmptyMonitor() || o.monitor.owner != null) {
                        return;
                    }
                    if (!o.monitor.enteringThreads.isEmpty()) {
                        ((PlatformRunnable)o.monitor.enteringThreads.remove()).run();
                    }
                }
            });
        } else {
            o.isEmptyMonitor();
        }
    }

    boolean isEmptyMonitor() {
        if (this.monitor == null) {
            return true;
        }
        if (this.monitor.owner == null && this.monitor.enteringThreads.isEmpty() && this.monitor.notifyListeners.isEmpty()) {
            this.monitor = null;
            return true;
        }
        return false;
    }

    static boolean holdsLock(TObject o) {
        return o.monitor != null && o.monitor.owner == TThread.currentThread();
    }

    @Rename(value="fakeInit")
    public TObject() {
    }

    @Rename(value="<init>")
    private void init() {
        Platform.getPlatformObject((Object)this).setId(Platform.nextObjectId());
    }

    @Rename(value="getClass")
    public final TClass<?> getClass0() {
        return TClass.getClass(Platform.getPlatformObject((Object)this).getPlatformClass());
    }

    public int hashCode() {
        return this.identity();
    }

    @Rename(value="equals")
    public boolean equals0(TObject other) {
        return this == other;
    }

    public String toString() {
        return this.getClass().getName() + "@" + TInteger.toHexString(this.identity());
    }

    int identity() {
        return Platform.getPlatformObject((Object)this).getId();
    }

    protected Object clone() throws TCloneNotSupportedException {
        if (!(this instanceof TCloneable) && Platform.getPlatformObject((Object)this).getPlatformClass().getMetadata().getArrayItem() == null) {
            throw new TCloneNotSupportedException();
        }
        Object result = Platform.clone((Object)this);
        Platform.getPlatformObject((Object)result).setId(Platform.nextObjectId());
        return result;
    }

    @Sync
    @Rename(value="notify")
    public final void notify0() {
        if (!TObject.holdsLock(this)) {
            throw new TIllegalMonitorStateException();
        }
        PlatformQueue<NotifyListener> listeners = this.monitor.notifyListeners;
        while (!listeners.isEmpty()) {
            NotifyListener listener = (NotifyListener)listeners.remove();
            if (listener.expired()) continue;
            Platform.postpone((PlatformRunnable)listener);
            break;
        }
    }

    @Sync
    @Rename(value="notifyAll")
    public final void notifyAll0() {
        if (!TObject.holdsLock(this)) {
            throw new TIllegalMonitorStateException();
        }
        PlatformQueue<NotifyListener> listeners = this.monitor.notifyListeners;
        while (!listeners.isEmpty()) {
            NotifyListener listener = (NotifyListener)listeners.remove();
            if (listener.expired()) continue;
            Platform.postpone((PlatformRunnable)listener);
        }
    }

    @Rename(value="wait")
    public final void wait0(long timeout) throws TInterruptedException {
        try {
            this.wait(timeout, 0);
        }
        catch (InterruptedException ex) {
            throw new TInterruptedException();
        }
    }

    @Rename(value="wait")
    private final void wait0(long timeout, int nanos) throws TInterruptedException {
        if (!TObject.holdsLock(this)) {
            throw new TIllegalMonitorStateException();
        }
        this.waitImpl(timeout, nanos);
    }

    @Async
    private final native void waitImpl(long var1, int var3) throws TInterruptedException;

    public final void waitImpl(long timeout, int nanos, AsyncCallback<Void> callback) {
        NotifyListenerImpl listener = new NotifyListenerImpl(this, callback, this.monitor.count);
        this.monitor.notifyListeners.add((Object)listener);
        if (timeout > 0L || nanos > 0) {
            listener.timerId = Platform.schedule((PlatformRunnable)listener, (int)(timeout >= Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)timeout));
        }
        TObject.monitorExit(this, this.monitor.count);
    }

    @Rename(value="wait")
    public final void wait0() throws TInterruptedException {
        try {
            this.wait(0L);
        }
        catch (InterruptedException ex) {
            throw new TInterruptedException();
        }
    }

    protected void finalize() throws TThrowable {
    }

    public static TObject wrap(Object obj) {
        return (TObject)obj;
    }

    private static class NotifyListenerImpl
    implements NotifyListener,
    TimerHandler,
    PlatformRunnable,
    TThreadInterruptHandler {
        final TObject obj;
        final AsyncCallback<Void> callback;
        final TThread currentThread = TThread.currentThread();
        int timerId = -1;
        boolean expired;
        boolean performed;
        int lockCount;

        public NotifyListenerImpl(TObject obj, AsyncCallback<Void> callback, int lockCount) {
            this.obj = obj;
            this.callback = callback;
            this.lockCount = lockCount;
        }

        @Override
        public boolean expired() {
            boolean result = this.expired;
            this.expired = true;
            return result;
        }

        public void onTimer() {
            if (!this.expired()) {
                this.run();
            }
        }

        public void run() {
            if (this.performed) {
                return;
            }
            this.performed = true;
            if (this.timerId >= 0) {
                Platform.killSchedule((int)this.timerId);
                this.timerId = -1;
            }
            TThread.setCurrentThread(this.currentThread);
            TObject.monitorEnterWait(this.obj, this.lockCount, this.callback);
        }

        @Override
        public void interrupted() {
            if (this.performed) {
                return;
            }
            this.performed = true;
            if (this.timerId >= 0) {
                Platform.killSchedule((int)this.timerId);
                this.timerId = -1;
            }
            Platform.postpone((PlatformRunnable)new PlatformRunnable(){

                public void run() {
                    NotifyListenerImpl.this.callback.error((Throwable)new TInterruptedException());
                }
            });
        }
    }

    static interface NotifyListener
    extends PlatformRunnable {
        public boolean expired();
    }

    static class Monitor {
        PlatformQueue<PlatformRunnable> enteringThreads;
        PlatformQueue<NotifyListener> notifyListeners;
        TThread owner = TThread.currentThread();
        int count;

        public Monitor() {
            this.enteringThreads = Platform.createQueue();
            this.notifyListeners = Platform.createQueue();
        }
    }
}

