/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.io;

import org.teavm.classlib.java.io.TCloseable;
import org.teavm.classlib.java.io.TFlushable;
import org.teavm.classlib.java.io.TIOException;
import org.teavm.classlib.java.lang.TAppendable;
import org.teavm.classlib.java.lang.TCharSequence;

public abstract class TWriter
implements TAppendable,
TCloseable,
TFlushable {
    protected Object lock;

    protected TWriter() {
        this.lock = this;
    }

    protected TWriter(Object lock) {
        if (lock == null) {
            throw new NullPointerException();
        }
        this.lock = lock;
    }

    public void write(char[] buf) throws TIOException {
        this.write(buf, 0, buf.length);
    }

    public abstract void write(char[] var1, int var2, int var3) throws TIOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(int oneChar) throws TIOException {
        Object object = this.lock;
        synchronized (object) {
            char[] oneCharArray = new char[]{(char)oneChar};
            this.write(oneCharArray);
        }
    }

    public void write(String str) throws TIOException {
        this.write(str, 0, str.length());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(String str, int offset, int count) throws TIOException {
        if (count < 0) {
            throw new StringIndexOutOfBoundsException();
        }
        char[] buf = new char[count];
        str.getChars(offset, offset + count, buf, 0);
        Object object = this.lock;
        synchronized (object) {
            this.write(buf, 0, buf.length);
        }
    }

    @Override
    public TWriter append(char c) throws TIOException {
        this.write(c);
        return this;
    }

    @Override
    public TWriter append(TCharSequence csq) throws TIOException {
        this.write(csq != null ? csq.toString() : "null");
        return this;
    }

    @Override
    public TWriter append(TCharSequence csq, int start, int end) throws TIOException {
        this.write(csq != null ? csq.subSequence(start, end).toString() : "null");
        return this;
    }
}

