/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.impl.tz;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.TimeZone;
import org.teavm.classlib.impl.Base46;
import org.teavm.classlib.impl.CharFlow;
import org.teavm.classlib.impl.tz.CachedDateTimeZone;
import org.teavm.classlib.impl.tz.FixedDateTimeZone;
import org.teavm.classlib.impl.tz.StorableDateTimeZone;

public class DateTimeZoneBuilder {
    private static TimeZone gmtCache;
    private final ArrayList<RuleSet> iRuleSets = new ArrayList(10);

    private static StorableDateTimeZone buildFixedZone(String id, int wallOffset, int standardOffset) {
        return new FixedDateTimeZone(id, wallOffset, standardOffset);
    }

    private static TimeZone getGMT() {
        if (gmtCache == null) {
            gmtCache = TimeZone.getTimeZone("GMT+00:00");
        }
        return gmtCache;
    }

    public DateTimeZoneBuilder addCutover(int year, char mode, int monthOfYear, int dayOfMonth, int dayOfWeek, boolean advanceDayOfWeek, int millisOfDay) {
        if (this.iRuleSets.size() > 0) {
            OfYear ofYear = new OfYear(mode, monthOfYear, dayOfMonth, dayOfWeek, advanceDayOfWeek, millisOfDay);
            RuleSet lastRuleSet = this.iRuleSets.get(this.iRuleSets.size() - 1);
            lastRuleSet.setUpperLimit(year, ofYear);
        }
        this.iRuleSets.add(new RuleSet());
        return this;
    }

    public DateTimeZoneBuilder setStandardOffset(int standardOffset) {
        this.getLastRuleSet().setStandardOffset(standardOffset);
        return this;
    }

    public DateTimeZoneBuilder setFixedSavings(String nameKey, int saveMillis) {
        this.getLastRuleSet().setFixedSavings(nameKey, saveMillis);
        return this;
    }

    public DateTimeZoneBuilder addRecurringSavings(int saveMillis, int fromYear, int toYear, char mode, int monthOfYear, int dayOfMonth, int dayOfWeek, boolean advanceDayOfWeek, int millisOfDay) {
        if (fromYear <= toYear) {
            OfYear ofYear = new OfYear(mode, monthOfYear, dayOfMonth, dayOfWeek, advanceDayOfWeek, millisOfDay);
            Recurrence recurrence = new Recurrence(ofYear, saveMillis);
            Rule rule = new Rule(recurrence, fromYear, toYear);
            this.getLastRuleSet().addRule(rule);
        }
        return this;
    }

    private RuleSet getLastRuleSet() {
        if (this.iRuleSets.size() == 0) {
            this.addCutover(Integer.MIN_VALUE, 'w', 1, 1, 0, false, 0);
        }
        return this.iRuleSets.get(this.iRuleSets.size() - 1);
    }

    public StorableDateTimeZone toDateTimeZone(String id, boolean outputID) {
        if (id == null) {
            throw new IllegalArgumentException();
        }
        ArrayList<Transition> transitions = new ArrayList<Transition>();
        DSTZone tailZone = null;
        long millis = Long.MIN_VALUE;
        int saveMillis = 0;
        int ruleSetCount = this.iRuleSets.size();
        for (int i = 0; i < ruleSetCount; ++i) {
            RuleSet rs = this.iRuleSets.get(i);
            Transition next = rs.firstTransition(millis);
            if (next == null) continue;
            this.addTransition(transitions, next);
            millis = next.getMillis();
            saveMillis = next.getSaveMillis();
            rs = new RuleSet(rs);
            while (!((next = rs.nextTransition(millis, saveMillis)) == null || this.addTransition(transitions, next) && tailZone != null)) {
                millis = next.getMillis();
                saveMillis = next.getSaveMillis();
                if (tailZone != null || i != ruleSetCount - 1) continue;
                tailZone = rs.buildTailZone(id);
            }
            millis = rs.getUpperLimit(saveMillis);
        }
        if (transitions.size() == 0) {
            if (tailZone != null) {
                return tailZone;
            }
            return DateTimeZoneBuilder.buildFixedZone(id, 0, 0);
        }
        if (transitions.size() == 1 && tailZone == null) {
            Transition tr = (Transition)transitions.get(0);
            return DateTimeZoneBuilder.buildFixedZone(id, tr.getWallOffset(), tr.getStandardOffset());
        }
        PrecalculatedZone zone = PrecalculatedZone.create(id, outputID, transitions, tailZone);
        if (zone.isCachable()) {
            return CachedDateTimeZone.forZone(zone);
        }
        return zone;
    }

    private boolean addTransition(ArrayList<Transition> transitions, Transition tr) {
        int size = transitions.size();
        if (size == 0) {
            transitions.add(tr);
            return true;
        }
        Transition last = transitions.get(size - 1);
        if (!tr.isTransitionFrom(last)) {
            return false;
        }
        int offsetForLast = 0;
        if (size >= 2) {
            offsetForLast = transitions.get(size - 2).getWallOffset();
        }
        int offsetForNew = last.getWallOffset();
        long lastLocal = last.getMillis() + (long)offsetForLast;
        long newLocal = tr.getMillis() + (long)offsetForNew;
        if (newLocal != lastLocal) {
            transitions.add(tr);
            return true;
        }
        transitions.remove(size - 1);
        return this.addTransition(transitions, tr);
    }

    static final class PrecalculatedZone
    extends StorableDateTimeZone {
        private final long[] iTransitions;
        private final int[] iWallOffsets;
        private final int[] iStandardOffsets;
        private final DSTZone iTailZone;

        static PrecalculatedZone create(String id, boolean outputID, ArrayList<Transition> transitions, DSTZone tailZone) {
            int size = transitions.size();
            if (size == 0) {
                throw new IllegalArgumentException();
            }
            long[] trans = new long[size];
            int[] wallOffsets = new int[size];
            int[] standardOffsets = new int[size];
            Transition last = null;
            for (int i = 0; i < size; ++i) {
                Transition tr = transitions.get(i);
                if (!tr.isTransitionFrom(last)) {
                    throw new IllegalArgumentException(id);
                }
                trans[i] = tr.getMillis();
                wallOffsets[i] = tr.getWallOffset();
                standardOffsets[i] = tr.getStandardOffset();
                last = tr;
            }
            return new PrecalculatedZone(outputID ? id : "", trans, wallOffsets, standardOffsets, tailZone);
        }

        private PrecalculatedZone(String id, long[] transitions, int[] wallOffsets, int[] standardOffsets, DSTZone tailZone) {
            super(id);
            this.iTransitions = transitions;
            this.iWallOffsets = wallOffsets;
            this.iStandardOffsets = standardOffsets;
            this.iTailZone = tailZone;
        }

        @Override
        public void write(StringBuilder sb) {
            int i;
            int start = 0;
            while (start + 1 < this.iTransitions.length && this.iTransitions[start + 1] < 631170000000L) {
                ++start;
            }
            Base46.encodeUnsigned(sb, 0);
            Base46.encodeUnsigned(sb, this.iTransitions.length - start);
            long[] transitions = (long[])this.iTransitions.clone();
            for (i = 0; i < transitions.length; ++i) {
                transitions[i] = transitions[i] / 60000L * 60000L;
            }
            PrecalculatedZone.writeTime(sb, transitions[start]);
            for (i = start + 1; i < transitions.length; ++i) {
                PrecalculatedZone.writeTime(sb, transitions[i] - transitions[i - 1] - 657000000L);
            }
            PrecalculatedZone.writeTimeArray(sb, Arrays.copyOfRange(this.iWallOffsets, start, transitions.length));
            PrecalculatedZone.writeTimeArray(sb, Arrays.copyOfRange(this.iStandardOffsets, start, transitions.length));
            if (this.iTailZone != null) {
                sb.append('y');
                this.iTailZone.write(sb);
            } else {
                sb.append('n');
            }
        }

        public static StorableDateTimeZone readZone(String id, CharFlow flow) {
            DSTZone tailZone;
            int length = Base46.decodeUnsigned(flow);
            long[] transitions = new long[length];
            int[] wallOffsets = new int[length];
            int[] standardOffsets = new int[length];
            transitions[0] = PrecalculatedZone.readTime(flow);
            for (int i = 1; i < length; ++i) {
                transitions[i] = transitions[i - 1] + PrecalculatedZone.readTime(flow) + 657000000L;
            }
            PrecalculatedZone.readTimeArray(flow, wallOffsets);
            PrecalculatedZone.readTimeArray(flow, standardOffsets);
            if (flow.characters[flow.pointer++] == 'y') {
                ++flow.pointer;
                tailZone = DSTZone.readZone(id, flow);
            } else {
                tailZone = null;
            }
            PrecalculatedZone result = new PrecalculatedZone(id, transitions, wallOffsets, standardOffsets, tailZone);
            return result.isCachable() ? CachedDateTimeZone.forZone(result) : result;
        }

        @Override
        public int getOffset(long instant) {
            long[] transitions = this.iTransitions;
            int i = Arrays.binarySearch(transitions, instant);
            if (i >= 0) {
                return this.iWallOffsets[i];
            }
            if ((i ^= 0xFFFFFFFF) < transitions.length) {
                if (i > 0) {
                    return this.iWallOffsets[i - 1];
                }
                return 0;
            }
            if (this.iTailZone == null) {
                return this.iWallOffsets[i - 1];
            }
            return this.iTailZone.getOffset(instant);
        }

        @Override
        public int getStandardOffset(long instant) {
            long[] transitions = this.iTransitions;
            int i = Arrays.binarySearch(transitions, instant);
            if (i >= 0) {
                return this.iStandardOffsets[i];
            }
            if ((i ^= 0xFFFFFFFF) < transitions.length) {
                if (i > 0) {
                    return this.iStandardOffsets[i - 1];
                }
                return 0;
            }
            if (this.iTailZone == null) {
                return this.iStandardOffsets[i - 1];
            }
            return this.iTailZone.getStandardOffset(instant);
        }

        @Override
        public boolean isFixed() {
            return false;
        }

        @Override
        public long nextTransition(long instant) {
            long[] transitions = this.iTransitions;
            int i = Arrays.binarySearch(transitions, instant);
            int n = i = i >= 0 ? i + 1 : ~i;
            if (i < transitions.length) {
                return transitions[i];
            }
            if (this.iTailZone == null) {
                return instant;
            }
            long end = transitions[transitions.length - 1];
            if (instant < end) {
                instant = end;
            }
            return this.iTailZone.nextTransition(instant);
        }

        @Override
        public long previousTransition(long instant) {
            long prev;
            long[] transitions = this.iTransitions;
            int i = Arrays.binarySearch(transitions, instant);
            if (i >= 0) {
                if (instant > Long.MIN_VALUE) {
                    return instant - 1L;
                }
                return instant;
            }
            if ((i ^= 0xFFFFFFFF) < transitions.length) {
                long prev2;
                if (i > 0 && (prev2 = transitions[i - 1]) > Long.MIN_VALUE) {
                    return prev2 - 1L;
                }
                return instant;
            }
            if (this.iTailZone != null && (prev = this.iTailZone.previousTransition(instant)) < instant) {
                return prev;
            }
            prev = transitions[i - 1];
            if (prev > Long.MIN_VALUE) {
                return prev - 1L;
            }
            return instant;
        }

        public boolean isCachable() {
            if (this.iTailZone != null) {
                return true;
            }
            long[] transitions = this.iTransitions;
            if (transitions.length <= 1) {
                return false;
            }
            double distances = 0.0;
            int count = 0;
            for (int i = 1; i < transitions.length; ++i) {
                long diff = transitions[i] - transitions[i - 1];
                if (diff >= 63158400000L) continue;
                distances += (double)diff;
                ++count;
            }
            if (count > 0) {
                double avg = distances / (double)count;
                if ((avg /= 8.64E7) >= 25.0) {
                    return true;
                }
            }
            return false;
        }
    }

    static final class DSTZone
    extends StorableDateTimeZone {
        final int iStandardOffset;
        final Recurrence iStartRecurrence;
        final Recurrence iEndRecurrence;

        DSTZone(String id, int standardOffset, Recurrence startRecurrence, Recurrence endRecurrence) {
            super(id);
            this.iStandardOffset = standardOffset;
            this.iStartRecurrence = startRecurrence;
            this.iEndRecurrence = endRecurrence;
        }

        @Override
        public int getOffset(long instant) {
            return this.iStandardOffset + this.findMatchingRecurrence(instant).getSaveMillis();
        }

        @Override
        public int getStandardOffset(long instant) {
            return this.iStandardOffset;
        }

        @Override
        public boolean isFixed() {
            return false;
        }

        @Override
        public long nextTransition(long instant) {
            long end;
            long start;
            int standardOffset = this.iStandardOffset;
            Recurrence startRecurrence = this.iStartRecurrence;
            Recurrence endRecurrence = this.iEndRecurrence;
            try {
                start = startRecurrence.next(instant, standardOffset, endRecurrence.getSaveMillis());
                if (instant > 0L && start < 0L) {
                    start = instant;
                }
            }
            catch (IllegalArgumentException e) {
                start = instant;
            }
            catch (ArithmeticException e) {
                start = instant;
            }
            try {
                end = endRecurrence.next(instant, standardOffset, startRecurrence.getSaveMillis());
                if (instant > 0L && end < 0L) {
                    end = instant;
                }
            }
            catch (IllegalArgumentException e) {
                end = instant;
            }
            catch (ArithmeticException e) {
                end = instant;
            }
            return start > end ? end : start;
        }

        @Override
        public long previousTransition(long instant) {
            long end;
            long start;
            ++instant;
            int standardOffset = this.iStandardOffset;
            Recurrence startRecurrence = this.iStartRecurrence;
            Recurrence endRecurrence = this.iEndRecurrence;
            try {
                start = startRecurrence.previous(instant, standardOffset, endRecurrence.getSaveMillis());
                if (instant < 0L && start > 0L) {
                    start = instant;
                }
            }
            catch (IllegalArgumentException e) {
                start = instant;
            }
            catch (ArithmeticException e) {
                start = instant;
            }
            try {
                end = endRecurrence.previous(instant, standardOffset, startRecurrence.getSaveMillis());
                if (instant < 0L && end > 0L) {
                    end = instant;
                }
            }
            catch (IllegalArgumentException e) {
                end = instant;
            }
            catch (ArithmeticException e) {
                end = instant;
            }
            return (start > end ? start : end) - 1L;
        }

        private Recurrence findMatchingRecurrence(long instant) {
            long end;
            long start;
            int standardOffset = this.iStandardOffset;
            Recurrence startRecurrence = this.iStartRecurrence;
            Recurrence endRecurrence = this.iEndRecurrence;
            try {
                start = startRecurrence.next(instant, standardOffset, endRecurrence.getSaveMillis());
            }
            catch (IllegalArgumentException e) {
                start = instant;
            }
            catch (ArithmeticException e) {
                start = instant;
            }
            try {
                end = endRecurrence.next(instant, standardOffset, startRecurrence.getSaveMillis());
            }
            catch (IllegalArgumentException e) {
                end = instant;
            }
            catch (ArithmeticException e) {
                end = instant;
            }
            return start > end ? startRecurrence : endRecurrence;
        }

        @Override
        public void write(StringBuilder sb) {
            Base46.encodeUnsigned(sb, 3);
            DSTZone.writeTime(sb, this.iStandardOffset);
            this.iStartRecurrence.write(sb);
            this.iEndRecurrence.write(sb);
        }

        public static DSTZone readZone(String id, CharFlow flow) {
            int standardOffset = (int)DSTZone.readTime(flow);
            Recurrence startRecurrence = Recurrence.read(flow);
            Recurrence endRecurrence = Recurrence.read(flow);
            return new DSTZone(id, standardOffset, startRecurrence, endRecurrence);
        }
    }

    private static final class RuleSet {
        private static final int YEAR_LIMIT;
        private int iStandardOffset;
        private ArrayList<Rule> iRules;
        private String iInitialNameKey;
        private int iInitialSaveMillis;
        private int iUpperYear;
        private OfYear iUpperOfYear;

        RuleSet() {
            this.iRules = new ArrayList(10);
            this.iUpperYear = Integer.MAX_VALUE;
        }

        RuleSet(RuleSet rs) {
            this.iStandardOffset = rs.iStandardOffset;
            this.iRules = new ArrayList<Rule>(rs.iRules);
            this.iInitialSaveMillis = rs.iInitialSaveMillis;
            this.iUpperYear = rs.iUpperYear;
            this.iUpperOfYear = rs.iUpperOfYear;
        }

        public int getStandardOffset() {
            return this.iStandardOffset;
        }

        public void setStandardOffset(int standardOffset) {
            this.iStandardOffset = standardOffset;
        }

        public void setFixedSavings(String nameKey, int saveMillis) {
            this.iInitialNameKey = nameKey;
            this.iInitialSaveMillis = saveMillis;
        }

        public void addRule(Rule rule) {
            if (!this.iRules.contains(rule)) {
                this.iRules.add(rule);
            }
        }

        public void setUpperLimit(int year, OfYear ofYear) {
            this.iUpperYear = year;
            this.iUpperOfYear = ofYear;
        }

        public Transition firstTransition(long firstMillis) {
            Transition next;
            if (this.iInitialNameKey != null) {
                return new Transition(firstMillis, this.iStandardOffset + this.iInitialSaveMillis, this.iStandardOffset);
            }
            ArrayList<Rule> copy = new ArrayList<Rule>(this.iRules);
            long millis = Long.MIN_VALUE;
            int saveMillis = 0;
            Transition first = null;
            while ((next = this.nextTransition(millis, saveMillis)) != null) {
                millis = next.getMillis();
                if (millis == firstMillis) {
                    first = new Transition(firstMillis, next);
                    break;
                }
                if (millis > firstMillis) {
                    if (first == null) {
                        for (Rule rule : copy) {
                            if (rule.getSaveMillis() != 0) continue;
                            first = new Transition(firstMillis, rule, this.iStandardOffset);
                            break;
                        }
                    }
                    if (first != null) break;
                    first = new Transition(firstMillis, this.iStandardOffset, this.iStandardOffset);
                    break;
                }
                first = new Transition(firstMillis, next);
                saveMillis = next.getSaveMillis();
            }
            this.iRules = copy;
            return first;
        }

        public Transition nextTransition(long instant, int saveMillis) {
            long upperMillis;
            Rule nextRule = null;
            long nextMillis = Long.MAX_VALUE;
            Iterator<Rule> it = this.iRules.iterator();
            while (it.hasNext()) {
                Rule rule = it.next();
                long next = rule.next(instant, this.iStandardOffset, saveMillis);
                if (next <= instant) {
                    it.remove();
                    continue;
                }
                if (next > nextMillis) continue;
                nextRule = rule;
                nextMillis = next;
            }
            if (nextRule == null) {
                return null;
            }
            Calendar c = Calendar.getInstance(DateTimeZoneBuilder.getGMT());
            c.setTimeInMillis(nextMillis);
            if (c.get(1) >= YEAR_LIMIT) {
                return null;
            }
            if (this.iUpperYear < Integer.MAX_VALUE && nextMillis >= (upperMillis = this.iUpperOfYear.setInstant(this.iUpperYear, this.iStandardOffset, saveMillis))) {
                return null;
            }
            return new Transition(nextMillis, nextRule, this.iStandardOffset);
        }

        public long getUpperLimit(int saveMillis) {
            if (this.iUpperYear == Integer.MAX_VALUE) {
                return Long.MAX_VALUE;
            }
            return this.iUpperOfYear.setInstant(this.iUpperYear, this.iStandardOffset, saveMillis);
        }

        public DSTZone buildTailZone(String id) {
            if (this.iRules.size() == 2) {
                Rule startRule = this.iRules.get(0);
                Rule endRule = this.iRules.get(1);
                if (startRule.getToYear() == Integer.MAX_VALUE && endRule.getToYear() == Integer.MAX_VALUE) {
                    return new DSTZone(id, this.iStandardOffset, startRule.iRecurrence, endRule.iRecurrence);
                }
            }
            return null;
        }

        static {
            Calendar calendar = Calendar.getInstance();
            YEAR_LIMIT = calendar.get(1) + 100;
        }
    }

    private static final class Transition {
        private final long iMillis;
        private final int iWallOffset;
        private final int iStandardOffset;

        Transition(long millis, Transition tr) {
            this.iMillis = millis;
            this.iWallOffset = tr.iWallOffset;
            this.iStandardOffset = tr.iStandardOffset;
        }

        Transition(long millis, Rule rule, int standardOffset) {
            this.iMillis = millis;
            this.iWallOffset = standardOffset + rule.getSaveMillis();
            this.iStandardOffset = standardOffset;
        }

        Transition(long millis, int wallOffset, int standardOffset) {
            this.iMillis = millis;
            this.iWallOffset = wallOffset;
            this.iStandardOffset = standardOffset;
        }

        public long getMillis() {
            return this.iMillis;
        }

        public int getWallOffset() {
            return this.iWallOffset;
        }

        public int getStandardOffset() {
            return this.iStandardOffset;
        }

        public int getSaveMillis() {
            return this.iWallOffset - this.iStandardOffset;
        }

        public boolean isTransitionFrom(Transition other) {
            if (other == null) {
                return true;
            }
            return this.iMillis > other.iMillis && this.iWallOffset != other.iWallOffset;
        }
    }

    private static final class Rule {
        final Recurrence iRecurrence;
        final int iFromYear;
        final int iToYear;

        Rule(Recurrence recurrence, int fromYear, int toYear) {
            this.iRecurrence = recurrence;
            this.iFromYear = fromYear;
            this.iToYear = toYear;
        }

        public int getFromYear() {
            return this.iFromYear;
        }

        public int getToYear() {
            return this.iToYear;
        }

        public OfYear getOfYear() {
            return this.iRecurrence.getOfYear();
        }

        public int getSaveMillis() {
            return this.iRecurrence.getSaveMillis();
        }

        public long next(long instant, int standardOffset, int saveMillis) {
            long next;
            int year;
            Calendar calendar = Calendar.getInstance(DateTimeZoneBuilder.getGMT());
            int wallOffset = standardOffset + saveMillis;
            long testInstant = instant;
            if (instant == Long.MIN_VALUE) {
                year = Integer.MIN_VALUE;
            } else {
                calendar.setTimeInMillis(instant + (long)wallOffset);
                year = calendar.get(1);
            }
            if (year < this.iFromYear) {
                calendar.setTimeInMillis(0L);
                calendar.set(1, this.iFromYear);
                testInstant = calendar.getTimeInMillis() - (long)wallOffset;
                --testInstant;
            }
            if ((next = this.iRecurrence.next(testInstant, standardOffset, saveMillis)) > instant) {
                calendar.setTimeInMillis(next + (long)wallOffset);
                year = calendar.get(1);
                if (year > this.iToYear) {
                    next = instant;
                }
            }
            return next;
        }
    }

    static final class Recurrence {
        final OfYear iOfYear;
        final int iSaveMillis;

        Recurrence(OfYear ofYear, int saveMillis) {
            this.iOfYear = ofYear;
            this.iSaveMillis = saveMillis;
        }

        public OfYear getOfYear() {
            return this.iOfYear;
        }

        public long next(long instant, int standardOffset, int saveMillis) {
            return this.iOfYear.next(instant, standardOffset, saveMillis);
        }

        public long previous(long instant, int standardOffset, int saveMillis) {
            return this.iOfYear.previous(instant, standardOffset, saveMillis);
        }

        public int getSaveMillis() {
            return this.iSaveMillis;
        }

        public void write(StringBuilder sb) {
            this.iOfYear.write(sb);
            StorableDateTimeZone.writeTime(sb, this.iSaveMillis);
        }

        public static Recurrence read(CharFlow flow) {
            OfYear ofYear = OfYear.read(flow);
            int saveMillis = (int)StorableDateTimeZone.readTime(flow);
            return new Recurrence(ofYear, saveMillis);
        }
    }

    static final class OfYear {
        final char iMode;
        final int iMonthOfYear;
        final int iDayOfMonth;
        final int iDayOfWeek;
        final boolean iAdvance;
        final int iMillisOfDay;

        OfYear(char mode, int monthOfYear, int dayOfMonth, int dayOfWeek, boolean advanceDayOfWeek, int millisOfDay) {
            if (mode != 'u' && mode != 'w' && mode != 's') {
                throw new IllegalArgumentException("Unknown mode: " + mode);
            }
            this.iMode = mode;
            this.iMonthOfYear = monthOfYear;
            this.iDayOfMonth = dayOfMonth;
            this.iDayOfWeek = dayOfWeek;
            this.iAdvance = advanceDayOfWeek;
            this.iMillisOfDay = millisOfDay;
        }

        public void write(StringBuilder sb) {
            sb.append(this.iMode);
            Base46.encodeUnsigned(sb, this.iMonthOfYear);
            Base46.encodeUnsigned(sb, this.iDayOfMonth);
            Base46.encode(sb, this.iDayOfWeek);
            sb.append(this.iAdvance ? (char)'y' : 'n');
            StorableDateTimeZone.writeUnsignedTime(sb, this.iMillisOfDay);
        }

        public static OfYear read(CharFlow flow) {
            char mode = flow.characters[flow.pointer++];
            int monthOfYear = Base46.decodeUnsigned(flow);
            int dayOfMonth = Base46.decodeUnsigned(flow);
            int dayOfWeek = Base46.decode(flow);
            boolean advance = flow.characters[flow.pointer++] == 'y';
            int millisOfDay = (int)StorableDateTimeZone.readUnsignedTime(flow);
            return new OfYear(mode, monthOfYear, dayOfMonth, dayOfWeek, advance, millisOfDay);
        }

        public long setInstant(int year, int standardOffset, int saveMillis) {
            int offset = this.iMode == 'w' ? standardOffset + saveMillis : (this.iMode == 's' ? standardOffset : 0);
            Calendar calendar = Calendar.getInstance(DateTimeZoneBuilder.getGMT());
            calendar.setTimeInMillis(0L);
            calendar.set(1, year);
            calendar.set(2, this.iMonthOfYear - 1);
            calendar.set(10, 0);
            calendar.set(12, 0);
            calendar.set(13, 0);
            calendar.set(14, 0);
            calendar.add(14, this.iMillisOfDay);
            this.setDayOfMonth(calendar);
            if (this.iDayOfWeek != 0) {
                this.setDayOfWeek(calendar);
            }
            return calendar.getTimeInMillis() - (long)offset;
        }

        public long next(long instant, int standardOffset, int saveMillis) {
            int offset = this.iMode == 'w' ? standardOffset + saveMillis : (this.iMode == 's' ? standardOffset : 0);
            GregorianCalendar calendar = new GregorianCalendar(DateTimeZoneBuilder.getGMT());
            calendar.setTimeInMillis(instant += (long)offset);
            calendar.set(2, this.iMonthOfYear - 1);
            calendar.set(5, 1);
            calendar.set(11, 0);
            calendar.set(12, 0);
            calendar.set(13, 0);
            calendar.set(14, 0);
            calendar.add(14, this.iMillisOfDay);
            this.setDayOfMonthNext(calendar);
            if (this.iDayOfWeek == 0) {
                if (calendar.getTimeInMillis() <= instant) {
                    calendar.add(1, 1);
                    this.setDayOfMonthNext(calendar);
                }
            } else {
                this.setDayOfWeek(calendar);
                if (calendar.getTimeInMillis() <= instant) {
                    calendar.add(1, 1);
                    calendar.set(2, this.iMonthOfYear - 1);
                    this.setDayOfMonthNext(calendar);
                    this.setDayOfWeek(calendar);
                }
            }
            return calendar.getTimeInMillis() - (long)offset;
        }

        public long previous(long instant, int standardOffset, int saveMillis) {
            int offset = this.iMode == 'w' ? standardOffset + saveMillis : (this.iMode == 's' ? standardOffset : 0);
            GregorianCalendar calendar = new GregorianCalendar(DateTimeZoneBuilder.getGMT());
            calendar.setTimeInMillis(instant += (long)offset);
            calendar.set(2, this.iMonthOfYear - 1);
            calendar.set(5, 1);
            calendar.set(11, 0);
            calendar.set(12, 0);
            calendar.set(13, 0);
            calendar.set(14, 0);
            calendar.add(14, this.iMillisOfDay);
            this.setDayOfMonthPrevious(calendar);
            if (this.iDayOfWeek == 0) {
                if (calendar.getTimeInMillis() >= instant) {
                    calendar.add(1, -1);
                    this.setDayOfMonthPrevious(calendar);
                }
            } else {
                this.setDayOfWeek(calendar);
                if (calendar.getTimeInMillis() >= instant) {
                    calendar.add(1, -1);
                    calendar.set(2, this.iMonthOfYear - 1);
                    this.setDayOfMonthPrevious(calendar);
                    this.setDayOfWeek(calendar);
                }
            }
            return calendar.getTimeInMillis() - (long)offset;
        }

        private void setDayOfMonthNext(GregorianCalendar calendar) {
            if (calendar.get(2) == 1 && calendar.get(5) == 29) {
                while (!calendar.isLeapYear(calendar.get(1))) {
                    calendar.add(1, 1);
                }
            }
            this.setDayOfMonth(calendar);
        }

        private void setDayOfMonthPrevious(GregorianCalendar calendar) {
            if (calendar.get(2) == 1 && calendar.get(5) == 29) {
                while (!calendar.isLeapYear(calendar.get(1))) {
                    calendar.add(1, -1);
                }
            }
            this.setDayOfMonth(calendar);
        }

        private void setDayOfMonth(Calendar calendar) {
            if (this.iDayOfMonth >= 0) {
                calendar.set(5, this.iDayOfMonth);
            } else {
                calendar.set(5, 1);
                calendar.add(2, 1);
                calendar.add(5, this.iDayOfMonth);
            }
        }

        private void setDayOfWeek(Calendar calendar) {
            int dayOfWeek;
            int daysToAdd = (this.iDayOfWeek == 7 ? 1 : dayOfWeek + 1) - (dayOfWeek = calendar.get(7));
            if (daysToAdd != 0) {
                if (this.iAdvance) {
                    if (daysToAdd < 0) {
                        daysToAdd += 7;
                    }
                } else if (daysToAdd > 0) {
                    daysToAdd -= 7;
                }
                calendar.add(5, daysToAdd);
            }
        }
    }
}

