/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.impl.unicode;

import java.util.Map;
import org.teavm.classlib.impl.unicode.CLDRDateFormats;
import org.teavm.classlib.impl.unicode.CLDRLocale;
import org.teavm.classlib.impl.unicode.CLDRReader;
import org.teavm.classlib.impl.unicode.DateFormatCollection;
import org.teavm.model.MethodReference;
import org.teavm.platform.metadata.MetadataGenerator;
import org.teavm.platform.metadata.MetadataGeneratorContext;
import org.teavm.platform.metadata.Resource;
import org.teavm.platform.metadata.ResourceMap;

public class DateFormatMetadataGenerator
implements MetadataGenerator {
    public Resource generateMetadata(MetadataGeneratorContext context, MethodReference method) {
        switch (method.getName()) {
            case "getDateFormatMap": {
                return this.getDateFormatMap(context, new FormatExtractor(){

                    @Override
                    public CLDRDateFormats extract(CLDRLocale locale) {
                        return locale.getDateFormats();
                    }
                });
            }
            case "getTimeFormatMap": {
                return this.getDateFormatMap(context, new FormatExtractor(){

                    @Override
                    public CLDRDateFormats extract(CLDRLocale locale) {
                        return locale.getTimeFormats();
                    }
                });
            }
            case "getDateTimeFormatMap": {
                return this.getDateFormatMap(context, new FormatExtractor(){

                    @Override
                    public CLDRDateFormats extract(CLDRLocale locale) {
                        return locale.getDateTimeFormats();
                    }
                });
            }
        }
        throw new IllegalArgumentException("Method is not supported: " + method);
    }

    private Resource getDateFormatMap(MetadataGeneratorContext context, FormatExtractor extractor) {
        CLDRReader reader = (CLDRReader)context.getService(CLDRReader.class);
        ResourceMap result = context.createResourceMap();
        for (Map.Entry<String, CLDRLocale> entry : reader.getKnownLocales().entrySet()) {
            DateFormatCollection formatRes = (DateFormatCollection)context.createResource(DateFormatCollection.class);
            CLDRDateFormats formats = extractor.extract(entry.getValue());
            formatRes.setShortFormat(formats.getShortFormat());
            formatRes.setMediumFormat(formats.getMediumFormat());
            formatRes.setLongFormat(formats.getLongFormat());
            formatRes.setFullFormat(formats.getFullFormat());
            result.put(entry.getKey(), (Resource)formatRes);
        }
        return result;
    }

    static interface FormatExtractor {
        public CLDRDateFormats extract(CLDRLocale var1);
    }
}

