/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.impl.charset;

public class UTF16Helper {
    public static final int SURROGATE_NEUTRAL_BIT_MASK = 63488;
    public static final int SURROGATE_BITS = 55296;
    public static final int SURROGATE_BIT_MASK = 64512;
    public static final int SURROGATE_BIT_INV_MASK = 1023;
    public static final int HIGH_SURROGATE_BITS = 55296;
    public static final int LOW_SURROGATE_BITS = 56320;
    public static final int MEANINGFUL_SURROGATE_BITS = 10;
    public static final int SUPPLEMENTARY_PLANE = 65536;

    public static char highSurrogate(int codePoint) {
        return (char)(0xD800 | (codePoint -= 65536) >> 10 & 0x3FF);
    }

    public static char lowSurrogate(int codePoint) {
        return (char)(0xDC00 | codePoint & 0x3FF);
    }

    public static boolean isHighSurrogate(char c) {
        return (c & 0xFC00) == 55296;
    }

    public static boolean isLowSurrogate(char c) {
        return (c & 0xFC00) == 56320;
    }

    public static boolean isSurrogatePair(char a, char b) {
        return UTF16Helper.isHighSurrogate(a) && UTF16Helper.isLowSurrogate(b);
    }

    public static int buildCodePoint(char a, char b) {
        return ((a & 0x3FF) << 10 | b & 0x3FF) + 65536;
    }

    public static boolean isSurrogate(char c) {
        return (c & 0xF800) == 55296;
    }
}

