/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.util.zip;

import com.jcraft.jzlib.Deflater;
import com.jcraft.jzlib.GZIPException;
import java.util.Arrays;
import org.teavm.classlib.java.lang.TAutoCloseable;

public class TDeflater
implements TAutoCloseable {
    public static final int BEST_COMPRESSION = 9;
    public static final int BEST_SPEED = 1;
    public static final int DEFAULT_COMPRESSION = -1;
    public static final int DEFAULT_STRATEGY = 0;
    public static final int DEFLATED = 8;
    public static final int FILTERED = 1;
    public static final int HUFFMAN_ONLY = 2;
    public static final int NO_COMPRESSION = 0;
    static final int Z_NO_FLUSH = 0;
    static final int Z_SYNC_FLUSH = 2;
    static final int Z_FINISH = 4;
    private int flushParm = 0;
    private boolean finished;
    private int compressLevel = -1;
    private int strategy = 0;
    private Deflater impl;
    private int inRead;
    private int inLength;
    private boolean nowrap;

    public TDeflater() {
        this(-1, false);
    }

    public TDeflater(int level) {
        this(level, false);
    }

    public TDeflater(int level, boolean noHeader) {
        if (level < -1 || level > 9) {
            throw new IllegalArgumentException();
        }
        this.compressLevel = level;
        try {
            this.impl = new Deflater(this.compressLevel, noHeader);
        }
        catch (GZIPException gZIPException) {
            // empty catch block
        }
        this.nowrap = noHeader;
    }

    public int deflate(byte[] buf) {
        return this.deflate(buf, 0, buf.length);
    }

    public int deflate(byte[] buf, int off, int nbytes) {
        return this.deflate(buf, off, nbytes, this.flushParm);
    }

    int deflate(byte[] buf, int off, int nbytes, int flushParam) {
        if (this.impl == null) {
            throw new IllegalStateException();
        }
        if (off > buf.length || nbytes < 0 || off < 0 || buf.length - off < nbytes) {
            throw new ArrayIndexOutOfBoundsException();
        }
        long sin = this.impl.total_in;
        long sout = this.impl.total_out;
        this.impl.setOutput(buf, off, nbytes);
        int err = this.impl.deflate(flushParam);
        switch (err) {
            case 0: {
                break;
            }
            case 1: {
                this.finished = true;
                break;
            }
            default: {
                throw new RuntimeException("Error: " + err);
            }
        }
        this.inRead = (int)((long)this.inRead + (this.impl.total_in - sin));
        return (int)(this.impl.total_out - sout);
    }

    public void end() {
        this.impl = null;
    }

    public void finish() {
        this.flushParm = 4;
    }

    public boolean finished() {
        return this.finished;
    }

    public int getAdler() {
        if (this.impl == null) {
            throw new IllegalStateException();
        }
        return (int)this.impl.getAdler();
    }

    public int getTotalIn() {
        if (this.impl == null) {
            throw new IllegalStateException();
        }
        return (int)this.impl.getTotalIn();
    }

    public int getTotalOut() {
        if (this.impl == null) {
            throw new IllegalStateException();
        }
        return (int)this.impl.getTotalOut();
    }

    public boolean needsInput() {
        return this.inRead == this.inLength;
    }

    public void reset() {
        if (this.impl == null) {
            throw new NullPointerException();
        }
        this.flushParm = 0;
        this.finished = false;
        this.impl.init(this.compressLevel, 15, this.nowrap);
        this.impl.params(this.compressLevel, this.strategy);
    }

    public void setDictionary(byte[] buf) {
        this.setDictionary(buf, 0, buf.length);
    }

    public void setDictionary(byte[] buf, int off, int nbytes) {
        if (this.impl == null) {
            throw new IllegalStateException();
        }
        if (off > buf.length || nbytes < 0 || off < 0 || buf.length - off < nbytes) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.impl.setDictionary(Arrays.copyOfRange(buf, off, buf.length), nbytes);
    }

    public void setInput(byte[] buf) {
        this.setInput(buf, 0, buf.length);
    }

    public void setInput(byte[] buf, int off, int nbytes) {
        if (this.impl == null) {
            throw new IllegalStateException();
        }
        if (off <= buf.length && nbytes >= 0 && off >= 0 && buf.length - off >= nbytes) {
            this.inLength = nbytes;
            this.inRead = 0;
            if (this.impl.next_in == null) {
                this.impl.init(this.compressLevel, 15, this.nowrap);
            }
        } else {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.impl.setInput(buf, off, nbytes, false);
    }

    public void setLevel(int level) {
        if (level < -1 || level > 9) {
            throw new IllegalArgumentException();
        }
        this.compressLevel = level;
    }

    public void setStrategy(int strategy) {
        if (strategy < 0 || strategy > 2) {
            throw new IllegalArgumentException();
        }
        this.strategy = strategy;
    }

    public long getBytesRead() {
        if (this.impl == null) {
            throw new NullPointerException();
        }
        return this.impl.getTotalIn();
    }

    public long getBytesWritten() {
        if (this.impl == null) {
            throw new NullPointerException();
        }
        return this.impl.getTotalOut();
    }

    @Override
    public void close() throws Exception {
        this.end();
    }
}

