/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.util.stream.doubleimpl;

import java.util.function.DoublePredicate;
import org.teavm.classlib.java.util.stream.doubleimpl.TSimpleDoubleStreamImpl;

public class TDropWhileDoubleStream
extends TSimpleDoubleStreamImpl {
    private TSimpleDoubleStreamImpl sourceStream;
    private DoublePredicate predicate;
    private boolean isStarted;

    TDropWhileDoubleStream(TSimpleDoubleStreamImpl sourceStream, DoublePredicate predicate) {
        this.sourceStream = sourceStream;
        this.predicate = predicate;
    }

    @Override
    public boolean next(final DoublePredicate consumer) {
        if (!this.isStarted) {
            var skippingPredicate = new DoublePredicate(){
                boolean consumerCanTakeMore;

                @Override
                public boolean test(double t) {
                    if (TDropWhileDoubleStream.this.predicate.test(t)) {
                        return true;
                    }
                    TDropWhileDoubleStream.this.isStarted = true;
                    this.consumerCanTakeMore = consumer.test(t);
                    return false;
                }
            };
            boolean result = this.sourceStream.next(skippingPredicate);
            if (!result) {
                return false;
            }
            if (!skippingPredicate.consumerCanTakeMore) {
                return true;
            }
        }
        return this.sourceStream.next(consumer);
    }

    @Override
    public void close() {
        this.sourceStream.close();
    }
}

