/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.util;

import java.util.RandomAccess;
import org.teavm.classlib.java.lang.TBoolean;
import org.teavm.classlib.java.lang.TComparable;
import org.teavm.classlib.java.lang.TIllegalStateException;
import org.teavm.classlib.java.lang.TIndexOutOfBoundsException;
import org.teavm.classlib.java.lang.TObject;
import org.teavm.classlib.java.lang.TUnsupportedOperationException;
import org.teavm.classlib.java.util.TAbstractCollection;
import org.teavm.classlib.java.util.TAbstractList;
import org.teavm.classlib.java.util.TAbstractMap;
import org.teavm.classlib.java.util.TAbstractSet;
import org.teavm.classlib.java.util.TArrayList;
import org.teavm.classlib.java.util.TArrays;
import org.teavm.classlib.java.util.TCheckedCollection;
import org.teavm.classlib.java.util.TCheckedList;
import org.teavm.classlib.java.util.TCheckedMap;
import org.teavm.classlib.java.util.TCheckedSet;
import org.teavm.classlib.java.util.TCollection;
import org.teavm.classlib.java.util.TComparator;
import org.teavm.classlib.java.util.TEnumeration;
import org.teavm.classlib.java.util.TIterator;
import org.teavm.classlib.java.util.TList;
import org.teavm.classlib.java.util.TListIterator;
import org.teavm.classlib.java.util.TMap;
import org.teavm.classlib.java.util.TNoSuchElementException;
import org.teavm.classlib.java.util.TObjects;
import org.teavm.classlib.java.util.TRandom;
import org.teavm.classlib.java.util.TRandomAccess;
import org.teavm.classlib.java.util.TSequencedMap;
import org.teavm.classlib.java.util.TSequencedSet;
import org.teavm.classlib.java.util.TSet;
import org.teavm.classlib.java.util.TSetFromMap;
import org.teavm.classlib.java.util.TTemplateCollections;
import org.teavm.classlib.java.util.random.TRandomGenerator;

public final class TCollections
extends TObject {
    public static final TSet EMPTY_SET = new TTemplateCollections.AbstractImmutableSet<Object>(){

        @Override
        public int size() {
            return 0;
        }

        @Override
        public TIterator<Object> iterator() {
            return TCollections.emptyIterator();
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public boolean contains(Object o) {
            return false;
        }

        @Override
        public boolean containsAll(TCollection<?> c) {
            return c.isEmpty();
        }
    };
    public static final TMap EMPTY_MAP = new TTemplateCollections.AbstractImmutableMap<Object, Object>(){

        @Override
        public TSet<TMap.Entry<Object, Object>> entrySet() {
            return TCollections.emptySet();
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public Object get(Object key) {
            return null;
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public boolean containsKey(Object key) {
            return false;
        }

        @Override
        public boolean containsValue(Object value) {
            return false;
        }
    };
    public static final TList EMPTY_LIST = new TTemplateCollections.AbstractImmutableList<Object>(){

        @Override
        public Object get(int index) {
            throw new TIndexOutOfBoundsException();
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public TIterator<Object> iterator() {
            return TCollections.emptyIterator();
        }

        @Override
        public TListIterator<Object> listIterator(int index) {
            if (index != 0) {
                throw new IndexOutOfBoundsException();
            }
            return TCollections.emptyListIterator();
        }

        @Override
        public boolean isEmpty() {
            return true;
        }
    };
    private static final TIterator<?> EMPTY_ITERATOR = new TIterator<Object>(){

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public Object next() {
            throw new TNoSuchElementException();
        }

        @Override
        public void remove() {
            throw new TIllegalStateException();
        }
    };
    private static final TListIterator<?> EMPTY_LIST_ITERATOR = new TListIterator<Object>(){

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public Object next() {
            throw new TNoSuchElementException();
        }

        @Override
        public void remove() {
            throw new TIllegalStateException();
        }

        @Override
        public boolean hasPrevious() {
            return false;
        }

        @Override
        public Object previous() {
            throw new TNoSuchElementException();
        }

        @Override
        public int nextIndex() {
            return 0;
        }

        @Override
        public int previousIndex() {
            return -1;
        }

        @Override
        public void set(Object e) {
            throw new TUnsupportedOperationException();
        }

        @Override
        public void add(Object e) {
            throw new TUnsupportedOperationException();
        }
    };
    private static TComparator<Object> reverseOrder = (o1, o2) -> ((TComparable)o2).compareTo(o1);

    public static <T> TIterator<T> emptyIterator() {
        return EMPTY_ITERATOR;
    }

    public static <T> TListIterator<T> emptyListIterator() {
        return EMPTY_LIST_ITERATOR;
    }

    public static <T> TList<T> emptyList() {
        return EMPTY_LIST;
    }

    public static <T> TEnumeration<T> emptyEnumeration() {
        return new TEnumeration<T>(){

            @Override
            public boolean hasMoreElements() {
                return false;
            }

            @Override
            public T nextElement() {
                throw new TNoSuchElementException();
            }
        };
    }

    public static <T> TSet<T> emptySet() {
        return EMPTY_SET;
    }

    public static <K, V> TMap<K, V> emptyMap() {
        return EMPTY_MAP;
    }

    public static <T> TList<T> singletonList(T o) {
        return new TTemplateCollections.SingleElementList<T>(o);
    }

    public static <T> TSet<T> singleton(T o) {
        return new TTemplateCollections.SingleElementSet<T>(o);
    }

    public static <K, V> TMap<K, V> singletonMap(K key, V value) {
        final TSet<TAbstractMap.SimpleImmutableEntry<K, V>> entries = TCollections.singleton(new TAbstractMap.SimpleImmutableEntry<K, V>(key, value));
        return new TAbstractMap<K, V>(){

            @Override
            public TSet<TMap.Entry<K, V>> entrySet() {
                return entries;
            }
        };
    }

    public static <T> TList<T> nCopies(final int n, final T o) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        return new TAbstractList<T>(){

            @Override
            public T get(int index) {
                if (index < 0 || index >= n) {
                    throw new TIndexOutOfBoundsException();
                }
                return o;
            }

            @Override
            public int size() {
                return n;
            }
        };
    }

    public static void swap(TList<?> list, int i, int j) {
        TList<?> objList = list;
        Object tmp = objList.get(i);
        objList.set(i, objList.get(j));
        objList.set(j, tmp);
    }

    public static <T> void sort(TList<T> list, TComparator<? super T> c) {
        if (c == null) {
            c = TComparator.NaturalOrder.instance();
        }
        Object[] array = new Object[list.size()];
        list.toArray(array);
        TArrays.sort(array, c);
        for (int i = 0; i < array.length; ++i) {
            list.set(i, array[i]);
        }
    }

    public static <T extends TComparable<? super T>> void sort(TList<T> list) {
        TCollections.sort(list, TComparator.NaturalOrder.instance());
    }

    public static void reverse(TList<?> list) {
        if (list instanceof RandomAccess) {
            TCollections.reverse(list, 0, list.size());
        } else {
            TArrayList randomAccess = new TArrayList(list);
            TCollections.reverse(randomAccess, 0, randomAccess.size());
            list.clear();
            list.addAll(randomAccess);
        }
    }

    public static <T> int binarySearch(TList<? extends TComparable<? super T>> list, T key) {
        return TCollections.binarySearch(list, key, TComparator.NaturalOrder.instance());
    }

    public static <T> int binarySearch(TList<? extends T> list, T key, TComparator<? super T> c) {
        int i;
        if (!(list instanceof TRandomAccess)) {
            list = new TArrayList<T>(list);
        }
        if (c == null) {
            c = TComparator.NaturalOrder.instance();
        }
        int l = 0;
        int u = list.size() - 1;
        if (u < 0) {
            return -1;
        }
        while (true) {
            T e;
            int cmp;
            if ((cmp = c.compare(e = list.get(i = (l + u) / 2), key)) == 0) {
                return i;
            }
            if (cmp > 0) {
                u = i - 1;
                if (u >= l) continue;
                return -i - 1;
            }
            l = i + 1;
            if (l > u) break;
        }
        return -i - 2;
    }

    public static void shuffle(TList<?> list) {
        TCollections.shuffle(list, new TRandom());
    }

    public static void shuffle(TList<?> list, TRandom rnd) {
        TCollections.shuffle(list, (TRandomGenerator)rnd);
    }

    public static void shuffle(TList<?> list, TRandomGenerator rnd) {
        if (list instanceof TRandomAccess) {
            TCollections.shuffleRandomAccess(list, rnd);
        } else {
            TArrayList randomAccess = new TArrayList(list);
            TCollections.shuffleRandomAccess(randomAccess, rnd);
            list.clear();
            list.addAll(randomAccess);
        }
    }

    private static void shuffleRandomAccess(TList<?> list, TRandomGenerator rnd) {
        for (int i = list.size() - 1; i > 0; --i) {
            int j = rnd.nextInt(i + 1);
            TCollections.swap(list, i, j);
        }
    }

    public static <T> void fill(TList<? super T> list, T obj) {
        if (list instanceof RandomAccess) {
            for (int i = 0; i < list.size(); ++i) {
                list.set(i, obj);
            }
        } else {
            TListIterator<T> iter = list.listIterator();
            while (iter.hasNext()) {
                iter.next();
                iter.set(obj);
            }
        }
    }

    public static <T> void copy(TList<? super T> dest, TList<? extends T> src) {
        if (src.size() > dest.size()) {
            throw new IndexOutOfBoundsException();
        }
        if (src instanceof RandomAccess && dest instanceof RandomAccess) {
            for (int i = 0; i < src.size(); ++i) {
                dest.set(i, src.get(i));
            }
        } else {
            TListIterator<T> srcIter = src.listIterator();
            TListIterator<T> destIter = dest.listIterator();
            while (srcIter.hasNext()) {
                destIter.next();
                destIter.set(srcIter.next());
            }
        }
    }

    public static <T> T min(TCollection<? extends T> coll) {
        return TCollections.min(coll, TComparator.NaturalOrder.instance());
    }

    public static <T> T min(TCollection<? extends T> coll, TComparator<? super T> comp) {
        if (comp == null) {
            comp = TComparator.NaturalOrder.instance();
        }
        TIterator iter = coll.iterator();
        Object min = iter.next();
        while (iter.hasNext()) {
            Object elem = iter.next();
            if (comp.compare(elem, min) >= 0) continue;
            min = elem;
        }
        return min;
    }

    public static <T> T max(TCollection<? extends T> coll) {
        return TCollections.max(coll, TComparator.NaturalOrder.instance());
    }

    public static <T> T max(TCollection<? extends T> coll, TComparator<? super T> comp) {
        if (comp == null) {
            comp = TComparator.NaturalOrder.instance();
        }
        TIterator iter = coll.iterator();
        Object max = iter.next();
        while (iter.hasNext()) {
            Object elem = iter.next();
            if (comp.compare(elem, max) <= 0) continue;
            max = elem;
        }
        return max;
    }

    public static void rotate(TList<?> list, int distance) {
        if (list instanceof TRandomAccess) {
            TCollections.rotateRandomAccess(list, distance);
        } else {
            TArrayList randomAccess = new TArrayList(list);
            TCollections.rotateRandomAccess(randomAccess, distance);
            list.clear();
            list.addAll(randomAccess);
        }
    }

    private static void rotateRandomAccess(TList<?> list, int distance) {
        if ((distance %= list.size()) < 0) {
            distance += list.size();
        }
        if (distance == 0) {
            return;
        }
        TCollections.reverse(list, 0, list.size());
        TCollections.reverse(list, 0, distance);
        TCollections.reverse(list, distance, list.size());
    }

    private static void reverse(TList<?> list, int from, int to) {
        TList<?> safeList = list;
        int half = (from + to) / 2;
        int j = to - 1;
        int i = from;
        while (i < half) {
            Object tmp = safeList.get(i);
            safeList.set(i, safeList.get(j));
            safeList.set(j, tmp);
            ++i;
            --j;
        }
    }

    public static <T> boolean replaceAll(TList<T> list, T oldVal, T newVal) {
        TListIterator<T> iter = list.listIterator();
        boolean hasValue = false;
        while (iter.hasNext()) {
            if (!TObjects.equals(iter.next(), oldVal)) continue;
            iter.set(newVal);
            hasValue = true;
        }
        return hasValue;
    }

    public static int indexOfSubList(TList<?> source, TList<?> target) {
        int sz = source.size() - target.size();
        if (sz < 0) {
            return -1;
        }
        if (source instanceof RandomAccess) {
            source = new TArrayList(source);
        }
        block0: for (int i = 0; i <= sz; ++i) {
            int j = i;
            TIterator iter = target.iterator();
            while (iter.hasNext()) {
                if (iter.next().equals(source.get(j++))) continue;
                continue block0;
            }
            return i;
        }
        return -1;
    }

    public static int lastIndexOfSubList(TList<?> source, TList<?> target) {
        int start = source.size() - target.size();
        if (start < 0) {
            return -1;
        }
        if (source instanceof RandomAccess) {
            source = new TArrayList(source);
        }
        block0: for (int i = start; i >= 0; --i) {
            int j = i;
            TIterator iter = target.iterator();
            while (iter.hasNext()) {
                if (iter.next().equals(source.get(j++))) continue;
                continue block0;
            }
            return i;
        }
        return -1;
    }

    public static <T> TList<T> unmodifiableList(final TList<? extends T> list) {
        TObjects.requireNonNull(list);
        return new TAbstractList<T>(){

            @Override
            public T get(int index) {
                return list.get(index);
            }

            @Override
            public int size() {
                return list.size();
            }

            @Override
            public boolean remove(Object o) {
                throw new UnsupportedOperationException();
            }
        };
    }

    public static <T> TCollection<T> unmodifiableCollection(final TCollection<? extends T> c) {
        TObjects.requireNonNull(c);
        return new TAbstractCollection<T>(){

            @Override
            public TIterator<T> iterator() {
                return TCollections.unmodifiableIterator(c.iterator());
            }

            @Override
            public int size() {
                return c.size();
            }

            @Override
            public boolean remove(Object o) {
                throw new UnsupportedOperationException();
            }
        };
    }

    private static <T> TIterator<T> unmodifiableIterator(final TIterator<? extends T> c) {
        return new TIterator<T>(){

            @Override
            public boolean hasNext() {
                return c.hasNext();
            }

            @Override
            public T next() {
                return c.next();
            }

            @Override
            public void remove() {
                throw new TUnsupportedOperationException();
            }
        };
    }

    public static <T> TSet<T> unmodifiableSet(final TSet<? extends T> s) {
        TObjects.requireNonNull(s);
        return new TAbstractSet<T>(){

            @Override
            public TIterator<T> iterator() {
                return TCollections.unmodifiableIterator(s.iterator());
            }

            @Override
            public int size() {
                return s.size();
            }

            @Override
            public boolean remove(Object o) {
                throw new UnsupportedOperationException();
            }
        };
    }

    public static <K, V> TMap<K, V> unmodifiableMap(final TMap<? extends K, ? extends V> m) {
        TObjects.requireNonNull(m);
        return new TAbstractMap<K, V>(){

            @Override
            public TSet<TMap.Entry<K, V>> entrySet() {
                return TCollections.unmodifiableMapEntrySet(m.entrySet());
            }

            @Override
            public V remove(Object o) {
                throw new UnsupportedOperationException();
            }
        };
    }

    private static <K, V> TSet<TMap.Entry<K, V>> unmodifiableMapEntrySet(final TSet<? extends TMap.Entry<? extends K, ? extends V>> c) {
        return new TAbstractSet<TMap.Entry<K, V>>(){

            @Override
            public int size() {
                return c.size();
            }

            @Override
            public TIterator<TMap.Entry<K, V>> iterator() {
                return TCollections.unmodifiableMapEntryIterator(c.iterator());
            }

            @Override
            public boolean remove(Object o) {
                throw new UnsupportedOperationException();
            }
        };
    }

    private static <K, V> TIterator<TMap.Entry<K, V>> unmodifiableMapEntryIterator(final TIterator<? extends TMap.Entry<? extends K, ? extends V>> c) {
        return new TIterator<TMap.Entry<K, V>>(){

            @Override
            public boolean hasNext() {
                return c.hasNext();
            }

            @Override
            public TMap.Entry<K, V> next() {
                return new TAbstractMap.SimpleImmutableEntry((TMap.Entry)c.next());
            }

            @Override
            public void remove() {
                throw new TUnsupportedOperationException();
            }
        };
    }

    public static <T> TCollection<T> synchronizedCollection(TCollection<T> c) {
        return c;
    }

    public static <T> TSet<T> synchronizedSet(TSet<T> s) {
        return s;
    }

    public static <T> TList<T> synchronizedList(TList<T> list) {
        return list;
    }

    public static <K, V> TMap<K, V> synchronizedMap(TMap<K, V> m) {
        return m;
    }

    public static <T> TComparator<T> reverseOrder() {
        return reverseOrder;
    }

    public static <T> TComparator<T> reverseOrder(TComparator<T> cmp) {
        if (cmp == null) {
            return TCollections.reverseOrder();
        }
        return (o1, o2) -> -cmp.compare(o1, o2);
    }

    public static <T> TEnumeration<T> enumeration(TCollection<T> c) {
        final TIterator iter = c.iterator();
        return new TEnumeration<T>(){

            @Override
            public boolean hasMoreElements() {
                return iter.hasNext();
            }

            @Override
            public T nextElement() {
                return iter.next();
            }
        };
    }

    public static <T> TArrayList<T> list(TEnumeration<T> e) {
        TArrayList<T> list = new TArrayList<T>();
        while (e.hasMoreElements()) {
            list.add(e.nextElement());
        }
        return list;
    }

    public static <E> TCollection<E> checkedCollection(TCollection<E> c, Class<E> type) {
        return new TCheckedCollection<E>(c, type);
    }

    public static <E> TSet<E> checkedSet(TSet<E> s, Class<E> type) {
        return new TCheckedSet<E>(s, type);
    }

    public static <E> TList<E> checkedList(TList<E> list, Class<E> type) {
        return new TCheckedList<E>(list, type);
    }

    public static <K, V> TMap<K, V> checkedMap(TMap<K, V> m, Class<K> keyType, Class<V> valueType) {
        return new TCheckedMap<K, V>(m, keyType, valueType);
    }

    public static int frequency(TCollection<?> c, Object o) {
        int freq = 0;
        TIterator iter = c.iterator();
        while (iter.hasNext()) {
            if (!TObjects.equals(iter.next(), o)) continue;
            ++freq;
        }
        return freq;
    }

    public static boolean disjoint(TCollection<?> c1, TCollection<?> c2) {
        if (c1.size() > c2.size()) {
            TCollection<?> tmp = c1;
            c1 = c2;
            c2 = tmp;
        }
        TIterator iter = c1.iterator();
        while (iter.hasNext()) {
            if (!c2.contains(iter.next())) continue;
            return false;
        }
        return true;
    }

    @SafeVarargs
    public static <T> boolean addAll(TCollection<? super T> c, T ... elements) {
        return c.addAll(TArrays.asList(elements));
    }

    public static <E> TSet<E> newSetFromMap(TMap<E, TBoolean> map) {
        if (!map.isEmpty()) {
            throw new IllegalArgumentException();
        }
        return new TSetFromMap<E>(map);
    }

    public static <E> TSequencedSet<E> newSequencedSetFromMap(TSequencedMap<E, TBoolean> map) {
        if (!map.isEmpty()) {
            throw new IllegalArgumentException();
        }
        return new TSetFromMap.SequencedSetFromMap<E>(map);
    }
}

