/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.nio;

import org.teavm.classlib.PlatformDetector;
import org.teavm.interop.Address;
import org.teavm.jso.typedarrays.ArrayBuffer;
import org.teavm.jso.typedarrays.Int16Array;
import org.teavm.jso.typedarrays.Int8Array;

public final class TByteOrder {
    public static final TByteOrder BIG_ENDIAN = new TByteOrder("BIG_ENDIAN");
    public static final TByteOrder LITTLE_ENDIAN = new TByteOrder("LITTLE_ENDIAN");
    private static TByteOrder nativeOrder;
    private String name;

    private TByteOrder(String name) {
        this.name = name;
    }

    public static TByteOrder nativeOrder() {
        if (nativeOrder == null) {
            if (PlatformDetector.isJavaScript() || PlatformDetector.isWebAssemblyGC()) {
                ArrayBuffer buffer = new ArrayBuffer(2);
                Int16Array shortArray = new Int16Array(buffer);
                shortArray.set(0, (short)1);
                Int8Array byteArray = new Int8Array(buffer);
                nativeOrder = byteArray.get(0) == 0 ? BIG_ENDIAN : LITTLE_ENDIAN;
            } else {
                short[] array = new short[]{1};
                byte firstByte = Address.ofData((short[])array).getByte();
                nativeOrder = firstByte == 0 ? BIG_ENDIAN : LITTLE_ENDIAN;
            }
        }
        return nativeOrder;
    }

    public String toString() {
        return this.name;
    }
}

