/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.lang.reflect;

import java.util.HashSet;
import java.util.Set;
import org.teavm.dependency.DependencyAgent;
import org.teavm.dependency.DependencyPlugin;
import org.teavm.dependency.MethodDependency;
import org.teavm.model.MethodReference;
import org.teavm.model.ValueType;

public class ArrayDependencyPlugin
implements DependencyPlugin {
    private static final String[] primitives = new String[]{"Byte", "Short", "Char", "Int", "Long", "Float", "Double", "Boolean"};
    private static final String[] primitiveWrappers = new String[]{"Byte", "Short", "Character", "Integer", "Long", "Float", "Double", "Boolean"};
    private static final ValueType[] primitiveTypes = new ValueType[]{ValueType.BYTE, ValueType.SHORT, ValueType.CHARACTER, ValueType.INTEGER, ValueType.LONG, ValueType.FLOAT, ValueType.DOUBLE, ValueType.BOOLEAN};
    private Set<MethodReference> reachedMethods = new HashSet<MethodReference>();

    public void methodReached(DependencyAgent agent, MethodDependency method) {
        if (!this.reachedMethods.add(method.getReference())) {
            return;
        }
        switch (method.getReference().getName()) {
            case "getLength": {
                this.reachGetLength(agent, method);
                break;
            }
            case "newInstance": {
                method.getVariable(1).getClassValueNode().addConsumer(t -> {
                    int degree = 0;
                    ValueType type = t.getValueType();
                    while (type instanceof ValueType.Array) {
                        type = ((ValueType.Array)type).getItemType();
                        ++degree;
                    }
                    if (degree < 3) {
                        method.getResult().propagate(agent.getType((ValueType)ValueType.arrayOf((ValueType)t.getValueType())));
                    }
                });
                break;
            }
            case "getImpl": {
                this.reachGet(agent, method);
                break;
            }
            case "setImpl": {
                this.reachSet(agent, method);
            }
        }
    }

    private void reachGetLength(DependencyAgent agent, MethodDependency method) {
        method.getVariable(1).addConsumer(type -> {
            if (!(type.getValueType() instanceof ValueType.Array)) {
                MethodReference cons = new MethodReference(IllegalArgumentException.class, "<init>", new Class[]{Void.TYPE});
                agent.linkMethod(cons).use();
            }
        });
    }

    private void reachGet(DependencyAgent agent, MethodDependency method) {
        method.getVariable(1).getArrayItem().connect(method.getResult());
        method.getVariable(1).addConsumer(type -> {
            if (!(type.getValueType() instanceof ValueType.Array)) {
                return;
            }
            ValueType itemType = ((ValueType.Array)type.getValueType()).getItemType();
            for (int i = 0; i < primitiveTypes.length; ++i) {
                if (!primitiveTypes[i].equals(itemType)) continue;
                String wrapper = "java.lang." + primitiveWrappers[i];
                MethodReference methodRef = new MethodReference(wrapper, "valueOf", new ValueType[]{primitiveTypes[i], ValueType.object((String)wrapper)});
                agent.linkMethod(methodRef).use();
                method.getResult().propagate(agent.getType((ValueType)ValueType.object((String)("java.lang." + primitiveWrappers[i]))));
            }
        });
    }

    private void reachSet(DependencyAgent agent, MethodDependency method) {
        method.getVariable(3).connect(method.getVariable(1).getArrayItem());
        method.getVariable(1).addConsumer(type -> {
            if (!(type.getValueType() instanceof ValueType.Array)) {
                return;
            }
            ValueType itemType = ((ValueType.Array)type.getValueType()).getItemType();
            for (int i = 0; i < primitiveTypes.length; ++i) {
                if (!primitiveTypes[i].equals(itemType)) continue;
                String wrapper = "java.lang." + primitiveWrappers[i];
                MethodReference methodRef = new MethodReference(wrapper, primitives[i].toLowerCase() + "Value", new ValueType[]{primitiveTypes[i]});
                agent.linkMethod(methodRef).use();
            }
        });
    }
}

