/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.lang;

import org.teavm.backend.javascript.spi.GeneratedBy;
import org.teavm.backend.wasm.WasmRuntime;
import org.teavm.backend.wasm.runtime.WasmSupport;
import org.teavm.classlib.PlatformDetector;
import org.teavm.classlib.java.lang.MathNativeGenerator;
import org.teavm.classlib.java.lang.TDouble;
import org.teavm.classlib.java.lang.TFloat;
import org.teavm.classlib.java.lang.TObject;
import org.teavm.interop.Import;
import org.teavm.interop.NoSideEffects;
import org.teavm.interop.Unmanaged;

@NoSideEffects
public final class TMath
extends TObject {
    public static final double E = Math.E;
    public static final double PI = Math.PI;
    public static final double TAU = Math.PI * 2;

    private TMath() {
    }

    @GeneratedBy(value=MathNativeGenerator.class)
    @Import(module="teavmMath", name="sin")
    @Unmanaged
    public static native double sin(double var0);

    @GeneratedBy(value=MathNativeGenerator.class)
    @Import(module="teavmMath", name="cos")
    @Unmanaged
    public static native double cos(double var0);

    @GeneratedBy(value=MathNativeGenerator.class)
    @Import(module="teavmMath", name="tan")
    @Unmanaged
    public static native double tan(double var0);

    @GeneratedBy(value=MathNativeGenerator.class)
    @Import(module="teavmMath", name="asin")
    @Unmanaged
    public static native double asin(double var0);

    @GeneratedBy(value=MathNativeGenerator.class)
    @Import(module="teavmMath", name="acos")
    @Unmanaged
    public static native double acos(double var0);

    @GeneratedBy(value=MathNativeGenerator.class)
    @Import(module="teavmMath", name="atan")
    @Unmanaged
    public static native double atan(double var0);

    public static double toRadians(double angdeg) {
        return angdeg * Math.PI / 180.0;
    }

    public static double toDegrees(double angrad) {
        return angrad * 180.0 / Math.PI;
    }

    @GeneratedBy(value=MathNativeGenerator.class)
    @Import(module="teavmMath", name="exp")
    @Unmanaged
    public static native double exp(double var0);

    @GeneratedBy(value=MathNativeGenerator.class)
    @Import(module="teavmMath", name="log")
    @Unmanaged
    public static native double log(double var0);

    public static double log10(double a) {
        return TMath.log(a) / 2.302585092994046;
    }

    @GeneratedBy(value=MathNativeGenerator.class)
    @Import(module="teavmMath", name="sqrt")
    @Unmanaged
    public static native double sqrt(double var0);

    public static double cbrt(double a) {
        return a > 0.0 ? TMath.pow(a, 0.3333333333333333) : -TMath.pow(-a, 0.3333333333333333);
    }

    public static double IEEEremainder(double f1, double f2) {
        int n = (int)(f1 / f2);
        return f1 - (double)n * f2;
    }

    @GeneratedBy(value=MathNativeGenerator.class)
    @Import(module="teavmMath", name="ceil")
    @Unmanaged
    public static native double ceil(double var0);

    @GeneratedBy(value=MathNativeGenerator.class)
    @Import(module="teavmMath", name="floor")
    @Unmanaged
    public static native double floor(double var0);

    public static double pow(double x, double y) {
        if (PlatformDetector.isWebAssembly()) {
            return WasmSupport.pow((double)x, (double)y);
        }
        return TMath.powImpl(x, y);
    }

    @GeneratedBy(value=MathNativeGenerator.class)
    @Import(module="teavmMath", name="pow")
    @Unmanaged
    private static native double powImpl(double var0, double var2);

    public static double rint(double a) {
        return TMath.round(a);
    }

    @GeneratedBy(value=MathNativeGenerator.class)
    @Import(module="teavmMath", name="atan2")
    @Unmanaged
    public static native double atan2(double var0, double var2);

    public static int round(float a) {
        return (int)(a + TMath.signum(a) * 0.5f);
    }

    public static long round(double a) {
        return (long)(a + TMath.signum(a) * 0.5);
    }

    public static int floorDiv(int a, int b) {
        int div = a / b;
        return (a ^ b) < 0 && div * b != a ? div - 1 : div;
    }

    public static int floorDivExact(int a, int b) {
        if (a == Integer.MIN_VALUE && b == -1) {
            throw new ArithmeticException();
        }
        return TMath.floorDiv(a, b);
    }

    public static long floorDiv(long a, int b) {
        return TMath.floorDiv(a, (long)b);
    }

    public static long floorDiv(long a, long b) {
        long div = a / b;
        return (a ^ b) < 0L && div * b != a ? div - 1L : div;
    }

    public static long floorDivExact(long a, long b) {
        if (a == Long.MIN_VALUE && b == -1L) {
            throw new ArithmeticException();
        }
        return TMath.floorDiv(a, b);
    }

    public static int ceilDiv(int a, int b) {
        int div = a / b;
        return (a ^ b) >= 0 && div * b != a ? div + 1 : div;
    }

    public static int ceilDivExact(int a, int b) {
        if (a == Integer.MIN_VALUE && b == -1) {
            throw new ArithmeticException();
        }
        return TMath.ceilDiv(a, b);
    }

    public static long ceilDiv(long a, int b) {
        return TMath.ceilDiv(a, (long)b);
    }

    public static long ceilDiv(long a, long b) {
        long div = a / b;
        return (a ^ b) >= 0L && div * b != a ? div + 1L : div;
    }

    public static long ceilDivExact(long a, long b) {
        if (a == Long.MIN_VALUE && b == -1L) {
            throw new ArithmeticException();
        }
        return TMath.ceilDiv(a, b);
    }

    public static int floorMod(int a, int b) {
        int mod = a % b;
        return (a ^ b) < 0 && mod != 0 ? mod + b : mod;
    }

    public static int floorMod(long a, int b) {
        return (int)TMath.floorMod(a, (long)b);
    }

    public static long floorMod(long a, long b) {
        long mod = a % b;
        return (a ^ b) < 0L && mod != 0L ? mod + b : mod;
    }

    public static int ceilMod(int a, int b) {
        int mod = a % b;
        return (a ^ b) >= 0 && mod != 0 ? mod - b : mod;
    }

    public static int ceilMod(long a, int b) {
        return (int)TMath.ceilMod(a, (long)b);
    }

    public static long ceilMod(long a, long b) {
        long mod = a % b;
        return (a ^ b) >= 0L && mod != 0L ? mod - b : mod;
    }

    public static int incrementExact(int a) {
        if (a == Integer.MAX_VALUE) {
            throw new ArithmeticException();
        }
        return a + 1;
    }

    public static long incrementExact(long a) {
        if (a == Long.MAX_VALUE) {
            throw new ArithmeticException();
        }
        return a + 1L;
    }

    public static int decrementExact(int a) {
        if (a == Integer.MIN_VALUE) {
            throw new ArithmeticException();
        }
        return a - 1;
    }

    public static long decrementExact(long a) {
        if (a == Long.MIN_VALUE) {
            throw new ArithmeticException();
        }
        return a - 1L;
    }

    public static int negateExact(int a) {
        if (a == Integer.MIN_VALUE) {
            throw new ArithmeticException();
        }
        return -a;
    }

    public static long negateExact(long a) {
        if (a == Long.MIN_VALUE) {
            throw new ArithmeticException();
        }
        return -a;
    }

    public static int toIntExact(long value) {
        if (value > Integer.MAX_VALUE || value < Integer.MIN_VALUE) {
            throw new ArithmeticException();
        }
        return (int)value;
    }

    public static int addExact(int a, int b) {
        int sum = a + b;
        if ((a ^ sum) < 0 && (a ^ b) >= 0) {
            throw new ArithmeticException();
        }
        return sum;
    }

    public static long addExact(long a, long b) {
        long sum = a + b;
        if ((a ^ sum) < 0L && (a ^ b) >= 0L) {
            throw new ArithmeticException();
        }
        return sum;
    }

    public static int subtractExact(int a, int b) {
        int result = a - b;
        if ((a ^ result) < 0 && (a ^ b) < 0) {
            throw new ArithmeticException();
        }
        return result;
    }

    public static long subtractExact(long a, long b) {
        long result = a - b;
        if ((a ^ result) < 0L && (a ^ b) < 0L) {
            throw new ArithmeticException();
        }
        return result;
    }

    public static int multiplyExact(int a, int b) {
        if (b == 1) {
            return a;
        }
        if (a == 1) {
            return b;
        }
        if (a == 0 || b == 0) {
            return 0;
        }
        int total = a * b;
        if (a == Integer.MIN_VALUE && b == -1 || b == Integer.MIN_VALUE && a == -1 || total / b != a) {
            throw new ArithmeticException();
        }
        return total;
    }

    public static long multiplyExact(long a, int b) {
        return TMath.multiplyExact(a, (long)b);
    }

    public static long multiplyExact(long a, long b) {
        if (b == 1L) {
            return a;
        }
        if (a == 1L) {
            return b;
        }
        if (a == 0L || b == 0L) {
            return 0L;
        }
        long total = a * b;
        if (a == Long.MIN_VALUE && b == -1L || b == Long.MIN_VALUE && a == -1L || total / b != a) {
            throw new ArithmeticException();
        }
        return total;
    }

    public static int divideExact(int a, int b) {
        if (a == Integer.MIN_VALUE && b == -1) {
            throw new ArithmeticException();
        }
        return a / b;
    }

    public static long divideExact(long a, long b) {
        if (a == Long.MIN_VALUE && b == -1L) {
            throw new ArithmeticException();
        }
        return a / b;
    }

    @Unmanaged
    public static double random() {
        if (PlatformDetector.isC()) {
            return TMath.randomC();
        }
        if (PlatformDetector.isWebAssembly()) {
            return WasmSupport.random();
        }
        if (PlatformDetector.isWebAssemblyGC()) {
            return TMath.randomWasmGC();
        }
        return TMath.randomImpl();
    }

    @Import(name="teavm_rand")
    private static native double randomC();

    @GeneratedBy(value=MathNativeGenerator.class)
    private static native double randomImpl();

    @Import(module="teavmMath", name="random")
    private static native double randomWasmGC();

    public static int min(int a, int b) {
        return a < b ? a : b;
    }

    public static int max(int a, int b) {
        return a > b ? a : b;
    }

    public static long min(long a, long b) {
        return a < b ? a : b;
    }

    public static long max(long a, long b) {
        return a > b ? a : b;
    }

    @GeneratedBy(value=MathNativeGenerator.class)
    @NoSideEffects
    @Unmanaged
    private static native float minImpl(double var0, double var2);

    @Unmanaged
    public static double min(double a, double b) {
        if (PlatformDetector.isJavaScript()) {
            return TMath.minImpl(a, b);
        }
        if (PlatformDetector.isWebAssembly()) {
            return WasmRuntime.min((double)a, (double)b);
        }
        if (a != a) {
            return a;
        }
        if (a == 0.0 && b == 0.0 && 1.0 / b == Double.NEGATIVE_INFINITY) {
            return b;
        }
        return a <= b ? a : b;
    }

    @GeneratedBy(value=MathNativeGenerator.class)
    @NoSideEffects
    @Unmanaged
    private static native float maxImpl(double var0, double var2);

    @Unmanaged
    public static double max(double a, double b) {
        if (PlatformDetector.isJavaScript()) {
            return TMath.maxImpl(a, b);
        }
        if (PlatformDetector.isWebAssembly()) {
            return WasmRuntime.max((double)a, (double)b);
        }
        if (a != a) {
            return a;
        }
        if (a == 0.0 && b == 0.0 && 1.0 / a == Double.NEGATIVE_INFINITY) {
            return b;
        }
        return a >= b ? a : b;
    }

    @GeneratedBy(value=MathNativeGenerator.class)
    @NoSideEffects
    @Unmanaged
    private static native float minImpl(float var0, float var1);

    @Unmanaged
    public static float min(float a, float b) {
        if (PlatformDetector.isJavaScript()) {
            return TMath.minImpl(a, b);
        }
        if (PlatformDetector.isWebAssembly()) {
            return WasmRuntime.min((float)a, (float)b);
        }
        if (a != a) {
            return a;
        }
        if (a == 0.0f && b == 0.0f && 1.0f / b == Float.NEGATIVE_INFINITY) {
            return b;
        }
        return a <= b ? a : b;
    }

    @GeneratedBy(value=MathNativeGenerator.class)
    @NoSideEffects
    @Unmanaged
    private static native float maxImpl(float var0, float var1);

    @Unmanaged
    public static float max(float a, float b) {
        if (PlatformDetector.isJavaScript()) {
            return TMath.maxImpl(a, b);
        }
        if (PlatformDetector.isWebAssembly()) {
            return WasmRuntime.max((float)a, (float)b);
        }
        if (a != a) {
            return a;
        }
        if (a == 0.0f && b == 0.0f && 1.0f / a == Float.NEGATIVE_INFINITY) {
            return b;
        }
        return a >= b ? a : b;
    }

    public static int abs(int n) {
        return n >= 0 ? n : -n;
    }

    public static int absExact(int n) {
        if (n == Integer.MIN_VALUE) {
            throw new ArithmeticException();
        }
        return TMath.abs(n);
    }

    public static long abs(long n) {
        return n >= 0L ? n : -n;
    }

    public static long absExact(long n) {
        if (n == Long.MIN_VALUE) {
            throw new ArithmeticException();
        }
        return TMath.abs(n);
    }

    @GeneratedBy(value=MathNativeGenerator.class)
    @NoSideEffects
    private static native float absImpl(float var0);

    @Import(name="fabs")
    private static native float absC(float var0);

    public static float abs(float n) {
        if (PlatformDetector.isJavaScript()) {
            return TMath.absImpl(n);
        }
        if (PlatformDetector.isC()) {
            return TMath.absC(n);
        }
        return n <= 0.0f ? 0.0f - n : n;
    }

    @GeneratedBy(value=MathNativeGenerator.class)
    @NoSideEffects
    private static native double absImpl(double var0);

    @Import(name="fabs")
    private static native double absC(double var0);

    public static double abs(double n) {
        if (PlatformDetector.isJavaScript()) {
            return TMath.absImpl(n);
        }
        if (PlatformDetector.isC()) {
            return TMath.absC(n);
        }
        return n <= 0.0 ? 0.0 - n : n;
    }

    public static double ulp(double d) {
        if (TDouble.isNaN(d)) {
            return d;
        }
        if (TDouble.isInfinite(d)) {
            return Double.POSITIVE_INFINITY;
        }
        if (TDouble.isNaN(d)) {
            return d;
        }
        if (TDouble.isInfinite(d)) {
            return Double.POSITIVE_INFINITY;
        }
        long bits = TDouble.doubleToLongBits(d);
        if ((bits &= 0xEFF0000000000000L) >= 0x350000000000000L) {
            bits -= 0x340000000000000L;
        } else {
            int exponent = (int)(bits >> 52);
            bits = 1L << Math.max(0, exponent - 1);
        }
        return TDouble.longBitsToDouble(bits);
    }

    public static float ulp(float d) {
        if (TFloat.isNaN(d)) {
            return d;
        }
        if (TFloat.isInfinite(d)) {
            return Float.POSITIVE_INFINITY;
        }
        int bits = TFloat.floatToIntBits(d);
        if ((bits &= 0x7F800000) >= 0xC000000) {
            bits -= 0xB800000;
        } else {
            int exponent = bits >> 23;
            bits = 1 << Math.max(0, exponent - 1);
        }
        return TFloat.intBitsToFloat(bits);
    }

    @GeneratedBy(value=MathNativeGenerator.class)
    @NoSideEffects
    private static native double sign(double var0);

    public static double signum(double d) {
        if (PlatformDetector.isJavaScript()) {
            return TMath.sign(d);
        }
        if (Double.isNaN(d)) {
            return d;
        }
        return d < 0.0 ? -1.0 : (d > 0.0 ? 1.0 : d);
    }

    @GeneratedBy(value=MathNativeGenerator.class)
    @NoSideEffects
    private static native float sign(float var0);

    public static float signum(float d) {
        if (PlatformDetector.isJavaScript()) {
            return TMath.sign(d);
        }
        if (Double.isNaN(d)) {
            return d;
        }
        return d < 0.0f ? -1.0f : (d > 0.0f ? 1.0f : d);
    }

    public static double sinh(double x) {
        double e = TMath.exp(x);
        return (e - 1.0 / e) / 2.0;
    }

    public static double cosh(double x) {
        double e = TMath.exp(x);
        return (e + 1.0 / e) / 2.0;
    }

    public static double tanh(double x) {
        double e = TMath.exp(x);
        return (e - 1.0 / e) / (e + 1.0 / e);
    }

    public static double hypot(double x, double y) {
        return TMath.sqrt(x * x + y * y);
    }

    public static double expm1(double x) {
        return TMath.exp(x) - 1.0;
    }

    public static double log1p(double x) {
        return TMath.log(x + 1.0);
    }

    public static float copySign(float magnitude, float sign) {
        return Float.intBitsToFloat(Float.floatToRawIntBits(sign) & Integer.MIN_VALUE | Float.floatToRawIntBits(magnitude) & Integer.MAX_VALUE);
    }

    public static double copySign(double magnitude, double sign) {
        return Double.longBitsToDouble(Double.doubleToRawLongBits(sign) & Long.MIN_VALUE | Double.doubleToRawLongBits(magnitude) & Long.MAX_VALUE);
    }

    public static int getExponent(double d) {
        long bits = TDouble.doubleToRawLongBits(d);
        int exponent = (int)(bits >> 52 & 0x7FFL);
        return exponent - 1023;
    }

    public static int getExponent(float f) {
        int bits = TFloat.floatToRawIntBits(f);
        int exponent = bits >> 23 & 0xFF;
        return exponent - 127;
    }

    public static double nextAfter(double start, double direction) {
        if (start == direction) {
            return direction;
        }
        return direction > start ? TMath.nextUp(start) : TMath.nextDown(start);
    }

    public static float nextAfter(float start, double direction) {
        if ((double)start == direction) {
            return start;
        }
        return direction > (double)start ? TMath.nextUp(start) : TMath.nextDown(start);
    }

    public static double nextUp(double d) {
        if (TDouble.isNaN(d) || d == Double.POSITIVE_INFINITY) {
            return d;
        }
        if (d == 0.0) {
            return Double.MIN_VALUE;
        }
        long bits = TDouble.doubleToLongBits(d);
        bits = d < 0.0 ? --bits : ++bits;
        return TDouble.longBitsToDouble(bits);
    }

    public static float nextUp(float d) {
        if (TFloat.isNaN(d) || d == Float.POSITIVE_INFINITY) {
            return d;
        }
        if (d == 0.0f) {
            return Float.MIN_VALUE;
        }
        int bits = TFloat.floatToIntBits(d);
        bits = d < 0.0f ? --bits : ++bits;
        return TFloat.intBitsToFloat(bits);
    }

    public static double nextDown(double d) {
        if (TDouble.isNaN(d) || d == Double.NEGATIVE_INFINITY) {
            return d;
        }
        if (d == 0.0) {
            return -4.9E-324;
        }
        long bits = TDouble.doubleToLongBits(d);
        bits = d < 0.0 ? ++bits : --bits;
        return TDouble.longBitsToDouble(bits);
    }

    public static float nextDown(float d) {
        if (TFloat.isNaN(d) || d == Float.NEGATIVE_INFINITY) {
            return d;
        }
        if (d == 0.0f) {
            return -1.4E-45f;
        }
        int bits = TFloat.floatToIntBits(d);
        bits = d < 0.0f ? ++bits : --bits;
        return TFloat.intBitsToFloat(bits);
    }

    public static int clamp(long value, int min, int max) {
        if (min > max) {
            throw new IllegalArgumentException();
        }
        return (int)Math.min((long)max, Math.max(value, (long)min));
    }

    public static long clamp(long value, long min, long max) {
        if (min > max) {
            throw new IllegalArgumentException();
        }
        return Math.min(max, Math.max(value, min));
    }

    public static double clamp(double value, double min, double max) {
        if (!(min < max) && (Double.isNaN(min) || Double.isNaN(max) || Double.compare(min, max) > 0)) {
            throw new IllegalArgumentException();
        }
        return Math.min(max, Math.max(value, min));
    }

    public static float clamp(float value, float min, float max) {
        if (!(min < max) && (Float.isNaN(min) || Float.isNaN(max) || Float.compare(min, max) > 0)) {
            throw new IllegalArgumentException();
        }
        return Math.min(max, Math.max(value, min));
    }
}

