/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.lang;

import org.teavm.classlib.impl.unicode.UnicodeHelper;
import org.teavm.classlib.impl.unicode.UnicodeSupport;
import org.teavm.model.MethodReference;
import org.teavm.platform.metadata.MetadataGenerator;
import org.teavm.platform.metadata.MetadataGeneratorContext;
import org.teavm.platform.metadata.builders.ResourceBuilder;
import org.teavm.platform.metadata.builders.StringResourceBuilder;

public class CharacterMetadataGenerator
implements MetadataGenerator {
    public ResourceBuilder generateMetadata(MetadataGeneratorContext context, MethodReference method) {
        switch (method.getName()) {
            case "obtainDigitMapping": {
                return this.generateObtainDigitMapping(context);
            }
            case "obtainClasses": {
                return this.generateObtainClasses(context);
            }
            case "acquireTitleCaseMapping": {
                return this.generateAcquireTitleCaseMapping(context);
            }
            case "acquireUpperCaseMapping": {
                return this.generateAcquireUpperCaseMapping(context);
            }
            case "acquireLowerCaseMapping": {
                return this.generateAcquireLowerCaseMapping(context);
            }
        }
        return null;
    }

    private ResourceBuilder generateObtainDigitMapping(MetadataGeneratorContext context) {
        StringResourceBuilder res = new StringResourceBuilder();
        res.value = UnicodeHelper.encodeIntPairsDiff(UnicodeSupport.getDigitValues(context.getResourceProvider()));
        return res;
    }

    private ResourceBuilder generateObtainClasses(MetadataGeneratorContext context) {
        StringResourceBuilder res = new StringResourceBuilder();
        res.value = UnicodeHelper.compressRle(UnicodeSupport.getClasses(context.getResourceProvider()));
        return res;
    }

    private ResourceBuilder generateAcquireTitleCaseMapping(MetadataGeneratorContext context) {
        StringResourceBuilder res = new StringResourceBuilder();
        res.value = UnicodeHelper.encodeCaseMapping(UnicodeSupport.getTitleCaseMapping(context.getResourceProvider()));
        return res;
    }

    private ResourceBuilder generateAcquireUpperCaseMapping(MetadataGeneratorContext context) {
        StringResourceBuilder res = new StringResourceBuilder();
        res.value = UnicodeHelper.encodeCaseMapping(UnicodeSupport.getUpperCaseMapping(context.getResourceProvider()));
        return res;
    }

    private ResourceBuilder generateAcquireLowerCaseMapping(MetadataGeneratorContext context) {
        StringResourceBuilder res = new StringResourceBuilder();
        res.value = UnicodeHelper.encodeCaseMapping(UnicodeSupport.getLowerCaseMapping(context.getResourceProvider()));
        return res;
    }
}

