/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.io;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import org.teavm.classlib.java.io.TFile;
import org.teavm.runtime.fs.VirtualFile;
import org.teavm.runtime.fs.VirtualFileAccessor;

public class TFileInputStream
extends InputStream {
    private static final byte[] ONE_BYTE_BUFFER = new byte[1];
    private VirtualFileAccessor accessor;

    public TFileInputStream(TFile file) throws FileNotFoundException {
        VirtualFile virtualFile = file.findVirtualFile();
        if (virtualFile == null || !virtualFile.isFile()) {
            throw new FileNotFoundException();
        }
        this.accessor = virtualFile.createAccessor(true, false, false);
        if (this.accessor == null) {
            throw new FileNotFoundException();
        }
    }

    public TFileInputStream(String path) throws FileNotFoundException {
        this(new TFile(path));
    }

    public TFileInputStream(VirtualFileAccessor accessor) {
        this.accessor = accessor;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        Objects.requireNonNull(b);
        if (off < 0 || len < 0 || off > b.length - len) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        this.ensureOpened();
        int result = this.accessor.read(b, off, len);
        return result > 0 ? result : -1;
    }

    @Override
    public long skip(long n) throws IOException {
        if (n < 0L) {
            throw new IOException("Value must be positive: " + n);
        }
        this.ensureOpened();
        int last = this.accessor.tell();
        this.accessor.skip((int)n - 1);
        if (this.accessor.read(ONE_BYTE_BUFFER, 0, 1) < 1) {
            int position = this.accessor.size();
            this.accessor.seek(position);
            return position - last;
        }
        return n;
    }

    @Override
    public int available() throws IOException {
        this.ensureOpened();
        return Math.max(0, this.accessor.size() - this.accessor.tell());
    }

    @Override
    public void close() throws IOException {
        if (this.accessor != null) {
            this.accessor.close();
        }
        this.accessor = null;
    }

    @Override
    public int read() throws IOException {
        this.ensureOpened();
        byte[] buffer = ONE_BYTE_BUFFER;
        int read = this.accessor.read(buffer, 0, 1);
        return read != 0 ? buffer[0] : -1;
    }

    private void ensureOpened() throws IOException {
        if (this.accessor == null) {
            throw new IOException("This stream is already closed");
        }
    }
}

