/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.impl.unicode;

import java.util.Map;
import org.teavm.classlib.impl.unicode.CLDRDateFormats;
import org.teavm.classlib.impl.unicode.CLDRLocale;
import org.teavm.classlib.impl.unicode.CLDRReader;
import org.teavm.classlib.impl.unicode.DateFormatCollectionBuilder;
import org.teavm.model.MethodReference;
import org.teavm.platform.metadata.MetadataGenerator;
import org.teavm.platform.metadata.MetadataGeneratorContext;
import org.teavm.platform.metadata.builders.ResourceBuilder;
import org.teavm.platform.metadata.builders.ResourceMapBuilder;

public class DateFormatMetadataGenerator
implements MetadataGenerator {
    public ResourceBuilder generateMetadata(MetadataGeneratorContext context, MethodReference method) {
        switch (method.getName()) {
            case "getDateFormatMap": {
                return this.getDateFormatMap(context, locale -> locale.getDateFormats());
            }
            case "getTimeFormatMap": {
                return this.getDateFormatMap(context, locale -> locale.getTimeFormats());
            }
            case "getDateTimeFormatMap": {
                return this.getDateFormatMap(context, locale -> locale.getDateTimeFormats());
            }
        }
        throw new IllegalArgumentException("Method is not supported: " + String.valueOf(method));
    }

    private ResourceBuilder getDateFormatMap(MetadataGeneratorContext context, FormatExtractor extractor) {
        CLDRReader reader = (CLDRReader)context.getService(CLDRReader.class);
        ResourceMapBuilder result = new ResourceMapBuilder();
        for (Map.Entry<String, CLDRLocale> entry : reader.getKnownLocales().entrySet()) {
            DateFormatCollectionBuilder formatRes = new DateFormatCollectionBuilder();
            CLDRDateFormats formats = extractor.extract(entry.getValue());
            formatRes.shortFormat = formats.getShortFormat();
            formatRes.mediumFormat = formats.getMediumFormat();
            formatRes.longFormat = formats.getLongFormat();
            formatRes.fullFormat = formats.getFullFormat();
            result.values.put(entry.getKey(), formatRes);
        }
        return result;
    }

    static interface FormatExtractor {
        public CLDRDateFormats extract(CLDRLocale var1);
    }
}

