/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.impl;

import java.util.Collection;
import java.util.ServiceLoader;
import org.teavm.ast.Expr;
import org.teavm.ast.InvocationExpr;
import org.teavm.backend.wasm.binary.BinaryWriter;
import org.teavm.backend.wasm.binary.DataPrimitives;
import org.teavm.backend.wasm.binary.DataStructure;
import org.teavm.backend.wasm.binary.DataType;
import org.teavm.backend.wasm.binary.DataValue;
import org.teavm.backend.wasm.intrinsics.WasmIntrinsic;
import org.teavm.backend.wasm.intrinsics.WasmIntrinsicFactory;
import org.teavm.backend.wasm.intrinsics.WasmIntrinsicFactoryContext;
import org.teavm.backend.wasm.intrinsics.WasmIntrinsicManager;
import org.teavm.backend.wasm.model.WasmFunction;
import org.teavm.backend.wasm.model.expression.WasmCall;
import org.teavm.backend.wasm.model.expression.WasmExpression;
import org.teavm.backend.wasm.model.expression.WasmInt32Constant;
import org.teavm.classlib.impl.ServiceLoadWasmRuntime;
import org.teavm.classlib.impl.ServiceLoaderInformation;
import org.teavm.dependency.DependencyAnalyzer;
import org.teavm.interop.Address;
import org.teavm.model.MethodReference;
import org.teavm.model.ValueType;
import org.teavm.runtime.RuntimeClass;
import org.teavm.runtime.RuntimeObject;

public class ServiceLoaderWasmSupport
implements WasmIntrinsicFactory {
    private static final DataStructure ENTRY = new DataStructure(4, new DataType[]{DataPrimitives.ADDRESS, DataPrimitives.INT});
    private static final MethodReference CREATE_SERVICES_METHOD = new MethodReference(ServiceLoadWasmRuntime.class, "createServices", new Class[]{Address.class, RuntimeClass.class, RuntimeObject.class});

    public WasmIntrinsic create(WasmIntrinsicFactoryContext context) {
        return new ServiceLoaderIntrinsic((ServiceLoaderInformation)context.getServices().getService(ServiceLoaderInformation.class));
    }

    public void contributeDependencies(DependencyAnalyzer analyzer) {
        analyzer.linkMethod(CREATE_SERVICES_METHOD).use();
    }

    private static class ServiceLoaderIntrinsic
    implements WasmIntrinsic {
        private ServiceLoaderInformation information;

        ServiceLoaderIntrinsic(ServiceLoaderInformation information) {
            this.information = information;
        }

        public boolean isApplicable(MethodReference methodReference) {
            return methodReference.getClassName().equals(ServiceLoader.class.getName()) && methodReference.getName().equals("loadServices");
        }

        public WasmExpression apply(InvocationExpr invocation, WasmIntrinsicManager manager) {
            int table = this.createServiceData(manager);
            WasmInt32Constant tableArg = new WasmInt32Constant(table);
            WasmExpression serviceClassAddress = manager.generate((Expr)invocation.getArguments().get(0));
            return new WasmCall(manager.getFunctions().forStaticMethod(CREATE_SERVICES_METHOD), new WasmExpression[]{tableArg, serviceClassAddress});
        }

        private int createServiceData(WasmIntrinsicManager manager) {
            BinaryWriter writer = manager.getBinaryWriter();
            return writer.writeMap((Object[])this.information.serviceTypes().toArray(new String[0]), cls -> manager.getClassPointer((ValueType)ValueType.object((String)cls)), cls -> manager.getClassPointer((ValueType)ValueType.object((String)cls)), cls -> {
                Collection<? extends String> implementations = this.information.serviceImplementations((String)cls);
                int result = writer.getAddress();
                DataValue count = DataPrimitives.INT.createValue();
                writer.append(count);
                count.setInt(0, implementations.size());
                for (String string : implementations) {
                    DataValue entry = ENTRY.createValue();
                    writer.append(entry);
                    int implPointer = manager.getClassPointer((ValueType)ValueType.object((String)string));
                    entry.setAddress(0, (long)implPointer);
                    WasmFunction constructorFn = manager.getFunctions().forInstanceMethod(new MethodReference(string, "<init>", new ValueType[]{ValueType.VOID}));
                    entry.setInt(1, manager.getFunctionPointer(constructorFn));
                }
                return result;
            });
        }
    }
}

