/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.ServiceLoader;
import org.teavm.backend.wasm.generate.gc.classes.WasmGCClassInfo;
import org.teavm.backend.wasm.generate.gc.methods.WasmGCGenerationUtil;
import org.teavm.backend.wasm.generators.gc.WasmGCCustomGenerator;
import org.teavm.backend.wasm.generators.gc.WasmGCCustomGeneratorContext;
import org.teavm.backend.wasm.generators.gc.WasmGCCustomGeneratorFactory;
import org.teavm.backend.wasm.generators.gc.WasmGCCustomGeneratorFactoryContext;
import org.teavm.backend.wasm.model.WasmBlockType;
import org.teavm.backend.wasm.model.WasmEntity;
import org.teavm.backend.wasm.model.WasmFunction;
import org.teavm.backend.wasm.model.WasmFunctionType;
import org.teavm.backend.wasm.model.WasmGlobal;
import org.teavm.backend.wasm.model.WasmLocal;
import org.teavm.backend.wasm.model.WasmStructure;
import org.teavm.backend.wasm.model.WasmType;
import org.teavm.backend.wasm.model.expression.WasmBlock;
import org.teavm.backend.wasm.model.expression.WasmCall;
import org.teavm.backend.wasm.model.expression.WasmCallReference;
import org.teavm.backend.wasm.model.expression.WasmExpression;
import org.teavm.backend.wasm.model.expression.WasmFunctionReference;
import org.teavm.backend.wasm.model.expression.WasmGetGlobal;
import org.teavm.backend.wasm.model.expression.WasmGetLocal;
import org.teavm.backend.wasm.model.expression.WasmNullBranch;
import org.teavm.backend.wasm.model.expression.WasmNullCondition;
import org.teavm.backend.wasm.model.expression.WasmNullConstant;
import org.teavm.backend.wasm.model.expression.WasmReturn;
import org.teavm.backend.wasm.model.expression.WasmSetGlobal;
import org.teavm.backend.wasm.model.expression.WasmSetLocal;
import org.teavm.backend.wasm.model.expression.WasmStructGet;
import org.teavm.backend.wasm.model.expression.WasmStructNewDefault;
import org.teavm.backend.wasm.model.expression.WasmStructSet;
import org.teavm.classlib.impl.ServiceLoaderInformation;
import org.teavm.model.MethodDescriptor;
import org.teavm.model.MethodReference;
import org.teavm.model.ValueType;

public class ServiceLoaderWasmGCSupport
implements WasmGCCustomGeneratorFactory {
    static final MethodDescriptor INIT_METHOD = new MethodDescriptor("<init>", new ValueType[]{ValueType.VOID});

    public WasmGCCustomGenerator createGenerator(MethodReference methodRef, WasmGCCustomGeneratorFactoryContext context) {
        if (methodRef.getClassName().equals(ServiceLoader.class.getName()) && methodRef.getName().equals("loadServices")) {
            return new ServiceLoaderIntrinsic((ServiceLoaderInformation)context.services().getService(ServiceLoaderInformation.class));
        }
        return null;
    }

    static class ServiceLoaderIntrinsic
    implements WasmGCCustomGenerator {
        private ServiceLoaderInformation information;

        ServiceLoaderIntrinsic(ServiceLoaderInformation information) {
            this.information = information;
        }

        public void apply(MethodReference method, WasmFunction function, WasmGCCustomGeneratorContext context) {
            WasmFunction initializer = this.generateInitializer(context);
            WasmFunction emptyInitializer = this.generateEmptyInitializer(context);
            WasmType.Reference arrayType = (WasmType.Reference)context.typeMapper().mapType(ValueType.parse(Object[].class));
            WasmFunctionType servicesFunctionType = context.functionTypes().of((WasmType)arrayType, new WasmType[0]);
            WasmLocal classLocal = new WasmLocal(context.typeMapper().mapType(ValueType.parse(Class.class)));
            function.add(classLocal);
            WasmStructure classStruct = context.classInfoProvider().getClassInfo("java.lang.Class").getStructure();
            String initializerGlobalName = context.names().topLevel("teavm@initializeServicesRef");
            WasmGlobal global = new WasmGlobal(initializerGlobalName, (WasmType)initializer.getType().getReference(), (WasmExpression)new WasmFunctionReference(initializer));
            context.module().globals.add((WasmEntity)global);
            initializer.getBody().add(0, new WasmSetGlobal(global, (WasmExpression)new WasmFunctionReference(emptyInitializer)));
            function.getBody().add(new WasmCallReference((WasmExpression)new WasmGetGlobal(global), initializer.getType()));
            WasmBlock block = new WasmBlock(false);
            WasmStructGet servicesFunctionRef = new WasmStructGet(classStruct, (WasmExpression)new WasmGetLocal(classLocal), context.classInfoProvider().getServicesOffset());
            WasmNullBranch nullCheckedRef = new WasmNullBranch(WasmNullCondition.NULL, (WasmExpression)servicesFunctionRef, block);
            WasmCallReference getServices = new WasmCallReference((WasmExpression)nullCheckedRef, servicesFunctionType);
            block.getBody().add(new WasmReturn((WasmExpression)getServices));
            function.getBody().add(block);
            function.getBody().add(new WasmNullConstant(arrayType));
        }

        private WasmFunction generateInitializer(WasmGCCustomGeneratorContext context) {
            WasmFunction function = new WasmFunction(context.functionTypes().of(null, new WasmType[0]));
            function.setReferenced(true);
            function.setName(context.names().topLevel("teavm@initializeServices"));
            context.module().functions.add((WasmEntity)function);
            Collection<? extends String> serviceTypes = this.information.serviceTypes();
            WasmStructure classStruct = context.classInfoProvider().getClassInfo("java.lang.Class").getStructure();
            int fieldIndex = context.classInfoProvider().getServicesOffset();
            for (String string : serviceTypes) {
                Collection<? extends String> implementations = this.information.serviceImplementations(string);
                WasmFunction providerFunction = this.generateServiceProvider(context, string, implementations);
                WasmGCClassInfo classInfo = context.classInfoProvider().getClassInfo(string);
                WasmGetGlobal classRef = new WasmGetGlobal(classInfo.getPointer());
                WasmFunctionReference providerRef = new WasmFunctionReference(providerFunction);
                function.getBody().add(new WasmStructSet(classStruct, (WasmExpression)classRef, fieldIndex, (WasmExpression)providerRef));
            }
            return function;
        }

        private WasmFunction generateServiceProvider(WasmGCCustomGeneratorContext context, String interfaceName, Collection<? extends String> implementations) {
            WasmFunctionType functionType = context.functionTypes().of(context.typeMapper().mapType(ValueType.parse(Object[].class)), new WasmType[0]);
            WasmFunction function = new WasmFunction(functionType);
            function.setName(context.names().topLevel(context.names().suggestForClass(interfaceName) + "@services"));
            function.setReferenced(true);
            context.module().functions.add((WasmEntity)function);
            WasmGCGenerationUtil util = new WasmGCGenerationUtil(context.classInfoProvider());
            function.getBody().add(util.allocateArrayWithElements(ValueType.parse(Object.class), () -> {
                ArrayList<WasmExpression> items = new ArrayList<WasmExpression>();
                for (String implementationName : implementations) {
                    items.add(this.instantiateService(context, function, implementationName));
                }
                return items;
            }));
            return function;
        }

        private WasmExpression instantiateService(WasmGCCustomGeneratorContext context, WasmFunction function, String implementationName) {
            WasmGCClassInfo implementationInfo = context.classInfoProvider().getClassInfo(implementationName);
            WasmBlock block = new WasmBlock(false);
            block.setType((WasmBlockType)context.typeMapper().mapType(ValueType.parse(Object.class)).asBlock());
            WasmLocal tmpVar = new WasmLocal((WasmType)implementationInfo.getType());
            function.add(tmpVar);
            WasmSetLocal structNew = new WasmSetLocal(tmpVar, (WasmExpression)new WasmStructNewDefault(implementationInfo.getStructure()));
            block.getBody().add(structNew);
            WasmStructSet initClassField = new WasmStructSet(implementationInfo.getStructure(), (WasmExpression)new WasmGetLocal(tmpVar), 0, (WasmExpression)new WasmGetGlobal(implementationInfo.getVirtualTablePointer()));
            block.getBody().add(initClassField);
            WasmFunction constructor = context.functions().forInstanceMethod(new MethodReference(implementationName, INIT_METHOD));
            block.getBody().add(new WasmCall(constructor, new WasmExpression[]{new WasmGetLocal(tmpVar)}));
            block.getBody().add(new WasmGetLocal(tmpVar));
            return block;
        }

        private WasmFunction generateEmptyInitializer(WasmGCCustomGeneratorContext context) {
            WasmFunction function = new WasmFunction(context.functionTypes().of(null, new WasmType[0]));
            function.setReferenced(true);
            function.setName(context.names().topLevel("teavm@emptyServicesInitializer"));
            context.module().functions.add((WasmEntity)function);
            return function;
        }
    }
}

