/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.util.zip;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.teavm.classlib.java.util.zip.TCRC32;
import org.teavm.classlib.java.util.zip.TDeflater;
import org.teavm.classlib.java.util.zip.TDeflaterOutputStream;
import org.teavm.classlib.java.util.zip.TZipConstants;
import org.teavm.classlib.java.util.zip.TZipEntry;
import org.teavm.classlib.java.util.zip.TZipException;

public class TZipOutputStream
extends TDeflaterOutputStream
implements TZipConstants {
    public static final int DEFLATED = 8;
    public static final int STORED = 0;
    static final int ZIPDataDescriptorFlag = 8;
    static final int ZIPLocalHeaderVersionNeeded = 20;
    private String comment;
    private final List<String> entries = new ArrayList<String>();
    private int compressMethod = 8;
    private int compressLevel = -1;
    private ByteArrayOutputStream cDir = new ByteArrayOutputStream();
    private TZipEntry currentEntry;
    private final TCRC32 crc = new TCRC32();
    private int offset;
    private int curOffset;
    private int nameLength;
    private byte[] nameBytes;

    public TZipOutputStream(OutputStream p1) {
        super(p1, new TDeflater(-1, true));
    }

    @Override
    public void close() throws IOException {
        if (this.out != null) {
            this.finish();
            this.out.close();
            this.out = null;
        }
    }

    public void closeEntry() throws IOException {
        if (this.cDir == null) {
            throw new IOException();
        }
        if (this.currentEntry == null) {
            return;
        }
        if (this.currentEntry.getMethod() == 8) {
            super.finish();
        }
        if (this.currentEntry.getMethod() == 0) {
            if (this.crc.getValue() != this.currentEntry.crc) {
                throw new TZipException();
            }
            if (this.currentEntry.size != this.crc.tbytes) {
                throw new TZipException();
            }
        }
        this.curOffset = 30;
        if (this.currentEntry.getMethod() != 0) {
            this.curOffset += 16;
            this.writeLong(this.out, 134695760L);
            this.currentEntry.crc = this.crc.getValue();
            this.writeLong(this.out, this.currentEntry.crc);
            this.currentEntry.compressedSize = this.def.getTotalOut();
            this.writeLong(this.out, this.currentEntry.compressedSize);
            this.currentEntry.size = this.def.getTotalIn();
            this.writeLong(this.out, this.currentEntry.size);
        }
        this.writeLong(this.cDir, 33639248L);
        this.writeShort(this.cDir, 20);
        this.writeShort(this.cDir, 20);
        this.writeShort(this.cDir, this.currentEntry.getMethod() == 0 ? 0 : 8);
        this.writeShort(this.cDir, this.currentEntry.getMethod());
        this.writeShort(this.cDir, this.currentEntry.time);
        this.writeShort(this.cDir, this.currentEntry.modDate);
        this.writeLong(this.cDir, this.crc.getValue());
        if (this.currentEntry.getMethod() == 8) {
            this.curOffset = (int)((long)this.curOffset + this.writeLong(this.cDir, this.def.getTotalOut()));
            this.writeLong(this.cDir, this.def.getTotalIn());
        } else {
            this.curOffset = (int)((long)this.curOffset + this.writeLong(this.cDir, this.crc.tbytes));
            this.writeLong(this.cDir, this.crc.tbytes);
        }
        this.curOffset += this.writeShort(this.cDir, this.nameLength);
        if (this.currentEntry.extra != null) {
            this.curOffset += this.writeShort(this.cDir, this.currentEntry.extra.length);
        } else {
            this.writeShort(this.cDir, 0);
        }
        String c = this.currentEntry.getComment();
        this.writeShort(this.cDir, c != null ? c.length() : 0);
        this.writeShort(this.cDir, 0);
        this.writeShort(this.cDir, 0);
        this.writeLong(this.cDir, 0L);
        this.writeLong(this.cDir, this.offset);
        this.cDir.write(this.nameBytes);
        this.nameBytes = null;
        if (this.currentEntry.extra != null) {
            this.cDir.write(this.currentEntry.extra);
        }
        this.offset += this.curOffset;
        if (c != null) {
            this.cDir.write(c.getBytes());
        }
        this.currentEntry = null;
        this.crc.reset();
        this.def.reset();
        this.done = false;
    }

    @Override
    public void finish() throws IOException {
        if (this.out == null) {
            throw new IOException();
        }
        if (this.cDir == null) {
            return;
        }
        if (this.entries.size() == 0) {
            throw new TZipException();
        }
        if (this.currentEntry != null) {
            this.closeEntry();
        }
        int cdirSize = this.cDir.size();
        this.writeLong(this.cDir, 101010256L);
        this.writeShort(this.cDir, 0);
        this.writeShort(this.cDir, 0);
        this.writeShort(this.cDir, this.entries.size());
        this.writeShort(this.cDir, this.entries.size());
        this.writeLong(this.cDir, cdirSize);
        this.writeLong(this.cDir, this.offset);
        if (this.comment != null) {
            this.writeShort(this.cDir, this.comment.length());
            this.cDir.write(this.comment.getBytes());
        } else {
            this.writeShort(this.cDir, 0);
        }
        this.out.write(this.cDir.toByteArray());
        this.cDir = null;
    }

    public void putNextEntry(TZipEntry ze) throws IOException {
        if (this.currentEntry != null) {
            this.closeEntry();
        }
        if (ze.getMethod() == 0 || this.compressMethod == 0 && ze.getMethod() == -1) {
            if (ze.crc == -1L) {
                throw new TZipException("Crc mismatch");
            }
            if (ze.size == -1L && ze.compressedSize == -1L) {
                throw new TZipException("Size mismatch");
            }
            if (ze.size != ze.compressedSize && ze.compressedSize != -1L && ze.size != -1L) {
                throw new TZipException("Size mismatch");
            }
        }
        if (this.cDir == null) {
            throw new IOException("Stream is closed");
        }
        if (this.entries.contains(ze.name)) {
            throw new TZipException("Entry already exists: " + ze.name);
        }
        this.nameLength = TZipOutputStream.utf8Count(ze.name);
        if (this.nameLength > 65535) {
            throw new IllegalArgumentException("Name too long: " + ze.name);
        }
        this.def.setLevel(this.compressLevel);
        this.currentEntry = ze;
        this.entries.add(this.currentEntry.name);
        if (this.currentEntry.getMethod() == -1) {
            this.currentEntry.setMethod(this.compressMethod);
        }
        this.writeLong(this.out, 67324752L);
        this.writeShort(this.out, 20);
        this.writeShort(this.out, this.currentEntry.getMethod() == 0 ? 0 : 8);
        this.writeShort(this.out, this.currentEntry.getMethod());
        if (this.currentEntry.getTime() == -1L) {
            this.currentEntry.setTime(System.currentTimeMillis());
        }
        this.writeShort(this.out, this.currentEntry.time);
        this.writeShort(this.out, this.currentEntry.modDate);
        if (this.currentEntry.getMethod() == 0) {
            if (this.currentEntry.size == -1L) {
                this.currentEntry.size = this.currentEntry.compressedSize;
            } else if (this.currentEntry.compressedSize == -1L) {
                this.currentEntry.compressedSize = this.currentEntry.size;
            }
            this.writeLong(this.out, this.currentEntry.crc);
            this.writeLong(this.out, this.currentEntry.size);
            this.writeLong(this.out, this.currentEntry.size);
        } else {
            this.writeLong(this.out, 0L);
            this.writeLong(this.out, 0L);
            this.writeLong(this.out, 0L);
        }
        this.writeShort(this.out, this.nameLength);
        this.writeShort(this.out, this.currentEntry.extra != null ? this.currentEntry.extra.length : 0);
        this.nameBytes = TZipOutputStream.toUTF8Bytes(this.currentEntry.name, this.nameLength);
        this.out.write(this.nameBytes);
        if (this.currentEntry.extra != null) {
            this.out.write(this.currentEntry.extra);
        }
    }

    public void setComment(String comment) {
        if (comment.length() > 65535) {
            throw new IllegalArgumentException();
        }
        this.comment = comment;
    }

    public void setLevel(int level) {
        if (level < -1 || level > 9) {
            throw new IllegalArgumentException();
        }
        this.compressLevel = level;
    }

    public void setMethod(int method) {
        if (method != 0 && method != 8) {
            throw new IllegalArgumentException();
        }
        this.compressMethod = method;
    }

    private long writeLong(OutputStream os, long i) throws IOException {
        os.write((int)(i & 0xFFL));
        os.write((int)(i >> 8) & 0xFF);
        os.write((int)(i >> 16) & 0xFF);
        os.write((int)(i >> 24) & 0xFF);
        return i;
    }

    private int writeShort(OutputStream os, int i) throws IOException {
        os.write(i & 0xFF);
        os.write(i >> 8 & 0xFF);
        return i;
    }

    @Override
    public void write(byte[] buffer, int off, int nbytes) throws IOException {
        if (off < 0 || nbytes < 0 || off > buffer.length || buffer.length - off < nbytes) {
            throw new IndexOutOfBoundsException();
        }
        if (this.currentEntry == null) {
            throw new TZipException("No active entry");
        }
        if (this.currentEntry.getMethod() == 0) {
            this.out.write(buffer, off, nbytes);
        } else {
            super.write(buffer, off, nbytes);
        }
        this.crc.update(buffer, off, nbytes);
    }

    static int utf8Count(String value) {
        int total = 0;
        int i = value.length();
        while (--i >= 0) {
            char ch = value.charAt(i);
            if (ch < '\u0080') {
                ++total;
                continue;
            }
            if (ch < '\u0800') {
                total += 2;
                continue;
            }
            total += 3;
        }
        return total;
    }

    static byte[] toUTF8Bytes(String value, int length) {
        byte[] result = new byte[length];
        int pos = result.length;
        int i = value.length();
        while (--i >= 0) {
            char ch = value.charAt(i);
            if (ch < '\u0080') {
                result[--pos] = (byte)ch;
                continue;
            }
            if (ch < '\u0800') {
                result[--pos] = (byte)(0x80 | ch & 0x3F);
                result[--pos] = (byte)(0xC0 | ch >> 6);
                continue;
            }
            result[--pos] = (byte)(0x80 | ch & 0x3F);
            result[--pos] = (byte)(0x80 | ch >> 6 & 0x3F);
            result[--pos] = (byte)(0xE0 | ch >> 12);
        }
        return result;
    }
}

