/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.util;

import java.util.function.Consumer;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import org.teavm.classlib.java.util.TAbstractSequentialList;
import org.teavm.classlib.java.util.TCollection;
import org.teavm.classlib.java.util.TComparator;
import org.teavm.classlib.java.util.TConcurrentModificationException;
import org.teavm.classlib.java.util.TDeque;
import org.teavm.classlib.java.util.TIterator;
import org.teavm.classlib.java.util.TList;
import org.teavm.classlib.java.util.TListIterator;
import org.teavm.classlib.java.util.TNoSuchElementException;
import org.teavm.classlib.java.util.TObjects;
import org.teavm.classlib.java.util.TReversedList;
import org.teavm.classlib.java.util.TSpliterator;
import org.teavm.classlib.java.util.function.TUnaryOperator;
import org.teavm.classlib.java.util.stream.TStream;

public class TLinkedList<E>
extends TAbstractSequentialList<E>
implements TDeque<E> {
    private Entry<E> firstEntry;
    private Entry<E> lastEntry;
    private int size;

    public TLinkedList() {
    }

    public TLinkedList(TCollection<E> coll) {
        TIterator iter = coll.iterator();
        Entry prevEntry = null;
        while (iter.hasNext()) {
            Entry entry = new Entry();
            entry.item = iter.next();
            entry.previous = prevEntry;
            if (prevEntry == null) {
                this.firstEntry = entry;
            } else {
                prevEntry.next = entry;
            }
            prevEntry = entry;
            ++this.size;
        }
        this.lastEntry = prevEntry;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public void clear() {
        this.firstEntry = null;
        this.lastEntry = null;
        this.size = 0;
        ++this.modCount;
    }

    @Override
    public TListIterator<E> listIterator() {
        return new SequentialListIterator(this.firstEntry, null, 0);
    }

    @Override
    public TListIterator<E> listIterator(int index) {
        if (index < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (index <= this.size / 2) {
            Entry<E> next = this.firstEntry;
            for (int i = 0; i < index; ++i) {
                next = next.next;
            }
            return new SequentialListIterator(next, next != null ? next.previous : null, index);
        }
        if (index > this.size) {
            throw new IndexOutOfBoundsException();
        }
        Entry<E> prev = this.lastEntry;
        for (int i = index; i < this.size; ++i) {
            prev = prev.previous;
        }
        return new SequentialListIterator(prev != null ? prev.next : null, prev, index);
    }

    @Override
    public boolean offer(E e) {
        this.addLast(e);
        return true;
    }

    @Override
    public E remove() {
        if (this.isEmpty()) {
            throw new TNoSuchElementException();
        }
        return this.poll();
    }

    @Override
    public E poll() {
        if (this.firstEntry == null) {
            return null;
        }
        Entry<E> entry = this.firstEntry;
        this.firstEntry = this.firstEntry.next;
        if (this.firstEntry == null) {
            this.lastEntry = null;
        } else {
            this.firstEntry.previous = null;
        }
        --this.size;
        ++this.modCount;
        return entry.item;
    }

    @Override
    public E element() {
        if (this.firstEntry == null) {
            throw new TNoSuchElementException();
        }
        return this.firstEntry.item;
    }

    @Override
    public E peek() {
        return this.firstEntry != null ? (E)this.firstEntry.item : null;
    }

    @Override
    public void addFirst(E e) {
        Entry entry = new Entry();
        entry.item = e;
        entry.next = this.firstEntry;
        if (this.firstEntry != null) {
            this.firstEntry.previous = entry;
        } else {
            this.lastEntry = entry;
        }
        this.firstEntry = entry;
        ++this.modCount;
        ++this.size;
    }

    @Override
    public void addLast(E e) {
        Entry entry = new Entry();
        entry.item = e;
        entry.previous = this.lastEntry;
        if (this.lastEntry != null) {
            this.lastEntry.next = entry;
        } else {
            this.firstEntry = entry;
        }
        this.lastEntry = entry;
        ++this.modCount;
        ++this.size;
    }

    @Override
    public boolean offerFirst(E e) {
        this.addFirst(e);
        return true;
    }

    @Override
    public boolean offerLast(E e) {
        this.addLast(e);
        return true;
    }

    @Override
    public E removeFirst() {
        return this.remove();
    }

    @Override
    public E removeLast() {
        if (this.isEmpty()) {
            throw new TNoSuchElementException();
        }
        return this.pollLast();
    }

    @Override
    public E pollFirst() {
        return this.poll();
    }

    @Override
    public E pollLast() {
        if (this.lastEntry == null) {
            return null;
        }
        Entry<E> entry = this.lastEntry;
        this.lastEntry = this.lastEntry.previous;
        if (this.lastEntry == null) {
            this.firstEntry = null;
        } else {
            this.lastEntry.next = null;
        }
        --this.size;
        ++this.modCount;
        return entry.item;
    }

    @Override
    public E getFirst() {
        if (this.firstEntry == null) {
            throw new TNoSuchElementException();
        }
        return this.firstEntry.item;
    }

    @Override
    public E getLast() {
        if (this.lastEntry == null) {
            throw new TNoSuchElementException();
        }
        return this.lastEntry.item;
    }

    @Override
    public E peekFirst() {
        return this.firstEntry != null ? (E)this.firstEntry.item : null;
    }

    @Override
    public E peekLast() {
        return this.lastEntry != null ? (E)this.lastEntry.item : null;
    }

    @Override
    public boolean removeFirstOccurrence(Object o) {
        Entry<E> entry = this.firstEntry;
        while (entry != null) {
            if (TObjects.equals(o, entry.item)) {
                this.removeEntry(entry);
                return true;
            }
            entry = entry.next;
        }
        return false;
    }

    @Override
    public boolean removeLastOccurrence(Object o) {
        Entry<E> entry = this.lastEntry;
        while (entry != null) {
            if (TObjects.equals(o, entry.item)) {
                this.removeEntry(entry);
                return true;
            }
            entry = entry.previous;
        }
        return false;
    }

    @Override
    public void push(E e) {
        this.addFirst(e);
    }

    @Override
    public E pop() {
        return this.removeFirst();
    }

    @Override
    public TIterator<E> descendingIterator() {
        return new DescendingIterator();
    }

    @Override
    public TLinkedList<E> reversed() {
        return new ReversedLinkedList(this);
    }

    private void removeEntry(Entry<E> entry) {
        if (entry.previous != null) {
            entry.previous.next = entry.next;
        } else {
            this.firstEntry = entry.next;
        }
        if (entry.next != null) {
            entry.next.previous = entry.previous;
        } else {
            this.lastEntry = entry.previous;
        }
        --this.size;
        ++this.modCount;
    }

    static class Entry<E> {
        E item;
        Entry<E> next;
        Entry<E> previous;

        Entry() {
        }
    }

    private class SequentialListIterator
    implements TListIterator<E> {
        private Entry<E> nextEntry;
        private Entry<E> prevEntry;
        private Entry<E> currentEntry;
        private int index;
        private int version;

        public SequentialListIterator(Entry<E> nextEntry, Entry<E> prevEntry, int index) {
            this.version = TLinkedList.this.modCount;
            this.nextEntry = nextEntry;
            this.prevEntry = prevEntry;
            this.index = index;
        }

        @Override
        public boolean hasNext() {
            return this.nextEntry != null;
        }

        @Override
        public E next() {
            this.checkConcurrentModification();
            if (this.nextEntry == null) {
                throw new TNoSuchElementException();
            }
            Object result = this.nextEntry.item;
            this.currentEntry = this.nextEntry;
            this.prevEntry = this.nextEntry;
            this.nextEntry = this.nextEntry.next;
            ++this.index;
            return result;
        }

        @Override
        public void remove() {
            if (this.currentEntry == null) {
                throw new IllegalStateException();
            }
            TLinkedList.this.removeEntry(this.currentEntry);
            if (this.currentEntry == this.prevEntry) {
                this.prevEntry = this.hasNext() ? this.nextEntry.previous : null;
                --this.index;
            } else if (this.currentEntry == this.nextEntry) {
                this.nextEntry = this.hasPrevious() ? this.prevEntry.next : null;
            }
            this.version = TLinkedList.this.modCount;
            this.currentEntry = null;
        }

        @Override
        public boolean hasPrevious() {
            return this.prevEntry != null;
        }

        @Override
        public E previous() {
            this.checkConcurrentModification();
            if (this.prevEntry == null) {
                throw new TNoSuchElementException();
            }
            this.currentEntry = this.prevEntry;
            Object result = this.prevEntry.item;
            this.nextEntry = this.prevEntry;
            this.prevEntry = this.prevEntry.previous;
            --this.index;
            return result;
        }

        @Override
        public int nextIndex() {
            return this.index;
        }

        @Override
        public int previousIndex() {
            return this.index - 1;
        }

        @Override
        public void set(E e) {
            if (this.currentEntry == null) {
                throw new IllegalStateException();
            }
            this.checkConcurrentModification();
            this.currentEntry.item = e;
            this.currentEntry = null;
        }

        @Override
        public void add(E e) {
            this.checkConcurrentModification();
            Entry newEntry = new Entry();
            newEntry.item = e;
            newEntry.previous = this.prevEntry;
            newEntry.next = this.nextEntry;
            if (this.prevEntry != null) {
                this.prevEntry.next = newEntry;
            } else {
                TLinkedList.this.firstEntry = newEntry;
            }
            if (this.nextEntry != null) {
                this.nextEntry.previous = newEntry;
            } else {
                TLinkedList.this.lastEntry = newEntry;
            }
            this.prevEntry = newEntry;
            ++TLinkedList.this.size;
            ++TLinkedList.this.modCount;
            this.version = TLinkedList.this.modCount;
            this.currentEntry = null;
        }

        private void checkConcurrentModification() {
            if (this.version < TLinkedList.this.modCount) {
                throw new TConcurrentModificationException();
            }
        }
    }

    private class DescendingIterator
    implements TIterator<E> {
        private Entry<E> prevEntry;
        private Entry<E> currentEntry;
        private int version;

        private DescendingIterator() {
            this.prevEntry = TLinkedList.this.lastEntry;
            this.version = TLinkedList.this.modCount;
        }

        @Override
        public boolean hasNext() {
            return this.prevEntry != null;
        }

        @Override
        public E next() {
            if (this.version < TLinkedList.this.modCount) {
                throw new TConcurrentModificationException();
            }
            if (this.prevEntry == null) {
                throw new TNoSuchElementException();
            }
            this.currentEntry = this.prevEntry;
            this.prevEntry = this.prevEntry.previous;
            return this.currentEntry.item;
        }

        @Override
        public void remove() {
            if (this.currentEntry == null) {
                throw new TNoSuchElementException();
            }
            TLinkedList.this.removeEntry(this.currentEntry);
            this.version = TLinkedList.this.modCount;
            this.currentEntry = null;
        }
    }

    private static class ReversedLinkedList<E>
    extends TLinkedList<E> {
        private final TLinkedList<E> list;
        private final TReversedList<E> reversed;

        private ReversedLinkedList(TLinkedList<E> list) {
            this.list = list;
            this.reversed = new TReversedList<E>(list);
        }

        @Override
        public String toString() {
            return this.reversed.toString();
        }

        @Override
        public boolean retainAll(TCollection<?> c) {
            return this.reversed.retainAll(c);
        }

        @Override
        public boolean removeAll(TCollection<?> c) {
            return this.reversed.removeAll(c);
        }

        @Override
        public boolean containsAll(TCollection<?> c) {
            return this.reversed.containsAll(c);
        }

        @Override
        public boolean isEmpty() {
            return this.list.isEmpty();
        }

        @Override
        public TStream<E> stream() {
            return this.reversed.stream();
        }

        @Override
        public boolean removeIf(Predicate<? super E> filter) {
            return this.list.removeIf(filter);
        }

        @Override
        public <T> T[] toArray(IntFunction<T[]> generator) {
            return this.reversed.toArray(generator);
        }

        @Override
        public void forEach(Consumer<? super E> action) {
            this.reversed.forEach(action);
        }

        @Override
        public TIterator<E> iterator() {
            return this.list.descendingIterator();
        }

        @Override
        public int hashCode() {
            return this.reversed.hashCode();
        }

        @Override
        public boolean equals(Object o) {
            return this.reversed.equals(o);
        }

        @Override
        public TList<E> subList(int fromIndex, int toIndex) {
            return this.reversed.subList(fromIndex, toIndex);
        }

        @Override
        public TListIterator<E> listIterator() {
            return this.reversed.listIterator();
        }

        @Override
        public void sort(TComparator<? super E> c) {
            this.reversed.sort(c);
        }

        @Override
        public void replaceAll(TUnaryOperator<E> operator) {
            this.list.replaceAll(operator);
        }

        @Override
        public TLinkedList<E> reversed() {
            return this.list;
        }

        @Override
        public TSpliterator<E> spliterator() {
            return this.reversed.spliterator();
        }

        @Override
        public <T> T[] toArray(T[] a) {
            return this.reversed.toArray(a);
        }

        @Override
        public Object[] toArray() {
            return this.reversed.toArray();
        }

        @Override
        public TIterator<E> descendingIterator() {
            return this.list.iterator();
        }

        @Override
        public TListIterator<E> listIterator(int index) {
            return this.reversed.listIterator(index);
        }

        @Override
        public boolean removeLastOccurrence(Object o) {
            return this.list.removeFirstOccurrence(o);
        }

        @Override
        public boolean removeFirstOccurrence(Object o) {
            return this.list.removeLastOccurrence(o);
        }

        @Override
        public E pop() {
            return this.list.removeLast();
        }

        @Override
        public void push(E e) {
            this.list.addLast(e);
        }

        @Override
        public E pollLast() {
            return this.list.pollFirst();
        }

        @Override
        public E pollFirst() {
            return this.list.pollLast();
        }

        @Override
        public E peekLast() {
            return this.list.peekFirst();
        }

        @Override
        public E peekFirst() {
            return this.list.peekLast();
        }

        @Override
        public boolean offerLast(E e) {
            return this.list.offerFirst(e);
        }

        @Override
        public boolean offerFirst(E e) {
            return this.list.offerLast(e);
        }

        @Override
        public boolean offer(E e) {
            return this.list.offerLast(e);
        }

        @Override
        public E remove() {
            return this.list.removeFirst();
        }

        @Override
        public E poll() {
            return this.list.pollLast();
        }

        @Override
        public E element() {
            if (this.list.lastEntry == null) {
                throw new TNoSuchElementException();
            }
            return this.list.lastEntry.item;
        }

        @Override
        public E peek() {
            return this.list.lastEntry != null ? (E)this.list.lastEntry.item : null;
        }

        @Override
        public int lastIndexOf(Object o) {
            return this.list.size() - this.list.indexOf(o) - 1;
        }

        @Override
        public int indexOf(Object o) {
            return this.list.size() - this.list.lastIndexOf(o) - 1;
        }

        @Override
        public E remove(int index) {
            return this.reversed.remove(index);
        }

        @Override
        public void add(int index, E element) {
            this.reversed.add(index, element);
        }

        @Override
        public E set(int index, E element) {
            return this.reversed.set(index, element);
        }

        @Override
        public E get(int index) {
            return this.reversed.get(index);
        }

        @Override
        public void clear() {
            this.list.clear();
        }

        @Override
        public boolean addAll(int index, TCollection<? extends E> c) {
            return this.reversed.addAll(index, c);
        }

        @Override
        public boolean addAll(TCollection<? extends E> c) {
            return this.reversed.addAll(c);
        }

        @Override
        public boolean remove(Object o) {
            return this.list.removeLastOccurrence(o);
        }

        @Override
        public boolean add(E e) {
            this.list.addLast(e);
            return true;
        }

        @Override
        public int size() {
            return this.list.size();
        }

        @Override
        public boolean contains(Object o) {
            return this.list.contains(o);
        }

        @Override
        public void addLast(E e) {
            this.list.addFirst(e);
        }

        @Override
        public void addFirst(E e) {
            this.list.addLast(e);
        }

        @Override
        public E removeLast() {
            return this.list.removeFirst();
        }

        @Override
        public E removeFirst() {
            return this.list.removeLast();
        }

        @Override
        public E getLast() {
            return this.list.getFirst();
        }

        @Override
        public E getFirst() {
            return this.list.getLast();
        }
    }
}

