/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.util;

import org.teavm.classlib.java.util.function.TDoubleConsumer;

public class TDoubleSummaryStatistics
implements TDoubleConsumer {
    private long count;
    private double sum;
    private double min = Double.POSITIVE_INFINITY;
    private double max = Double.NEGATIVE_INFINITY;

    public TDoubleSummaryStatistics() {
    }

    public TDoubleSummaryStatistics(long count, double min, double max, double sum) throws IllegalArgumentException {
        if (count < 0L || count > 0L && min > max) {
            throw new IllegalArgumentException();
        }
        if (count == 0L) {
            return;
        }
        boolean minNan = Double.isNaN(min);
        boolean maxNan = Double.isNaN(max);
        boolean sumNan = Double.isNaN(sum);
        if (!(minNan && maxNan && sumNan || !minNan && !maxNan && !sumNan)) {
            throw new IllegalArgumentException();
        }
        this.count = count;
        this.sum = sum;
        this.min = min;
        this.max = max;
    }

    @Override
    public void accept(double value) {
        ++this.count;
        this.sum += value;
        this.min = Math.min(this.min, value);
        this.max = Math.max(this.max, value);
    }

    public void combine(TDoubleSummaryStatistics that) {
        this.count += that.count;
        this.sum += that.sum;
        this.min = Math.min(this.min, that.min);
        this.max = Math.max(this.max, that.max);
    }

    public final long getCount() {
        return this.count;
    }

    public final double getSum() {
        return this.sum;
    }

    public final double getMin() {
        return this.min;
    }

    public final double getMax() {
        return this.max;
    }

    public final double getAverage() {
        return this.count > 0L ? this.sum / (double)this.count : 0.0;
    }

    public String toString() {
        return "DoubleSummaryStatistics{count=" + this.count + ", sum=" + this.sum + ", min=" + this.min + ", max=" + this.max + ", avg=" + this.getAverage() + "}";
    }
}

