/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.util.stream.intimpl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.PrimitiveIterator;
import java.util.Spliterator;
import java.util.function.BiConsumer;
import java.util.function.IntBinaryOperator;
import java.util.function.IntConsumer;
import java.util.function.IntFunction;
import java.util.function.IntPredicate;
import java.util.function.IntToDoubleFunction;
import java.util.function.IntToLongFunction;
import java.util.function.IntUnaryOperator;
import java.util.function.ObjIntConsumer;
import java.util.function.Supplier;
import org.teavm.classlib.java.util.TIntSummaryStatistics;
import org.teavm.classlib.java.util.stream.TDoubleStream;
import org.teavm.classlib.java.util.stream.TIntStream;
import org.teavm.classlib.java.util.stream.TLongStream;
import org.teavm.classlib.java.util.stream.TStream;
import org.teavm.classlib.java.util.stream.intimpl.TAllMatchConsumer;
import org.teavm.classlib.java.util.stream.intimpl.TAnyMatchConsumer;
import org.teavm.classlib.java.util.stream.intimpl.TBoxedIntStream;
import org.teavm.classlib.java.util.stream.intimpl.TCloseHandlingIntStream;
import org.teavm.classlib.java.util.stream.intimpl.TCountingIntConsumer;
import org.teavm.classlib.java.util.stream.intimpl.TDistinctIntStreamImpl;
import org.teavm.classlib.java.util.stream.intimpl.TDropWhileIntStream;
import org.teavm.classlib.java.util.stream.intimpl.TFilteringIntStreamImpl;
import org.teavm.classlib.java.util.stream.intimpl.TFindFirstIntConsumer;
import org.teavm.classlib.java.util.stream.intimpl.TFlatMappingIntStreamImpl;
import org.teavm.classlib.java.util.stream.intimpl.TIntAsDoubleStream;
import org.teavm.classlib.java.util.stream.intimpl.TIntAsLongStream;
import org.teavm.classlib.java.util.stream.intimpl.TLimitingIntStreamImpl;
import org.teavm.classlib.java.util.stream.intimpl.TMappingIntStreamImpl;
import org.teavm.classlib.java.util.stream.intimpl.TMappingToDoubleStreamImpl;
import org.teavm.classlib.java.util.stream.intimpl.TMappingToLongStreamImpl;
import org.teavm.classlib.java.util.stream.intimpl.TMappingToObjStreamImpl;
import org.teavm.classlib.java.util.stream.intimpl.TPeekingIntStreamImpl;
import org.teavm.classlib.java.util.stream.intimpl.TReducingIntConsumer;
import org.teavm.classlib.java.util.stream.intimpl.TSimpleIntStreamIterator;
import org.teavm.classlib.java.util.stream.intimpl.TSimpleIntStreamSpliterator;
import org.teavm.classlib.java.util.stream.intimpl.TSkippingIntStreamImpl;
import org.teavm.classlib.java.util.stream.intimpl.TSumIntAsDoubleConsumer;
import org.teavm.classlib.java.util.stream.intimpl.TSumIntConsumer;
import org.teavm.classlib.java.util.stream.intimpl.TSummaryIntConsumer;
import org.teavm.classlib.java.util.stream.intimpl.TTakeWhileIntStream;

public abstract class TSimpleIntStreamImpl
implements TIntStream {
    @Override
    public TIntStream filter(IntPredicate predicate) {
        return new TFilteringIntStreamImpl(this, predicate);
    }

    @Override
    public TIntStream map(IntUnaryOperator mapper) {
        return new TMappingIntStreamImpl(this, mapper);
    }

    @Override
    public <U> TStream<U> mapToObj(IntFunction<? extends U> mapper) {
        return new TMappingToObjStreamImpl<U>(this, mapper);
    }

    @Override
    public TLongStream mapToLong(IntToLongFunction mapper) {
        return new TMappingToLongStreamImpl(this, mapper);
    }

    @Override
    public TDoubleStream mapToDouble(IntToDoubleFunction mapper) {
        return new TMappingToDoubleStreamImpl(this, mapper);
    }

    @Override
    public TIntStream flatMap(IntFunction<? extends TIntStream> mapper) {
        return new TFlatMappingIntStreamImpl(this, mapper);
    }

    @Override
    public TIntStream distinct() {
        return new TDistinctIntStreamImpl(this);
    }

    @Override
    public TIntStream sorted() {
        int[] array = this.toArray();
        Arrays.sort(array);
        return TIntStream.of(array);
    }

    @Override
    public TIntStream peek(IntConsumer action) {
        return new TPeekingIntStreamImpl(this, action);
    }

    @Override
    public TIntStream limit(long maxSize) {
        return new TLimitingIntStreamImpl(this, (int)maxSize);
    }

    @Override
    public TIntStream takeWhile(IntPredicate predicate) {
        return new TTakeWhileIntStream(this, predicate);
    }

    @Override
    public TIntStream dropWhile(IntPredicate predicate) {
        return new TDropWhileIntStream(this, predicate);
    }

    @Override
    public TIntStream skip(long n) {
        return new TSkippingIntStreamImpl(this, (int)n);
    }

    @Override
    public void forEach(IntConsumer action) {
        this.forEachOrdered(action);
    }

    @Override
    public void forEachOrdered(IntConsumer action) {
        boolean hasMore;
        while (hasMore = this.next(e -> {
            action.accept(e);
            return true;
        })) {
        }
    }

    @Override
    public int[] toArray() {
        int estimatedSize = this.estimateSize();
        if (estimatedSize < 0) {
            ArrayList list = new ArrayList();
            while (this.next(list::add)) {
            }
            int[] array = new int[list.size()];
            for (int i = 0; i < array.length; ++i) {
                array[i] = (Integer)list.get(i);
            }
            return array;
        }
        int[] array = new int[estimatedSize];
        ArrayFillingConsumer consumer = new ArrayFillingConsumer(array);
        while (this.next(consumer)) {
        }
        if (consumer.index < array.length) {
            array = Arrays.copyOf(array, consumer.index);
        }
        return array;
    }

    @Override
    public int reduce(int identity, IntBinaryOperator accumulator) {
        TReducingIntConsumer consumer = new TReducingIntConsumer(accumulator, identity, true);
        while (this.next(consumer)) {
        }
        return consumer.result;
    }

    @Override
    public OptionalInt reduce(IntBinaryOperator accumulator) {
        TReducingIntConsumer consumer = new TReducingIntConsumer(accumulator, 0, false);
        while (this.next(consumer)) {
        }
        return consumer.initialized ? OptionalInt.of(consumer.result) : OptionalInt.empty();
    }

    @Override
    public <R> R collect(Supplier<R> supplier, ObjIntConsumer<R> accumulator, BiConsumer<R, R> combiner) {
        boolean hasMore;
        Object collection = supplier.get();
        while (hasMore = this.next(e -> {
            accumulator.accept(collection, e);
            return true;
        })) {
        }
        return collection;
    }

    @Override
    public OptionalInt min() {
        return this.reduce(Math::min);
    }

    @Override
    public OptionalInt max() {
        return this.reduce(Math::max);
    }

    @Override
    public long count() {
        TCountingIntConsumer consumer = new TCountingIntConsumer();
        while (this.next(consumer)) {
        }
        return consumer.count;
    }

    @Override
    public int sum() {
        TSumIntConsumer consumer = new TSumIntConsumer();
        while (this.next(consumer)) {
        }
        return consumer.sum;
    }

    @Override
    public OptionalDouble average() {
        TSumIntAsDoubleConsumer consumer = new TSumIntAsDoubleConsumer();
        while (this.next(consumer)) {
        }
        return consumer.count > 0 ? OptionalDouble.of(consumer.sum / (double)consumer.count) : OptionalDouble.empty();
    }

    @Override
    public TIntSummaryStatistics summaryStatistics() {
        TSummaryIntConsumer consumer = new TSummaryIntConsumer();
        while (this.next(consumer)) {
        }
        return consumer.stat;
    }

    @Override
    public boolean anyMatch(IntPredicate predicate) {
        TAnyMatchConsumer consumer = new TAnyMatchConsumer(predicate);
        while (!consumer.matched && this.next(consumer)) {
        }
        return consumer.matched;
    }

    @Override
    public boolean allMatch(IntPredicate predicate) {
        TAllMatchConsumer consumer = new TAllMatchConsumer(predicate);
        while (consumer.matched && this.next(consumer)) {
        }
        return consumer.matched;
    }

    @Override
    public boolean noneMatch(IntPredicate predicate) {
        return !this.anyMatch(predicate);
    }

    @Override
    public OptionalInt findFirst() {
        TFindFirstIntConsumer consumer = new TFindFirstIntConsumer();
        while (!consumer.hasAny && this.next(consumer)) {
        }
        return consumer.hasAny ? OptionalInt.of(consumer.result) : OptionalInt.empty();
    }

    @Override
    public OptionalInt findAny() {
        return this.findFirst();
    }

    @Override
    public TLongStream asLongStream() {
        return new TIntAsLongStream(this);
    }

    @Override
    public TDoubleStream asDoubleStream() {
        return new TIntAsDoubleStream(this);
    }

    @Override
    public PrimitiveIterator.OfInt iterator() {
        return new TSimpleIntStreamIterator(this);
    }

    @Override
    public Spliterator.OfInt spliterator() {
        return new TSimpleIntStreamSpliterator(this);
    }

    @Override
    public TStream<Integer> boxed() {
        return new TBoxedIntStream(this);
    }

    @Override
    public boolean isParallel() {
        return false;
    }

    @Override
    public TIntStream sequential() {
        return this;
    }

    @Override
    public TIntStream parallel() {
        return this;
    }

    @Override
    public TIntStream unordered() {
        return this;
    }

    @Override
    public TIntStream onClose(Runnable closeHandler) {
        return new TCloseHandlingIntStream(this, closeHandler);
    }

    @Override
    public void close() throws Exception {
    }

    protected int estimateSize() {
        return -1;
    }

    public abstract boolean next(IntPredicate var1);

    static class ArrayFillingConsumer
    implements IntPredicate {
        int[] array;
        int index;

        ArrayFillingConsumer(int[] array) {
            this.array = array;
        }

        @Override
        public boolean test(int t) {
            this.array[this.index++] = t;
            return true;
        }
    }
}

