/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.util;

import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import org.teavm.classlib.java.util.TCollection;
import org.teavm.classlib.java.util.TConcurrentModificationException;
import org.teavm.classlib.java.util.THashMap;
import org.teavm.classlib.java.util.TIterator;
import org.teavm.classlib.java.util.TLinkedHashMapEntrySet;
import org.teavm.classlib.java.util.TLinkedHashMapKeySet;
import org.teavm.classlib.java.util.TLinkedHashMapValues;
import org.teavm.classlib.java.util.TMap;
import org.teavm.classlib.java.util.TNoSuchElementException;
import org.teavm.classlib.java.util.TReversedLinkedHashMap;
import org.teavm.classlib.java.util.TSequencedCollection;
import org.teavm.classlib.java.util.TSequencedMap;
import org.teavm.classlib.java.util.TSequencedSet;
import org.teavm.classlib.java.util.TSet;

public class TLinkedHashMap<K, V>
extends THashMap<K, V>
implements TSequencedMap<K, V> {
    private boolean accessOrder;
    transient LinkedHashMapEntry<K, V> head;
    transient LinkedHashMapEntry<K, V> tail;

    public TLinkedHashMap() {
        this.accessOrder = false;
        this.head = null;
    }

    public TLinkedHashMap(int s) {
        super(s);
        this.accessOrder = false;
        this.head = null;
    }

    public TLinkedHashMap(int s, float lf) {
        super(s, lf);
        this.accessOrder = false;
        this.head = null;
        this.tail = null;
    }

    public TLinkedHashMap(int s, float lf, boolean order) {
        super(s, lf);
        this.accessOrder = order;
        this.head = null;
        this.tail = null;
    }

    public TLinkedHashMap(TMap<? extends K, ? extends V> m) {
        this.accessOrder = false;
        this.head = null;
        this.tail = null;
        this.putAll(m);
    }

    @Override
    void putAllImpl(TMap<? extends K, ? extends V> map) {
        int capacity = this.elementCount + map.size();
        if (capacity > this.threshold) {
            this.rehash(capacity);
        }
        TIterator it = map.entrySet().iterator();
        while (it.hasNext()) {
            TMap.Entry entry = (TMap.Entry)it.next();
            this.putImpl(entry.getKey(), entry.getValue(), false, this.accessOrder);
        }
    }

    @Override
    public boolean containsValue(Object value) {
        LinkedHashMapEntry<K, V> entry = this.head;
        if (null == value) {
            while (null != entry) {
                if (null == entry.value) {
                    return true;
                }
                entry = entry.chainForward;
            }
        } else {
            while (null != entry) {
                if (value.equals(entry.value)) {
                    return true;
                }
                entry = entry.chainForward;
            }
        }
        return false;
    }

    @Override
    THashMap.HashEntry<K, V>[] newElementArray(int s) {
        return new LinkedHashMapEntry[s];
    }

    @Override
    public V getOrDefault(Object key, V defaultValue) {
        LinkedHashMapEntry entry;
        if (key == null) {
            entry = (LinkedHashMapEntry)this.findNullKeyEntry();
        } else {
            int hash = key.hashCode();
            int index = (hash & Integer.MAX_VALUE) % this.elementData.length;
            entry = (LinkedHashMapEntry)this.findNonNullKeyEntry(key, index, hash);
        }
        if (entry == null) {
            return defaultValue;
        }
        if (this.accessOrder) {
            this.linkEntry(entry, false);
        }
        return (V)entry.value;
    }

    @Override
    public V get(Object key) {
        return this.getOrDefault(key, null);
    }

    private THashMap.HashEntry<K, V> createHashedEntry(K key, int index, int hash, boolean first) {
        LinkedHashMapEntry entry = new LinkedHashMapEntry(key, hash);
        entry.next = this.elementData[index];
        this.elementData[index] = entry;
        if (first) {
            if (this.head != null) {
                this.head.chainBackward = entry;
            } else {
                this.tail = entry;
            }
            entry.chainForward = this.head;
            this.head = entry;
        } else {
            if (this.tail != null) {
                this.tail.chainForward = entry;
            } else {
                this.head = entry;
            }
            entry.chainBackward = this.tail;
            this.tail = entry;
        }
        return entry;
    }

    @Override
    public V put(K key, V value) {
        int oldSize = this.size();
        V existing = this.putImpl(key, value, false, this.accessOrder);
        if (this.size() != oldSize && this.removeEldestEntry(this.head)) {
            this.removeLinkedEntry(this.head);
        }
        return existing;
    }

    V putImpl(K key, V value, boolean first, boolean forceMotion) {
        if (this.elementCount == 0) {
            this.head = null;
            this.tail = null;
        }
        int hash = Objects.hashCode(key);
        int index = (hash & Integer.MAX_VALUE) % this.elementData.length;
        LinkedHashMapEntry entry = (LinkedHashMapEntry)(key != null ? this.findNonNullKeyEntry(key, index, hash) : this.findNullKeyEntry());
        if (entry == null) {
            ++this.modCount;
            if (++this.elementCount > this.threshold) {
                this.rehash();
                index = (hash & Integer.MAX_VALUE) % this.elementData.length;
            }
            entry = (LinkedHashMapEntry)this.createHashedEntry(key, index, hash, first);
        } else if (forceMotion) {
            this.linkEntry(entry, first);
        }
        Object existing = entry.value;
        entry.value = value;
        return (V)existing;
    }

    private void linkEntry(LinkedHashMapEntry<K, V> entry, boolean first) {
        if (first) {
            LinkedHashMapEntry p = entry.chainBackward;
            if (p == null) {
                return;
            }
            LinkedHashMapEntry n = entry.chainForward;
            if (n != null) {
                n.chainBackward = p;
            } else {
                this.tail = p;
            }
            p.chainForward = n;
            if (this.head != null) {
                this.head.chainBackward = entry;
            }
            entry.chainForward = this.head;
            entry.chainBackward = null;
            this.head = entry;
        } else {
            LinkedHashMapEntry n = entry.chainForward;
            if (n == null) {
                return;
            }
            LinkedHashMapEntry p = entry.chainBackward;
            if (p != null) {
                p.chainForward = n;
            } else {
                this.head = n;
            }
            n.chainBackward = p;
            if (this.tail != null) {
                this.tail.chainForward = entry;
            }
            entry.chainBackward = this.tail;
            entry.chainForward = null;
            this.tail = entry;
        }
    }

    @Override
    public TSet<TMap.Entry<K, V>> entrySet() {
        return new TLinkedHashMapEntrySet(this, false);
    }

    @Override
    public TSet<K> keySet() {
        return this.sequencedKeySet();
    }

    @Override
    public TSequencedSet<K> sequencedKeySet() {
        if (this.cachedKeySet == null) {
            this.cachedKeySet = new TLinkedHashMapKeySet(this, false);
        }
        return (TSequencedSet)this.cachedKeySet;
    }

    @Override
    public TCollection<V> values() {
        return this.sequencedValues();
    }

    @Override
    public TSequencedCollection<V> sequencedValues() {
        if (this.cachedValues == null) {
            this.cachedValues = new TLinkedHashMapValues(this, false);
        }
        return (TSequencedCollection)this.cachedValues;
    }

    @Override
    public TSequencedSet<TMap.Entry<K, V>> sequencedEntrySet() {
        return new TLinkedHashMapEntrySet(this, false);
    }

    @Override
    public V remove(Object key) {
        LinkedHashMapEntry m = (LinkedHashMapEntry)this.removeByKey(key);
        if (m == null) {
            return null;
        }
        this.unlinkEntry(m);
        return (V)m.value;
    }

    void removeLinkedEntry(LinkedHashMapEntry<K, V> entry) {
        this.removeEntry(entry);
        this.unlinkEntry(entry);
    }

    private void unlinkEntry(LinkedHashMapEntry<K, V> entry) {
        LinkedHashMapEntry p = entry.chainBackward;
        LinkedHashMapEntry n = entry.chainForward;
        if (p != null) {
            p.chainForward = n;
            if (n != null) {
                n.chainBackward = p;
            } else {
                this.tail = p;
            }
        } else {
            this.head = n;
            if (n != null) {
                n.chainBackward = null;
            } else {
                this.tail = null;
            }
        }
    }

    @Override
    public void forEach(BiConsumer<? super K, ? super V> action) {
        if (this.elementCount > 0) {
            int prevModCount = this.modCount;
            LinkedHashMapEntry<K, V> entry = this.head;
            do {
                action.accept(entry.key, entry.value);
                entry = entry.chainForward;
                if (this.modCount == prevModCount) continue;
                throw new TConcurrentModificationException();
            } while (entry != null);
        }
    }

    protected boolean removeEldestEntry(TMap.Entry<K, V> eldest) {
        return false;
    }

    @Override
    public void clear() {
        super.clear();
        this.head = null;
        this.tail = null;
    }

    @Override
    public void replaceAll(BiFunction<? super K, ? super V, ? extends V> function) {
        if (this.elementCount > 0) {
            int prevModCount = this.modCount;
            LinkedHashMapEntry<K, V> entry = this.head;
            do {
                entry.value = function.apply(entry.key, entry.value);
                entry = entry.chainForward;
                if (this.modCount == prevModCount) continue;
                throw new TConcurrentModificationException();
            } while (entry != null);
        }
    }

    @Override
    public V putFirst(K k, V v) {
        return this.putImpl(k, v, true, true);
    }

    @Override
    public V putLast(K k, V v) {
        return this.putImpl(k, v, false, true);
    }

    @Override
    public TSequencedMap<K, V> reversed() {
        return new TReversedLinkedHashMap(this);
    }

    public static <K, V> TLinkedHashMap<K, V> newLinkedHashMap(int size) {
        if (size < 0) {
            throw new IllegalArgumentException();
        }
        return new TLinkedHashMap<K, V>(THashMap.capacity(size));
    }

    static <T> T checkNotNull(T node) {
        if (node == null) {
            throw new TNoSuchElementException();
        }
        return node;
    }

    static final class LinkedHashMapEntry<K, V>
    extends THashMap.HashEntry<K, V> {
        LinkedHashMapEntry<K, V> chainForward = null;
        LinkedHashMapEntry<K, V> chainBackward = null;

        LinkedHashMapEntry(K theKey, V theValue) {
            super(theKey, theValue);
        }

        LinkedHashMapEntry(K theKey, int hash) {
            super(theKey, hash);
        }

        @Override
        public Object clone() {
            LinkedHashMapEntry entry = (LinkedHashMapEntry)super.clone();
            entry.chainBackward = this.chainBackward;
            entry.chainForward = this.chainForward;
            LinkedHashMapEntry lnext = (LinkedHashMapEntry)entry.next;
            if (lnext != null) {
                entry.next = (LinkedHashMapEntry)lnext.clone();
            }
            return entry;
        }
    }
}

