/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.util;

import java.util.function.IntPredicate;
import org.teavm.classlib.java.io.TSerializable;
import org.teavm.classlib.java.lang.TCloneable;
import org.teavm.classlib.java.lang.TIndexOutOfBoundsException;
import org.teavm.classlib.java.lang.TInteger;
import org.teavm.classlib.java.lang.TMath;
import org.teavm.classlib.java.lang.TObject;
import org.teavm.classlib.java.nio.TByteBuffer;
import org.teavm.classlib.java.nio.TByteOrder;
import org.teavm.classlib.java.nio.TLongBuffer;
import org.teavm.classlib.java.util.TArrays;
import org.teavm.classlib.java.util.stream.TIntStream;
import org.teavm.classlib.java.util.stream.intimpl.TSimpleIntStreamImpl;
import org.teavm.interop.Rename;

public class TBitSet
extends TObject
implements TCloneable,
TSerializable {
    private int[] data;
    private int length;

    private TBitSet(int[] data) {
        this.data = data;
        this.length = data.length * 32;
        this.recalculateLength();
    }

    public TBitSet() {
        this.data = new int[2];
    }

    public TBitSet(int nbits) {
        if (nbits < 0) {
            throw new NegativeArraySizeException();
        }
        this.data = new int[(nbits + 32 - 1) / 32];
    }

    public static TBitSet valueOf(long[] longs) {
        int[] ints = new int[longs.length * 2];
        for (int i = 0; i < longs.length; ++i) {
            ints[i * 2] = (int)longs[i];
            ints[i * 2 + 1] = (int)(longs[i] >>> 32);
        }
        return new TBitSet(ints);
    }

    public static TBitSet valueOf(TLongBuffer buff) {
        buff = buff.slice();
        long[] words = new long[buff.remaining()];
        buff.get(words);
        return TBitSet.valueOf(words);
    }

    public static TBitSet valueOf(byte[] bytes) {
        int[] ints = new int[(bytes.length + 3) / 4];
        int fullInts = bytes.length / 4;
        for (int i = 0; i < fullInts; ++i) {
            ints[i] = bytes[i * 4] & 0xFF | (bytes[i * 4 + 1] & 0xFF) << 8 | (bytes[i * 4 + 2] & 0xFF) << 16 | (bytes[i * 4 + 3] & 0xFF) << 24;
        }
        int lastInt = ints.length - 1;
        int lastByte = lastInt * 4;
        switch (bytes.length % 4) {
            case 3: {
                ints[lastInt] = bytes[lastByte] & 0xFF | (bytes[lastByte + 1] & 0xFF) << 8 | (bytes[lastByte + 2] & 0xFF) << 16;
                break;
            }
            case 2: {
                ints[lastInt] = bytes[lastByte] & 0xFF | (bytes[lastByte + 1] & 0xFF) << 8;
                break;
            }
            case 1: {
                ints[lastInt] = bytes[lastByte] & 0xFF;
            }
        }
        return new TBitSet(ints);
    }

    public static TBitSet valueOf(TByteBuffer buff) {
        buff = buff.slice().order(TByteOrder.LITTLE_ENDIAN);
        byte[] words = new byte[buff.remaining()];
        buff.get(words);
        return TBitSet.valueOf(words);
    }

    public byte[] toByteArray() {
        int i;
        byte[] bytes = new byte[(this.length + 7) / 8];
        int fullInts = bytes.length / 4;
        int j = 0;
        for (i = 0; i < fullInts; ++i) {
            bytes[j++] = (byte)this.data[i];
            bytes[j++] = (byte)(this.data[i] >>> 8);
            bytes[j++] = (byte)(this.data[i] >>> 16);
            bytes[j++] = (byte)(this.data[i] >>> 24);
        }
        switch (bytes.length % 4) {
            case 3: {
                bytes[j++] = (byte)this.data[i];
                bytes[j++] = (byte)(this.data[i] >>> 8);
                bytes[j++] = (byte)(this.data[i] >>> 16);
                break;
            }
            case 2: {
                bytes[j++] = (byte)this.data[i];
                bytes[j++] = (byte)(this.data[i] >>> 8);
                break;
            }
            case 1: {
                bytes[j++] = (byte)this.data[i];
            }
        }
        return bytes;
    }

    public long[] toLongArray() {
        int i;
        long[] longs = new long[(this.length + 63) / 64];
        int fullLongs = this.length / 64;
        for (i = 0; i < fullLongs; ++i) {
            longs[i] = (long)this.data[i * 2] | (long)this.data[i * 2 + 1] << 32;
        }
        if (((31 + this.length) / 32 & 1) == 1) {
            longs[i] = this.data[i * 2];
        }
        return longs;
    }

    public void flip(int bitIndex) {
        if (this.get(bitIndex)) {
            this.clear(bitIndex);
        } else {
            this.set(bitIndex);
        }
    }

    public void flip(int fromIndex, int toIndex) {
        if (fromIndex < 0 || fromIndex > toIndex) {
            throw new TIndexOutOfBoundsException();
        }
        int fromDataIndex = fromIndex / 32;
        int toDataIndex = toIndex / 32;
        if (toIndex > this.length) {
            this.ensureCapacity(toDataIndex + 1);
            this.length = toIndex;
        }
        if (fromDataIndex == toDataIndex) {
            int n = fromDataIndex;
            this.data[n] = this.data[n] ^ this.trailingZeroBits(fromIndex) & this.trailingOneBits(toIndex);
        } else {
            int n = fromDataIndex;
            this.data[n] = this.data[n] ^ this.trailingZeroBits(fromIndex);
            int i = fromDataIndex + 1;
            while (i < toDataIndex) {
                int n2 = i++;
                this.data[n2] = ~this.data[n2];
            }
            if ((toIndex & 0x1F) != 0) {
                int n3 = toDataIndex;
                this.data[n3] = this.data[n3] ^ this.trailingOneBits(toIndex);
            }
        }
        if (toIndex == this.length) {
            this.recalculateLength();
        }
    }

    public void set(int bitIndex) {
        if (bitIndex < 0) {
            throw new IndexOutOfBoundsException();
        }
        int index = bitIndex / 32;
        if (bitIndex >= this.length) {
            this.ensureCapacity(index + 1);
            this.length = bitIndex + 1;
        }
        int n = index;
        this.data[n] = this.data[n] | 1 << bitIndex % 32;
    }

    public void set(int bitIndex, boolean value) {
        if (value) {
            this.set(bitIndex);
        } else {
            this.clear(bitIndex);
        }
    }

    public void set(int fromIndex, int toIndex) {
        if (fromIndex < 0 || fromIndex > toIndex) {
            throw new TIndexOutOfBoundsException();
        }
        if (fromIndex == toIndex) {
            return;
        }
        int fromDataIndex = fromIndex / 32;
        int toDataIndex = toIndex / 32;
        if (toIndex > this.length) {
            this.ensureCapacity(toDataIndex + 1);
            this.length = toIndex;
        }
        if (fromDataIndex == toDataIndex) {
            int n = fromDataIndex;
            this.data[n] = this.data[n] | this.trailingZeroBits(fromIndex) & this.trailingOneBits(toIndex);
        } else {
            int n = fromDataIndex;
            this.data[n] = this.data[n] | this.trailingZeroBits(fromIndex);
            for (int i = fromDataIndex + 1; i < toDataIndex; ++i) {
                this.data[i] = -1;
            }
            if ((toIndex & 0x1F) != 0) {
                int n2 = toDataIndex;
                this.data[n2] = this.data[n2] | this.trailingOneBits(toIndex);
            }
        }
    }

    private int trailingZeroBits(int num) {
        return -1 << (num %= 32);
    }

    private int trailingOneBits(int num) {
        return (num %= 32) != 0 ? -1 >>> 32 - num : 0;
    }

    public void set(int fromIndex, int toIndex, boolean value) {
        if (value) {
            this.set(fromIndex, toIndex);
        } else {
            this.clear(fromIndex, toIndex);
        }
    }

    public void clear(int bitIndex) {
        if (bitIndex < 0) {
            throw new IndexOutOfBoundsException();
        }
        int index = bitIndex / 32;
        if (index < this.data.length) {
            int n = index;
            this.data[n] = this.data[n] & TInteger.rotateLeft(-2, bitIndex % 32);
            if (bitIndex == this.length - 1) {
                this.recalculateLength();
            }
        }
    }

    public void clear(int fromIndex, int toIndex) {
        if (fromIndex < 0 || fromIndex > toIndex) {
            throw new TIndexOutOfBoundsException();
        }
        if (fromIndex >= this.length) {
            return;
        }
        if (fromIndex == (toIndex = TMath.min(this.length, toIndex))) {
            return;
        }
        int fromDataIndex = fromIndex / 32;
        int toDataIndex = toIndex / 32;
        if (fromDataIndex == toDataIndex) {
            int n = fromDataIndex;
            this.data[n] = this.data[n] & (this.trailingOneBits(fromIndex) | this.trailingZeroBits(toIndex));
        } else {
            int n = fromDataIndex;
            this.data[n] = this.data[n] & this.trailingOneBits(fromIndex);
            for (int i = fromDataIndex + 1; i < toDataIndex; ++i) {
                this.data[i] = 0;
            }
            if ((toIndex & 0x1F) != 0) {
                int n2 = toDataIndex;
                this.data[n2] = this.data[n2] & this.trailingZeroBits(toIndex);
            }
        }
        this.recalculateLength();
    }

    public void clear() {
        this.length = 0;
        TArrays.fill(this.data, 0);
    }

    public boolean get(int bitIndex) {
        if (bitIndex < 0) {
            throw new IndexOutOfBoundsException();
        }
        int index = bitIndex / 32;
        return index < this.data.length && (this.data[index] & 1 << bitIndex % 32) != 0;
    }

    public TBitSet get(int fromIndex, int toIndex) {
        int i;
        if (fromIndex < 0 || fromIndex > toIndex) {
            throw new TIndexOutOfBoundsException();
        }
        if (toIndex > this.length) {
            if (fromIndex > this.length) {
                return new TBitSet();
            }
            toIndex = this.length;
        }
        if (toIndex == fromIndex) {
            return new TBitSet();
        }
        int newBitSize = toIndex - fromIndex;
        int newArraySize = (newBitSize + 31) / 32;
        int[] newData = new int[newArraySize];
        int shift = fromIndex % 32;
        int offset = fromIndex / 32;
        if (shift != 0) {
            for (i = 0; i < newData.length; ++i) {
                newData[i] = this.data[offset++] >>> shift;
                if (offset >= this.data.length) continue;
                int n = i;
                newData[n] = newData[n] | this.data[offset] << 32 - shift;
            }
        } else {
            i = 0;
            while (i < newData.length) {
                newData[i] = this.data[offset];
                ++i;
                ++offset;
            }
        }
        TBitSet result = new TBitSet(newData);
        result.clear(newBitSize, result.size());
        return result;
    }

    public int nextSetBit(int fromIndex) {
        if (fromIndex < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (fromIndex >= this.length) {
            return -1;
        }
        int index = fromIndex / 32;
        int val = this.data[index];
        if ((val >>>= fromIndex % 32) != 0) {
            return TInteger.numberOfTrailingZeros(val) + fromIndex;
        }
        int top = (this.length + 31) / 32;
        for (int i = index + 1; i < top; ++i) {
            if (this.data[i] == 0) continue;
            return i * 32 + TInteger.numberOfTrailingZeros(this.data[i]);
        }
        return -1;
    }

    public int nextClearBit(int fromIndex) {
        if (fromIndex < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (fromIndex >= this.length) {
            return fromIndex;
        }
        int index = fromIndex / 32;
        int val = ~this.data[index];
        if ((val >>>= fromIndex % 32) != 0) {
            return TInteger.numberOfTrailingZeros(val) + fromIndex;
        }
        int top = (this.length + 31) / 32;
        for (int i = index + 1; i < top; ++i) {
            if (this.data[i] == -1) continue;
            return i * 32 + TInteger.numberOfTrailingZeros(~this.data[i]);
        }
        return this.length;
    }

    public int previousSetBit(int fromIndex) {
        if (fromIndex < 0) {
            if (fromIndex == -1) {
                return -1;
            }
            throw new IndexOutOfBoundsException();
        }
        if (fromIndex >= this.length) {
            fromIndex = this.length;
        }
        int index = fromIndex / 32;
        int val = this.data[index];
        if ((val <<= 31 - fromIndex % 32) != 0) {
            return fromIndex - TInteger.numberOfLeadingZeros(val);
        }
        for (int i = index - 1; i >= 0; --i) {
            if (this.data[i] == 0) continue;
            return (i + 1) * 32 - TInteger.numberOfLeadingZeros(this.data[i]) - 1;
        }
        return -1;
    }

    public int previousClearBit(int fromIndex) {
        if (fromIndex < 0) {
            if (fromIndex == -1) {
                return -1;
            }
            throw new IndexOutOfBoundsException();
        }
        if (fromIndex >= this.length) {
            return fromIndex;
        }
        int index = fromIndex / 32;
        int val = ~this.data[index];
        if ((val <<= 31 - fromIndex % 32) != 0) {
            return fromIndex - TInteger.numberOfLeadingZeros(val);
        }
        for (int i = index - 1; i >= 0; --i) {
            if (this.data[i] == -1) continue;
            return (i + 1) * 32 - TInteger.numberOfLeadingZeros(~this.data[i]) - 1;
        }
        return -1;
    }

    private void ensureCapacity(int capacity) {
        if (this.data.length >= capacity) {
            return;
        }
        int newArrayLength = TMath.max(capacity * 3 / 2, this.data.length * 2 + 1);
        this.data = TArrays.copyOf(this.data, newArrayLength);
    }

    private void recalculateLength() {
        int top = (this.length + 31) / 32;
        this.length = top * 32;
        int i = top - 1;
        while (i >= 0) {
            int sz = TInteger.numberOfLeadingZeros(this.data[i]);
            if (sz < 32) {
                this.length -= sz;
                break;
            }
            --i;
            this.length -= 32;
        }
    }

    public int length() {
        return this.length;
    }

    public boolean intersects(TBitSet set) {
        int sz = TMath.min(this.data.length, set.data.length);
        for (int i = 0; i < sz; ++i) {
            if ((this.data[i] & set.data[i]) == 0) continue;
            return true;
        }
        return false;
    }

    public int cardinality() {
        int result = 0;
        int sz = (this.length + 31) / 32;
        for (int i = 0; i < sz; ++i) {
            result += TInteger.bitCount(this.data[i]);
        }
        return result;
    }

    public void and(TBitSet set) {
        int i;
        int sz = TMath.min(this.data.length, set.data.length);
        for (i = 0; i < sz; ++i) {
            int n = i;
            this.data[n] = this.data[n] & set.data[i];
        }
        for (i = sz; i < this.data.length; ++i) {
            this.data[i] = 0;
        }
        this.length = TMath.min(this.length, set.length);
        this.recalculateLength();
    }

    public void andNot(TBitSet set) {
        int sz = TMath.min(this.data.length, set.data.length);
        for (int i = 0; i < sz; ++i) {
            int n = i;
            this.data[n] = this.data[n] & ~set.data[i];
        }
        this.recalculateLength();
    }

    public void or(TBitSet set) {
        this.length = TMath.max(this.length, set.length);
        this.ensureCapacity((this.length + 31) / 32);
        int sz = TMath.min(this.data.length, set.data.length);
        for (int i = 0; i < sz; ++i) {
            int n = i;
            this.data[n] = this.data[n] | set.data[i];
        }
    }

    public void xor(TBitSet set) {
        this.length = TMath.max(this.length, set.length);
        this.ensureCapacity((this.length + 31) / 32);
        int sz = TMath.min(this.data.length, set.data.length);
        for (int i = 0; i < sz; ++i) {
            int n = i;
            this.data[n] = this.data[n] ^ set.data[i];
        }
        this.recalculateLength();
    }

    public boolean isEmpty() {
        return this.length == 0;
    }

    public int size() {
        return this.data.length * 32;
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof TBitSet)) {
            return false;
        }
        TBitSet set = (TBitSet)other;
        if (set.length != this.length) {
            return false;
        }
        int sz = TMath.min(this.data.length, set.data.length);
        for (int i = 0; i < sz; ++i) {
            if (this.data[i] == set.data[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        long h = 1234L;
        long[] words = this.toLongArray();
        int i = words.length;
        while (--i >= 0) {
            h ^= words[i] * (long)(i + 1);
        }
        return (int)(h >> 32 ^ h);
    }

    @Override
    public String toString() {
        int bit;
        StringBuilder sb = new StringBuilder();
        sb.append('{');
        boolean first = true;
        for (int i = 0; i < this.data.length && (bit = i * 32) <= this.length; ++i) {
            for (int val = this.data[i]; val != 0; val >>>= 1) {
                int numZeros = TInteger.numberOfTrailingZeros(val);
                bit += numZeros;
                if (!first) {
                    sb.append(", ");
                } else {
                    first = false;
                }
                sb.append(bit++);
                val >>>= numZeros;
            }
        }
        sb.append('}');
        return sb.toString();
    }

    public TIntStream stream() {
        return new BitSetStream();
    }

    @Rename(value="clone")
    public TObject clone0() {
        return new TBitSet(TArrays.copyOf(this.data, this.data.length));
    }

    private class BitSetStream
    extends TSimpleIntStreamImpl {
        private int current;

        private BitSetStream() {
            this.current = TBitSet.this.nextSetBit(0);
        }

        @Override
        public boolean next(IntPredicate consumer) {
            while (this.current >= 0) {
                if (!consumer.test(this.current)) {
                    return true;
                }
                this.current = TBitSet.this.nextSetBit(this.current + 1);
            }
            return false;
        }
    }
}

