/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.nio;

import org.teavm.classlib.java.nio.TArrayBufferViewProvider;
import org.teavm.classlib.java.nio.TByteOrder;
import org.teavm.classlib.java.nio.TShortBuffer;
import org.teavm.classlib.java.nio.TShortBufferImpl;
import org.teavm.jso.typedarrays.ArrayBufferView;
import org.teavm.jso.typedarrays.Int16Array;

class TShortBufferOverTypedArray
extends TShortBufferImpl
implements TArrayBufferViewProvider {
    private boolean readOnly;
    private Int16Array data;
    private short[] array;

    TShortBufferOverTypedArray(int position, int limit, boolean readOnly, Int16Array data, short[] array) {
        super(position, limit);
        this.readOnly = readOnly;
        this.data = data;
        this.array = array;
    }

    @Override
    TShortBuffer duplicate(int start, int capacity, int position, int limit, boolean readOnly) {
        Int16Array slice = new Int16Array(this.data.getBuffer(), this.data.getByteOffset() + start * 2, capacity);
        return new TShortBufferOverTypedArray(position, limit, readOnly, slice, this.array);
    }

    @Override
    boolean readOnly() {
        return this.readOnly;
    }

    @Override
    short getElement(int index) {
        return this.data.get(index);
    }

    @Override
    void putElement(int index, short value) {
        this.data.set(index, value);
    }

    @Override
    boolean isArrayPresent() {
        return this.array != null;
    }

    @Override
    short[] getArray() {
        if (this.array == null) {
            throw new UnsupportedOperationException();
        }
        return this.array;
    }

    @Override
    int getArrayOffset() {
        if (this.array == null) {
            throw new UnsupportedOperationException();
        }
        return this.data.getByteOffset() / 2;
    }

    @Override
    public TByteOrder order() {
        return TByteOrder.nativeOrder();
    }

    @Override
    int capacityImpl() {
        return this.data.getLength();
    }

    @Override
    void getImpl(int index, short[] dst, int offset, int length) {
        Int16Array slice = new Int16Array(this.data.getBuffer(), this.data.getByteOffset() + index * 2, length);
        Int16Array.fromJavaArray((short[])dst).set((ArrayBufferView)slice, offset);
    }

    @Override
    void putImpl(int index, short[] src, int offset, int length) {
        Int16Array slice = new Int16Array(Int16Array.fromJavaArray((short[])src).getBuffer(), offset * 2, length);
        this.data.set((ArrayBufferView)slice, index);
    }

    @Override
    void putImpl(int index, TShortBuffer src, int offset, int length) {
        if (src instanceof TShortBufferOverTypedArray) {
            TShortBufferOverTypedArray srcImpl = (TShortBufferOverTypedArray)src;
            Int16Array slice = new Int16Array(srcImpl.data.getBuffer(), srcImpl.data.getByteOffset() + index * 2, length);
            this.data.set((ArrayBufferView)slice, index);
        } else {
            while (length-- > 0) {
                this.data.set(index++, src.get(offset++));
            }
        }
    }

    @Override
    public ArrayBufferView getArrayBufferView() {
        return this.data;
    }

    @Override
    public int elementSize() {
        return 2;
    }
}

