/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.nio;

import org.teavm.classlib.PlatformDetector;
import org.teavm.classlib.java.nio.TBuffer;
import org.teavm.classlib.java.nio.TBufferOverflowException;
import org.teavm.classlib.java.nio.TBufferUnderflowException;
import org.teavm.classlib.java.nio.TByteOrder;
import org.teavm.classlib.java.nio.TIntBufferNative;
import org.teavm.classlib.java.nio.TIntBufferOverArray;
import org.teavm.classlib.java.nio.TIntBufferOverTypedArray;
import org.teavm.classlib.java.nio.TReadOnlyBufferException;
import org.teavm.interop.Address;
import org.teavm.jso.typedarrays.Int32Array;

public abstract class TIntBuffer
extends TBuffer
implements Comparable<TIntBuffer> {
    TIntBuffer(int position, int limit) {
        this.position = position;
        this.limit = limit;
    }

    public static TIntBuffer allocate(int capacity) {
        if (capacity < 0) {
            throw new IllegalArgumentException("Capacity is negative: " + capacity);
        }
        if (PlatformDetector.isJavaScript()) {
            int[] array = new int[capacity];
            return new TIntBufferOverTypedArray(0, capacity, false, Int32Array.fromJavaArray((int[])array), array);
        }
        if (PlatformDetector.isC() || PlatformDetector.isWebAssembly()) {
            int[] array = new int[capacity];
            return new TIntBufferNative(null, array, 0, capacity, false, array, Address.ofData((int[])array), capacity, false);
        }
        return new TIntBufferOverArray(capacity);
    }

    public static TIntBuffer wrap(int[] array, int offset, int length) {
        if (PlatformDetector.isJavaScript()) {
            TIntBufferOverTypedArray result = new TIntBufferOverTypedArray(0, array.length, false, Int32Array.fromJavaArray((int[])array), array);
            result.position = offset;
            result.limit = offset + length;
            return result;
        }
        if (PlatformDetector.isC() || PlatformDetector.isWebAssembly()) {
            TIntBufferNative result = new TIntBufferNative(null, array, 0, array.length, false, array, Address.ofData((int[])array), array.length, false);
            result.position = offset;
            result.limit = offset + length;
            return result;
        }
        return new TIntBufferOverArray(0, array.length, array, offset, offset + length, false);
    }

    public static TIntBuffer wrap(int[] array) {
        return TIntBuffer.wrap(array, 0, array.length);
    }

    public abstract TIntBuffer slice();

    public abstract TIntBuffer duplicate();

    public abstract TIntBuffer asReadOnlyBuffer();

    public abstract int get();

    public abstract TIntBuffer put(int var1);

    public abstract int get(int var1);

    public abstract TIntBuffer put(int var1, int var2);

    abstract int getElement(int var1);

    abstract void putElement(int var1, int var2);

    public TIntBuffer get(int[] dst, int offset, int length) {
        if (length < 0 || offset < 0 || offset + length > dst.length) {
            throw new IndexOutOfBoundsException();
        }
        if (length > this.remaining()) {
            throw new TBufferUnderflowException();
        }
        this.getImpl(this.position, dst, offset, length);
        this.position += length;
        return this;
    }

    public TIntBuffer get(int index, int[] dst, int offset, int length) {
        if (length < 0 || offset < 0 || offset + length > dst.length || index < 0 || index + length > this.capacity()) {
            throw new IndexOutOfBoundsException();
        }
        this.getImpl(index, dst, offset, length);
        return this;
    }

    public TIntBuffer get(int index, int[] dst) {
        return this.get(index, dst, 0, dst.length);
    }

    abstract void getImpl(int var1, int[] var2, int var3, int var4);

    public TIntBuffer get(int[] dst) {
        return this.get(dst, 0, dst.length);
    }

    public TIntBuffer put(int index, TIntBuffer src, int offset, int length) {
        if (this.isReadOnly()) {
            throw new TReadOnlyBufferException();
        }
        if (index < 0 || index > this.limit() || offset < 0 || offset + length > this.capacity()) {
            throw new IndexOutOfBoundsException();
        }
        this.putImpl(index, src, offset, length);
        return this;
    }

    public TIntBuffer put(int index, int[] src) {
        return this.put(index, src, 0, src.length);
    }

    abstract void putImpl(int var1, TIntBuffer var2, int var3, int var4);

    public TIntBuffer put(TIntBuffer src) {
        if (this.isReadOnly()) {
            throw new TReadOnlyBufferException();
        }
        if (this.remaining() < src.remaining()) {
            throw new TBufferOverflowException();
        }
        this.putImpl(this.position, src, src.position, src.remaining());
        this.position += src.remaining();
        return this;
    }

    public TIntBuffer put(int[] src, int offset, int length) {
        if (this.isReadOnly()) {
            throw new TReadOnlyBufferException();
        }
        if (this.remaining() < length) {
            throw new TBufferOverflowException();
        }
        if (length < 0 || offset < 0 || offset + length > src.length) {
            throw new IndexOutOfBoundsException();
        }
        this.putImpl(this.position, src, offset, length);
        this.position += length;
        return this;
    }

    public TIntBuffer put(int index, int[] src, int offset, int length) {
        if (this.isReadOnly()) {
            throw new TReadOnlyBufferException();
        }
        if (length < 0 || offset < 0 || offset + length > src.length || index < 0 || index + length > this.capacity()) {
            throw new IndexOutOfBoundsException();
        }
        this.putImpl(index, src, offset, length);
        return this;
    }

    public final TIntBuffer put(int[] src) {
        return this.put(src, 0, src.length);
    }

    abstract void putImpl(int var1, int[] var2, int var3, int var4);

    @Override
    public final boolean hasArray() {
        return this.isArrayPresent();
    }

    public final int[] array() {
        return this.getArray();
    }

    @Override
    public final int arrayOffset() {
        return this.getArrayOffset();
    }

    abstract boolean isArrayPresent();

    abstract int[] getArray();

    abstract int getArrayOffset();

    public abstract TIntBuffer compact();

    @Override
    public abstract boolean isDirect();

    public String toString() {
        return "[IntBuffer position=" + this.position + ", limit=" + this.limit + ", capacity=" + this.capacity() + ", mark " + (String)(this.mark >= 0 ? " at " + this.mark : " is not set") + "]";
    }

    public int hashCode() {
        int hashCode = 0;
        int pos = this.position;
        for (int i = this.position; i < this.limit; ++i) {
            hashCode = 31 * hashCode + this.getElement(pos++);
        }
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof TIntBuffer)) {
            return false;
        }
        TIntBuffer other = (TIntBuffer)obj;
        int sz = this.remaining();
        if (sz != other.remaining()) {
            return false;
        }
        int a = this.position;
        int b = other.position;
        for (int i = 0; i < sz; ++i) {
            if (this.getElement(a++) == other.getElement(b++)) continue;
            return false;
        }
        return true;
    }

    @Override
    public int compareTo(TIntBuffer other) {
        if (this == other) {
            return 0;
        }
        int sz = Math.min(this.remaining(), other.remaining());
        int a = this.position;
        int b = other.position;
        for (int i = 0; i < sz; ++i) {
            int r;
            if ((r = Integer.compare(this.getElement(a++), other.getElement(b++))) == 0) continue;
            return r;
        }
        return Integer.compare(this.remaining(), other.remaining());
    }

    public abstract TByteOrder order();

    @Override
    public final TIntBuffer mark() {
        super.mark();
        return this;
    }

    @Override
    public final TIntBuffer reset() {
        super.reset();
        return this;
    }

    @Override
    public final TIntBuffer clear() {
        super.clear();
        return this;
    }

    @Override
    public final TIntBuffer flip() {
        super.flip();
        return this;
    }

    @Override
    public final TIntBuffer rewind() {
        super.rewind();
        return this;
    }

    @Override
    public TIntBuffer limit(int newLimit) {
        super.limit(newLimit);
        return this;
    }

    @Override
    public TIntBuffer position(int newPosition) {
        super.position(newPosition);
        return this;
    }
}

