/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.nio;

import org.teavm.classlib.PlatformDetector;
import org.teavm.classlib.java.nio.TBuffer;
import org.teavm.classlib.java.nio.TBufferOverflowException;
import org.teavm.classlib.java.nio.TBufferUnderflowException;
import org.teavm.classlib.java.nio.TByteOrder;
import org.teavm.classlib.java.nio.TFloatBufferNative;
import org.teavm.classlib.java.nio.TFloatBufferOverArray;
import org.teavm.classlib.java.nio.TFloatBufferOverTypedArray;
import org.teavm.classlib.java.nio.TReadOnlyBufferException;
import org.teavm.interop.Address;
import org.teavm.jso.typedarrays.Float32Array;

public abstract class TFloatBuffer
extends TBuffer
implements Comparable<TFloatBuffer> {
    TFloatBuffer(int position, int limit) {
        this.position = position;
        this.limit = limit;
    }

    public static TFloatBuffer allocate(int capacity) {
        if (capacity < 0) {
            throw new IllegalArgumentException("Capacity is negative: " + capacity);
        }
        if (PlatformDetector.isJavaScript()) {
            float[] array = new float[capacity];
            return new TFloatBufferOverTypedArray(0, capacity, false, Float32Array.fromJavaArray((float[])array), array);
        }
        if (PlatformDetector.isC() || PlatformDetector.isWebAssembly()) {
            float[] array = new float[capacity];
            return new TFloatBufferNative(null, array, 0, capacity, false, array, Address.ofData((float[])array), capacity, false);
        }
        return new TFloatBufferOverArray(capacity);
    }

    public static TFloatBuffer wrap(float[] array, int offset, int length) {
        if (PlatformDetector.isJavaScript()) {
            TFloatBufferOverTypedArray result = new TFloatBufferOverTypedArray(0, array.length, false, Float32Array.fromJavaArray((float[])array), array);
            result.position = offset;
            result.limit = offset + length;
            return result;
        }
        if (PlatformDetector.isC() || PlatformDetector.isWebAssembly()) {
            TFloatBufferNative result = new TFloatBufferNative(null, array, 0, array.length, false, array, Address.ofData((float[])array), array.length, false);
            result.position = offset;
            result.limit = offset + length;
            return result;
        }
        return new TFloatBufferOverArray(0, array.length, array, offset, offset + length, false);
    }

    public static TFloatBuffer wrap(float[] array) {
        return TFloatBuffer.wrap(array, 0, array.length);
    }

    public abstract TFloatBuffer slice();

    public abstract TFloatBuffer duplicate();

    public abstract TFloatBuffer asReadOnlyBuffer();

    public abstract float get();

    public abstract TFloatBuffer put(float var1);

    public abstract float get(int var1);

    public abstract TFloatBuffer put(int var1, float var2);

    abstract float getElement(int var1);

    abstract void putElement(int var1, float var2);

    public TFloatBuffer get(float[] dst, int offset, int length) {
        if (length < 0 || offset < 0 || offset + length > dst.length) {
            throw new IndexOutOfBoundsException();
        }
        if (length > this.remaining()) {
            throw new TBufferUnderflowException();
        }
        this.getImpl(this.position, dst, offset, length);
        this.position += length;
        return this;
    }

    public TFloatBuffer get(int index, float[] dst, int offset, int length) {
        if (length < 0 || offset < 0 || offset + length > dst.length || index < 0 || index + length > this.capacity()) {
            throw new IndexOutOfBoundsException();
        }
        this.getImpl(index, dst, offset, length);
        return this;
    }

    public TFloatBuffer get(int index, float[] dst) {
        return this.get(index, dst, 0, dst.length);
    }

    abstract void getImpl(int var1, float[] var2, int var3, int var4);

    public TFloatBuffer get(float[] dst) {
        return this.get(dst, 0, dst.length);
    }

    public TFloatBuffer put(int index, TFloatBuffer src, int offset, int length) {
        if (this.isReadOnly()) {
            throw new TReadOnlyBufferException();
        }
        if (index < 0 || index > this.limit() || offset < 0 || offset + length > this.capacity()) {
            throw new IndexOutOfBoundsException();
        }
        this.putImpl(index, src, offset, length);
        return this;
    }

    abstract void putImpl(int var1, TFloatBuffer var2, int var3, int var4);

    public TFloatBuffer put(TFloatBuffer src) {
        if (this.isReadOnly()) {
            throw new TReadOnlyBufferException();
        }
        if (this.remaining() < src.remaining()) {
            throw new TBufferOverflowException();
        }
        this.putImpl(this.position, src, src.position, src.remaining());
        this.position += src.remaining();
        return this;
    }

    public TFloatBuffer put(float[] src, int offset, int length) {
        if (this.isReadOnly()) {
            throw new TReadOnlyBufferException();
        }
        if (this.remaining() < length) {
            throw new TBufferOverflowException();
        }
        if (length < 0 || offset < 0 || offset + length > src.length) {
            throw new IndexOutOfBoundsException();
        }
        this.putImpl(this.position, src, offset, length);
        this.position += length;
        return this;
    }

    public TFloatBuffer put(int index, float[] src, int offset, int length) {
        if (this.isReadOnly()) {
            throw new TReadOnlyBufferException();
        }
        if (length < 0 || offset < 0 || offset + length > src.length || index < 0 || index + length > this.capacity()) {
            throw new IndexOutOfBoundsException();
        }
        this.putImpl(index, src, offset, length);
        return this;
    }

    public final TFloatBuffer put(float[] src) {
        return this.put(src, 0, src.length);
    }

    public TFloatBuffer put(int index, float[] src) {
        return this.put(index, src, 0, src.length);
    }

    abstract void putImpl(int var1, float[] var2, int var3, int var4);

    @Override
    public final boolean hasArray() {
        return this.isArrayPresent();
    }

    public final float[] array() {
        return this.getArray();
    }

    @Override
    public final int arrayOffset() {
        return this.getArrayOffset();
    }

    abstract boolean isArrayPresent();

    abstract float[] getArray();

    abstract int getArrayOffset();

    public abstract TFloatBuffer compact();

    @Override
    public abstract boolean isDirect();

    public String toString() {
        return "[FloatBuffer position=" + this.position + ", limit=" + this.limit + ", capacity=" + this.capacity() + ", mark " + (String)(this.mark >= 0 ? " at " + this.mark : " is not set") + "]";
    }

    public int hashCode() {
        int hashCode = 0;
        int pos = this.position;
        for (int i = this.position; i < this.limit; ++i) {
            hashCode = 31 * hashCode + Float.floatToIntBits(this.getElement(pos++));
        }
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof TFloatBuffer)) {
            return false;
        }
        TFloatBuffer other = (TFloatBuffer)obj;
        int sz = this.remaining();
        if (sz != other.remaining()) {
            return false;
        }
        int a = this.position;
        int b = other.position;
        for (int i = 0; i < sz; ++i) {
            if (this.getElement(a++) == other.getElement(b++)) continue;
            return false;
        }
        return true;
    }

    @Override
    public int compareTo(TFloatBuffer other) {
        if (this == other) {
            return 0;
        }
        int sz = Math.min(this.remaining(), other.remaining());
        int a = this.position;
        int b = other.position;
        for (int i = 0; i < sz; ++i) {
            int r;
            if ((r = Float.compare(this.getElement(a++), other.getElement(b++))) == 0) continue;
            return r;
        }
        return Integer.compare(this.remaining(), other.remaining());
    }

    public abstract TByteOrder order();

    @Override
    public final TFloatBuffer mark() {
        super.mark();
        return this;
    }

    @Override
    public final TFloatBuffer reset() {
        super.reset();
        return this;
    }

    @Override
    public final TFloatBuffer clear() {
        super.clear();
        return this;
    }

    @Override
    public final TFloatBuffer flip() {
        super.flip();
        return this;
    }

    @Override
    public final TFloatBuffer rewind() {
        super.rewind();
        return this;
    }

    @Override
    public TFloatBuffer limit(int newLimit) {
        super.limit(newLimit);
        return this;
    }

    @Override
    public TFloatBuffer position(int newPosition) {
        super.position(newPosition);
        return this;
    }
}

