/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.net;

import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Objects;

public final class TURLEncoder {
    static final String digits = "0123456789ABCDEF";

    private TURLEncoder() {
    }

    @Deprecated
    public static String encode(String s) {
        StringBuilder buf = new StringBuilder(s.length() + 16);
        for (int i = 0; i < s.length(); ++i) {
            byte[] bytes;
            char ch = s.charAt(i);
            if (ch >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z' || ch >= '0' && ch <= '9' || ".-*_".indexOf(ch) > -1) {
                buf.append(ch);
                continue;
            }
            if (ch == ' ') {
                buf.append('+');
                continue;
            }
            for (byte b : bytes = new String(new char[]{ch}).getBytes(StandardCharsets.UTF_8)) {
                buf.append('%');
                buf.append(digits.charAt((b & 0xF0) >> 4));
                buf.append(digits.charAt(b & 0xF));
            }
        }
        return buf.toString();
    }

    public static String encode(String s, Charset enc) {
        Objects.requireNonNull(s);
        Objects.requireNonNull(enc);
        StringBuffer buf = new StringBuffer(s.length() + 16);
        int start = -1;
        for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            if (ch >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z' || ch >= '0' && ch <= '9' || " .-*_".indexOf(ch) > -1) {
                if (start >= 0) {
                    TURLEncoder.convert(s.substring(start, i), buf, enc);
                    start = -1;
                }
                if (ch != ' ') {
                    buf.append(ch);
                    continue;
                }
                buf.append('+');
                continue;
            }
            if (start >= 0) continue;
            start = i;
        }
        if (start >= 0) {
            TURLEncoder.convert(s.substring(start), buf, enc);
        }
        return buf.toString();
    }

    public static String encode(String s, String enc) throws UnsupportedEncodingException {
        Objects.requireNonNull(s);
        Objects.requireNonNull(enc);
        try {
            return TURLEncoder.encode(s, Charset.forName(enc));
        }
        catch (UnsupportedCharsetException e) {
            throw new UnsupportedEncodingException(enc);
        }
    }

    private static void convert(String s, StringBuffer buf, Charset enc) {
        byte[] bytes = s.getBytes(enc);
        for (int j = 0; j < bytes.length; ++j) {
            buf.append('%');
            buf.append(digits.charAt((bytes[j] & 0xF0) >> 4));
            buf.append(digits.charAt(bytes[j] & 0xF));
        }
    }
}

