/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.lang;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Properties;
import java.util.ServiceLoader;
import org.teavm.backend.javascript.codegen.SourceWriter;
import org.teavm.backend.javascript.rendering.RenderingUtil;
import org.teavm.backend.javascript.spi.Injector;
import org.teavm.backend.javascript.spi.InjectorContext;
import org.teavm.classlib.ResourceSupplier;
import org.teavm.classlib.ResourceSupplierContext;
import org.teavm.classlib.impl.Base64Impl;
import org.teavm.model.ListableClassReaderSource;
import org.teavm.model.MethodReference;

public class ClassLoaderNativeGenerator
implements Injector {
    public void generate(InjectorContext context, MethodReference methodRef) {
        switch (methodRef.getName()) {
            case "supplyResources": {
                this.generateSupplyResources(context);
            }
        }
    }

    private void generateSupplyResources(InjectorContext context) {
        SourceWriter writer = context.getWriter();
        writer.append("{").indent();
        ClassLoader classLoader = context.getClassLoader();
        HashSet<String> resourceSet = new HashSet<String>();
        SupplierContextImpl supplierContext = new SupplierContextImpl(context);
        for (ResourceSupplier supplier : ServiceLoader.load(ResourceSupplier.class, classLoader)) {
            String[] resources = supplier.supplyResources((ResourceSupplierContext)supplierContext);
            if (resources == null) continue;
            resourceSet.addAll(Arrays.asList(resources));
        }
        boolean first = true;
        for (String resource : resourceSet) {
            try {
                InputStream input = classLoader.getResourceAsStream(resource);
                try {
                    if (input == null) continue;
                    if (!first) {
                        writer.append(',');
                    }
                    first = false;
                    writer.newLine();
                    byte[] dataBytes = Base64Impl.encode(new BufferedInputStream(input).readAllBytes(), true);
                    char[] dataChars = new char[dataBytes.length];
                    for (int i = 0; i < dataBytes.length; ++i) {
                        dataChars[i] = (char)dataBytes[i];
                    }
                    RenderingUtil.writeString((SourceWriter)writer, (String)resource);
                    writer.append(':').ws();
                    RenderingUtil.writeString((SourceWriter)writer, (String)new String(dataChars));
                }
                finally {
                    if (input == null) continue;
                    input.close();
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (!first) {
            writer.newLine();
        }
        writer.outdent().append('}');
    }

    static class SupplierContextImpl
    implements ResourceSupplierContext {
        InjectorContext injectorContext;

        public SupplierContextImpl(InjectorContext injectorContext) {
            this.injectorContext = injectorContext;
        }

        public ClassLoader getClassLoader() {
            return this.injectorContext.getClassLoader();
        }

        public ListableClassReaderSource getClassSource() {
            return this.injectorContext.getClassSource();
        }

        public Properties getProperties() {
            return this.injectorContext.getProperties();
        }
    }
}

