/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.util;

import java.lang.reflect.Array;
import org.teavm.classlib.java.util.TCollection;
import org.teavm.classlib.java.util.TDeque;
import org.teavm.classlib.java.util.TIterator;
import org.teavm.classlib.java.util.TObjects;

class TReversedDeque<E>
implements TDeque<E> {
    private final TDeque<E> base;

    TReversedDeque(TDeque<E> base) {
        this.base = base;
    }

    @Override
    public TDeque<E> reversed() {
        return this.base;
    }

    @Override
    public TIterator<E> iterator() {
        return this.base.descendingIterator();
    }

    @Override
    public int size() {
        return this.base.size();
    }

    @Override
    public boolean isEmpty() {
        return this.base.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.base.contains(o);
    }

    @Override
    public Object[] toArray() {
        Object[] arr = new Object[this.size()];
        int i = 0;
        TIterator<E> it = this.base.descendingIterator();
        while (it.hasNext()) {
            arr[i++] = it.next();
        }
        return arr;
    }

    @Override
    public <T> T[] toArray(T[] a) {
        int i;
        int size = this.size();
        if (a.length < size) {
            a = (Object[])Array.newInstance(a.getClass().getComponentType(), size);
        } else {
            for (i = size; i < a.length; ++i) {
                a[i] = null;
            }
        }
        i = 0;
        TIterator<E> it = this.base.descendingIterator();
        while (it.hasNext()) {
            a[i++] = it.next();
        }
        return a;
    }

    @Override
    public boolean add(E e) {
        this.base.addFirst(e);
        return true;
    }

    @Override
    public void addFirst(E e) {
        this.base.addLast(e);
    }

    @Override
    public void addLast(E e) {
        this.base.addFirst(e);
    }

    @Override
    public boolean remove(Object o) {
        TIterator<E> it = this.base.descendingIterator();
        while (it.hasNext()) {
            E e = it.next();
            if (!TObjects.equals(e, o)) continue;
            it.remove();
            return true;
        }
        return false;
    }

    @Override
    public boolean containsAll(TCollection<?> c) {
        return this.base.contains(c);
    }

    @Override
    public boolean addAll(TCollection<? extends E> c) {
        boolean changed = false;
        TIterator it = c.iterator();
        while (it.hasNext()) {
            this.addFirst(it.next());
            changed = true;
        }
        return changed;
    }

    @Override
    public boolean removeAll(TCollection<?> c) {
        boolean changed = false;
        TIterator<E> it = this.base.descendingIterator();
        while (it.hasNext()) {
            E e = it.next();
            if (!c.contains(e)) continue;
            it.remove();
            changed = true;
        }
        return changed;
    }

    @Override
    public boolean retainAll(TCollection<?> c) {
        boolean changed = false;
        TIterator<E> it = this.base.descendingIterator();
        while (it.hasNext()) {
            E e = it.next();
            if (c.contains(e)) continue;
            it.remove();
            changed = true;
        }
        return changed;
    }

    @Override
    public void clear() {
        this.base.clear();
    }

    @Override
    public boolean offerFirst(E e) {
        return this.base.offerLast(e);
    }

    @Override
    public boolean offerLast(E e) {
        return this.base.offerFirst(e);
    }

    @Override
    public E pollFirst() {
        return this.base.pollLast();
    }

    @Override
    public E pollLast() {
        return this.base.pollFirst();
    }

    @Override
    public E peekFirst() {
        return this.base.peekLast();
    }

    @Override
    public E peekLast() {
        return this.base.peekFirst();
    }

    @Override
    public boolean removeFirstOccurrence(Object o) {
        return this.base.removeLastOccurrence(o);
    }

    @Override
    public boolean removeLastOccurrence(Object o) {
        return this.base.removeFirstOccurrence(o);
    }

    @Override
    public void push(E e) {
        this.base.addLast(e);
    }

    @Override
    public E pop() {
        return this.base.removeLast();
    }

    @Override
    public TIterator<E> descendingIterator() {
        return this.base.iterator();
    }

    @Override
    public boolean offer(E e) {
        return this.base.offerFirst(e);
    }

    @Override
    public E remove() {
        return this.base.removeLast();
    }

    @Override
    public E removeFirst() {
        return this.base.removeLast();
    }

    @Override
    public E removeLast() {
        return this.base.removeFirst();
    }

    @Override
    public E poll() {
        return this.base.pollLast();
    }

    @Override
    public E element() {
        return this.base.getLast();
    }

    @Override
    public E getFirst() {
        return this.base.getLast();
    }

    @Override
    public E getLast() {
        return this.base.getFirst();
    }

    @Override
    public E peek() {
        return this.base.peekLast();
    }
}

