/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.util;

import org.teavm.classlib.java.util.TConcurrentModificationException;
import org.teavm.classlib.java.util.TIterator;
import org.teavm.classlib.java.util.TLinkedHashMap;
import org.teavm.classlib.java.util.TMap;
import org.teavm.classlib.java.util.TNoSuchElementException;

class TLinkedHashMapIterator<K, V> {
    private final TLinkedHashMap<K, V> base;
    private final boolean reversed;
    private int expectedModCount;
    private TLinkedHashMap.LinkedHashMapEntry<K, V> futureEntry;
    TLinkedHashMap.LinkedHashMapEntry<K, V> currentEntry;

    TLinkedHashMapIterator(TLinkedHashMap<K, V> base, boolean reversed) {
        this.base = base;
        this.reversed = reversed;
        this.expectedModCount = base.modCount;
        this.futureEntry = reversed ? base.tail : base.head;
    }

    public boolean hasNext() {
        return this.futureEntry != null;
    }

    final void checkConcurrentMod() throws TConcurrentModificationException {
        if (this.expectedModCount != this.base.modCount) {
            throw new TConcurrentModificationException();
        }
    }

    final void makeNext() {
        this.checkConcurrentMod();
        if (!this.hasNext()) {
            throw new TNoSuchElementException();
        }
        this.currentEntry = this.futureEntry;
        this.futureEntry = this.reversed ? this.futureEntry.chainBackward : this.futureEntry.chainForward;
    }

    public void remove() {
        if (this.currentEntry == null) {
            throw new IllegalStateException();
        }
        this.checkConcurrentMod();
        this.base.removeLinkedEntry(this.currentEntry);
        this.currentEntry = null;
        ++this.expectedModCount;
    }

    static class ValueIterator<K, V>
    extends TLinkedHashMapIterator<K, V>
    implements TIterator<V> {
        ValueIterator(TLinkedHashMap<K, V> map, boolean reversed) {
            super(map, reversed);
        }

        @Override
        public V next() {
            this.makeNext();
            return (V)this.currentEntry.value;
        }
    }

    static class KeyIterator<K, V>
    extends TLinkedHashMapIterator<K, V>
    implements TIterator<K> {
        KeyIterator(TLinkedHashMap<K, V> map, boolean reversed) {
            super(map, reversed);
        }

        @Override
        public K next() {
            this.makeNext();
            return (K)this.currentEntry.key;
        }
    }

    static class EntryIterator<K, V>
    extends TLinkedHashMapIterator<K, V>
    implements TIterator<TMap.Entry<K, V>> {
        EntryIterator(TLinkedHashMap<K, V> map, boolean reversed) {
            super(map, reversed);
        }

        @Override
        public TMap.Entry<K, V> next() {
            this.makeNext();
            return this.currentEntry;
        }
    }
}

