/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.lang.ref;

import org.teavm.classlib.PlatformDetector;
import org.teavm.classlib.java.lang.TThread;
import org.teavm.classlib.java.lang.TThreadInterruptHandler;
import org.teavm.classlib.java.lang.ref.TReference;
import org.teavm.interop.Async;
import org.teavm.interop.AsyncCallback;
import org.teavm.platform.Platform;
import org.teavm.platform.PlatformRunnable;
import org.teavm.runtime.EventQueue;

public class TReferenceQueue<T> {
    private RemoveCallback firstCallback;
    private RemoveCallback lastCallback;

    public TReference<T> poll() {
        return null;
    }

    public TReference<T> remove() throws InterruptedException {
        return this.remove(0L);
    }

    @Async
    public native TReference<T> remove(long var1) throws InterruptedException;

    public void remove(long timeout, AsyncCallback<TReference<T>> callback) {
        TReference<T> ref = this.poll();
        if (ref != null) {
            callback.complete(ref);
        } else {
            RemoveCallback callbackWrapper = new RemoveCallback(callback);
            if (timeout != 0L) {
                callbackWrapper.id = PlatformDetector.isLowLevel() ? EventQueue.offer((EventQueue.Event)callbackWrapper, (long)(timeout + System.currentTimeMillis())) : Platform.schedule((PlatformRunnable)callbackWrapper, (int)((int)timeout));
            }
            TThread.currentThread().interruptHandler = callbackWrapper;
            this.registerCallback(callbackWrapper);
        }
    }

    private void registerCallback(RemoveCallback callback) {
        callback.prev = this.lastCallback;
        if (this.lastCallback != null) {
            this.lastCallback.next = callback;
        } else {
            this.firstCallback = callback;
        }
        this.lastCallback = callback;
    }

    protected boolean reportNext(TReference<T> ref) {
        if (this.firstCallback == null) {
            return false;
        }
        RemoveCallback callback = this.firstCallback;
        callback.complete(ref);
        return true;
    }

    private class RemoveCallback
    implements EventQueue.Event,
    PlatformRunnable,
    AsyncCallback<TReference<T>>,
    TThreadInterruptHandler {
        RemoveCallback next;
        RemoveCallback prev;
        int id;
        AsyncCallback<TReference<T>> callback;

        RemoveCallback(AsyncCallback<TReference<T>> callback) {
            this.callback = callback;
        }

        public void run() {
            if (PlatformDetector.isLowLevel()) {
                EventQueue.kill((int)this.id);
            } else {
                Platform.killSchedule((int)this.id);
            }
            this.complete(null);
        }

        public void complete(TReference<T> result) {
            AsyncCallback callback = this.callback;
            if (callback != null) {
                this.remove();
                callback.complete(result);
            }
        }

        public void error(Throwable e) {
            AsyncCallback callback = this.callback;
            if (callback != null) {
                this.remove();
                callback.error(e);
            }
        }

        @Override
        public void interrupted() {
            AsyncCallback callback = this.callback;
            if (callback != null) {
                this.remove();
                callback.error((Throwable)new InterruptedException());
            }
        }

        private void remove() {
            TThread.currentThread().interruptHandler = null;
            this.callback = null;
            if (this.prev != null) {
                this.prev.next = this.next;
            } else {
                TReferenceQueue.this.firstCallback = this.next;
            }
            if (this.next != null) {
                this.next.prev = this.prev;
            } else {
                TReferenceQueue.this.lastCallback = this.prev;
            }
            this.next = null;
            this.prev = null;
        }
    }
}

