/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.impl;

import org.teavm.dependency.DependencyChecker;
import org.teavm.dependency.DependencyListener;
import org.teavm.dependency.DependencyNode;
import org.teavm.dependency.DependencyStack;
import org.teavm.dependency.FieldDependency;
import org.teavm.dependency.MethodDependency;
import org.teavm.model.ClassReader;
import org.teavm.model.MethodDescriptor;
import org.teavm.model.MethodReader;
import org.teavm.model.ValueType;

public class EnumDependencySupport
implements DependencyListener {
    private DependencyNode allEnums;
    private volatile DependencyStack enumConstantsStack;

    public void started(DependencyChecker dependencyChecker) {
        this.allEnums = dependencyChecker.createNode();
    }

    public void classAchieved(DependencyChecker dependencyChecker, String className) {
        MethodReader method;
        ClassReader cls = dependencyChecker.getClassSource().get(className);
        if (cls == null || cls.getParent() == null || !cls.getParent().equals("java.lang.Enum")) {
            return;
        }
        this.allEnums.propagate(className);
        if (this.enumConstantsStack != null && (method = cls.getMethod(new MethodDescriptor("values", new ValueType[]{ValueType.arrayOf((ValueType)ValueType.object((String)cls.getName()))}))) != null) {
            dependencyChecker.linkMethod(method.getReference(), this.enumConstantsStack).use();
        }
    }

    public void methodAchieved(DependencyChecker dependencyChecker, MethodDependency method) {
        if (method.getReference().getClassName().equals("java.lang.Class") && method.getReference().getName().equals("getEnumConstantsImpl")) {
            this.allEnums.connect(method.getResult().getArrayItem());
            method.getResult().propagate("[java.lang.Enum");
            this.enumConstantsStack = method.getStack();
            for (String cls : dependencyChecker.getAchievableClasses()) {
                this.classAchieved(dependencyChecker, cls);
            }
        }
    }

    public void fieldAchieved(DependencyChecker dependencyChecker, FieldDependency field) {
    }
}

